/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.model.History;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.internal.intro.impl.swt.PageForm;
import org.eclipse.ui.internal.intro.impl.swt.PageFormWithNavigation;
import org.eclipse.ui.internal.intro.impl.swt.PageStyleManager;
import org.eclipse.ui.internal.intro.impl.swt.RootPageForm;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;

public class FormIntroPartImplementation
extends AbstractIntroPartImplementation
implements IIntroContentProviderSite,
IPropertyListener {
    private FormToolkit toolkit;
    private ScrolledPageBook mainPageBook;
    private PageForm pageForm;
    private PageFormWithNavigation pageFormWithNav;
    private IntroModelRoot model = this.getModel();
    private SharedStyleManager sharedStyleManager = new SharedStyleManager(this.getModel());
    private Hyperlink welcomeLink;

    static {
        ImageUtil.registerImage("rootLink", "overview_48.png");
        ImageUtil.registerImage("rootLinkSmall", "overview_32.png");
        ImageUtil.registerImage("formBg", "form_banner.png");
        ImageUtil.registerImage("link", "welcome_item.gif");
    }

    @Override
    protected void updateNavigationActionsState() {
        if (this.getModel().isDynamic()) {
            this.forwardAction.setEnabled(this.history.canNavigateForward());
            this.backAction.setEnabled(this.history.canNavigateBackward());
            return;
        }
    }

    @Override
    public void createPartControl(Composite container) {
        if (this.getModel().isDynamic()) {
            this.dynamicCreatePartControl(container);
        } else {
            this.staticCreatePartControl(container);
        }
    }

    private void dynamicCreatePartControl(Composite container) {
        Image bgImage;
        this.toolkit = new FormToolkit(container.getDisplay());
        Color bg = this.sharedStyleManager.getColor(this.toolkit, "bg");
        if (bg != null) {
            this.toolkit.setBackground(bg);
        }
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        Form mainForm = this.toolkit.createForm(container);
        Color fg = this.sharedStyleManager.getColor(this.toolkit, "title.fg");
        if (fg != null) {
            mainForm.setForeground(fg);
        }
        if ((bgImage = this.sharedStyleManager.getImage("title.image", null, null)) != null) {
            mainForm.setBackgroundImage(bgImage);
            String repeat = this.sharedStyleManager.getProperty("title.image.repeat");
            if (repeat != null && repeat.equalsIgnoreCase("true")) {
                mainForm.setBackgroundImageTiled(true);
            }
        }
        this.mainPageBook = this.createMainPageBook(this.toolkit, mainForm);
        this.getModel().addPropertyListener(this);
        this.addToolBarActions();
    }

    private ScrolledPageBook createMainPageBook(FormToolkit toolkit, Form form) {
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout());
        ScrolledPageBook pageBook = toolkit.createPageBook(body, 768);
        pageBook.setLayoutData((Object)new GridData(1808));
        if (this.sharedStyleManager.useCustomHomePagelayout()) {
            RootPageForm rootPageForm = new RootPageForm(toolkit, this.model, form);
            rootPageForm.createPartControl(pageBook, this.sharedStyleManager);
            rootPageForm.setContentProviderSite(this);
        }
        this.pageForm = new PageForm(toolkit, this.model, form);
        this.pageForm.setContentProviderSite(this);
        this.pageForm.createPartControl(pageBook, this.sharedStyleManager);
        this.pageFormWithNav = new PageFormWithNavigation(toolkit, this.model, form);
        this.pageFormWithNav.setContentProviderSite(this);
        this.pageFormWithNav.createPartControl(pageBook, this.sharedStyleManager);
        String cachedPage = this.getCachedCurrentPage();
        if (cachedPage != null & !History.isURL(cachedPage)) {
            this.model.setCurrentPageId(cachedPage);
        }
        AbstractIntroPage pageToShow = this.getModel().getCurrentPage();
        PageStyleManager styleManager = new PageStyleManager(pageToShow, this.sharedStyleManager.getProperties());
        boolean pageHasNavigation = styleManager.showHomePageNavigation();
        if (pageToShow != null) {
            if (pageBook.hasPage((Object)pageToShow.getId())) {
                pageBook.showPage((Object)pageToShow.getId());
            } else if (pageHasNavigation) {
                this.pageFormWithNav.showPage(pageToShow, this.sharedStyleManager);
                pageBook.showPage((Object)PageFormWithNavigation.PAGE_FORM_WITH_NAVIGATION_ID);
            } else {
                this.pageForm.showPage(pageToShow, this.sharedStyleManager);
                pageBook.showPage((Object)PageForm.PAGE_FORM_ID);
            }
            this.updateHistory(pageToShow);
        }
        return pageBook;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            String pageId = this.getModel().getCurrentPageId();
            if (pageId == null || pageId.isEmpty()) {
                return;
            }
            this.showPage(this.getModel().getCurrentPage());
        }
    }

    @Override
    protected void addToolBarActions() {
        IActionBars actionBars = this.getIntroPart().getIntroSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.homeAction);
        toolBarManager.add((IAction)this.backAction);
        toolBarManager.add((IAction)this.forwardAction);
        if (IntroPlugin.DEBUG_TOOLBAR) {
            toolBarManager.add((IAction)this.viewIntroModelAction);
        }
        toolBarManager.update(true);
        actionBars.updateActionBars();
        this.updateNavigationActionsState();
    }

    @Override
    protected void doStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (this.getModel().isDynamic()) {
            this.dynamicStandbyStateChanged(standby, isStandbyPartNeeded);
        } else {
            this.staticStandbyStateChanged(standby);
        }
    }

    public void dynamicStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded || standby) {
            this.homeAction.setEnabled(false);
            this.forwardAction.setEnabled(false);
            this.backAction.setEnabled(false);
        } else {
            this.homeAction.setEnabled(true);
            this.updateNavigationActionsState();
        }
        if (isStandbyPartNeeded) {
            return;
        }
        AbstractIntroPage pageToShow = null;
        if (standby) {
            pageToShow = this.getModel().getStandbyPage();
            if (pageToShow == null) {
                pageToShow = this.getModel().getHomePage();
            }
        } else {
            pageToShow = this.getModel().getCurrentPage();
        }
        this.showPage(pageToShow);
    }

    private boolean showPage(AbstractIntroPage pageToShow) {
        boolean pageisCached = this.showCachedPage(pageToShow);
        if (!pageToShow.isDynamic()) {
            Util.openBrowser(pageToShow.getUrl());
            return true;
        }
        if (!pageisCached) {
            PageStyleManager styleManager = new PageStyleManager(pageToShow, this.sharedStyleManager.getProperties());
            boolean pageHasNavigation = styleManager.showHomePageNavigation();
            if (pageHasNavigation) {
                this.pageFormWithNav.showPage(pageToShow, this.sharedStyleManager);
                this.mainPageBook.showPage((Object)PageFormWithNavigation.PAGE_FORM_WITH_NAVIGATION_ID);
            } else {
                this.pageForm.showPage(pageToShow, this.sharedStyleManager);
                this.mainPageBook.showPage((Object)PageForm.PAGE_FORM_ID);
            }
        }
        return true;
    }

    private boolean showCachedPage(AbstractIntroPage page) {
        String formPageId = null;
        if (this.pageForm.hasPage(page.getId())) {
            this.pageForm.showPage(page, this.sharedStyleManager);
            formPageId = PageForm.PAGE_FORM_ID;
        } else if (this.pageFormWithNav.hasPage(page.getId())) {
            this.pageFormWithNav.showPage(page, this.sharedStyleManager);
            formPageId = PageFormWithNavigation.PAGE_FORM_WITH_NAVIGATION_ID;
        } else if (this.mainPageBook.hasPage((Object)page.getId())) {
            formPageId = page.getId();
        } else {
            return false;
        }
        this.mainPageBook.showPage((Object)formPageId);
        return true;
    }

    private void removeCachedPage(AbstractIntroPage page) {
        if (this.pageForm.hasPage(page.getId())) {
            this.pageForm.removePage(page.getId());
        } else if (this.pageFormWithNav.hasPage(page.getId())) {
            this.pageFormWithNav.removePage(page.getId());
        } else if (this.mainPageBook.hasPage((Object)page.getId())) {
            this.mainPageBook.removePage((Object)page.getId());
        } else {
            return;
        }
    }

    @Override
    public void reflow(IIntroContentProvider provider, boolean incremental) {
        AbstractIntroPage page = ContentProviderManager.getInst().getContentProviderParentPage(provider);
        if (incremental) {
            if (this.pageForm.hasPage(page.getId())) {
                this.pageForm.reflow();
            } else if (this.pageFormWithNav.hasPage(page.getId())) {
                this.pageFormWithNav.reflow();
            } else if (this.mainPageBook.hasPage((Object)page.getId())) {
                this.mainPageBook.reflow(true);
            }
        } else {
            this.removeCachedPage(page);
            this.showPage(this.model.getCurrentPage());
        }
    }

    @Override
    public void setFocus() {
        if (this.model.isDynamic() && this.mainPageBook.getCurrentPage() != null) {
            this.mainPageBook.getCurrentPage().setFocus();
        }
    }

    @Override
    public boolean navigateBackward() {
        boolean success = false;
        if (this.getModel().isDynamic() && this.history.canNavigateBackward()) {
            this.history.navigateHistoryBackward();
            if (this.history.currentLocationIsUrl()) {
                success = Util.openBrowser(this.history.getCurrentLocationAsUrl());
            } else {
                CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
                currentIntroPart.getControl().setRedraw(false);
                success = this.getModel().setCurrentPageId(this.history.getCurrentLocationAsPage().getId());
                currentIntroPart.getControl().setRedraw(true);
            }
        }
        this.updateNavigationActionsState();
        return success;
    }

    @Override
    public boolean navigateForward() {
        boolean success = false;
        if (this.getModel().isDynamic() && this.history.canNavigateForward()) {
            this.history.navigateHistoryForward();
            if (this.history.currentLocationIsUrl()) {
                success = Util.openBrowser(this.history.getCurrentLocationAsUrl());
            } else {
                CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
                currentIntroPart.getControl().setRedraw(false);
                success = this.getModel().setCurrentPageId(this.history.getCurrentLocationAsPage().getId());
                currentIntroPart.getControl().setRedraw(true);
            }
        }
        this.updateNavigationActionsState();
        return success;
    }

    @Override
    public boolean navigateHome() {
        AbstractIntroPage homePage = this.getModel().getHomePage();
        if (this.getModel().isDynamic()) {
            CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
            currentIntroPart.getControl().setRedraw(false);
            boolean success = false;
            success = this.getModel().setCurrentPageId(homePage.getId());
            this.updateHistory(homePage);
            currentIntroPart.getControl().setRedraw(true);
            return success;
        }
        return false;
    }

    @Override
    protected void handleRegistryChanged(IRegistryChangeEvent event) {
        if (this.getModel().isDynamic()) {
            IntroPlugin.closeIntro();
            IntroPlugin.showIntro(false);
        }
    }

    private void staticCreatePartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.welcomeLink = this.createStaticPage(parent);
    }

    private Hyperlink createStaticPage(Composite parent) {
        Form mainForm = this.toolkit.createForm(parent);
        Composite body = mainForm.getBody();
        GridLayout gl = new GridLayout();
        body.setLayout((Layout)gl);
        String label = Messages.StaticHTML_welcome;
        Hyperlink link = this.toolkit.createHyperlink(body, label, 64);
        link.setFont(PageStyleManager.getHeaderFont());
        GridData gd = new GridData(1536);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 2;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Hyperlink link = (Hyperlink)e.getSource();
                Util.openBrowser((String)link.getHref());
            }
        });
        return link;
    }

    public void staticStandbyStateChanged(boolean standby) {
        AbstractIntroPage homePage = this.getModel().getHomePage();
        AbstractIntroPage standbyPage = this.getModel().getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.welcomeLink.setHref((Object)standbyPage.getUrl());
            this.welcomeLink.setToolTipText(standbyPage.getUrl());
        } else {
            this.welcomeLink.setHref((Object)homePage.getUrl());
            this.welcomeLink.setToolTipText(homePage.getUrl());
        }
    }
}

