/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.polarsys.esf.core.utils.CoreUtilsActivator;
import org.polarsys.esf.core.utils.ModelUtil;

public final class ProfileUtil {
    private static final String COMMAND_LABEL_APPLY_STEREOTYPE = "ProfileUtil: Apply Stereotype";

    private ProfileUtil() {
    }

    public static boolean applyProfile(Model pModel, Profile pProfile) {
        boolean vProfileApplied = false;
        TransactionalEditingDomain vEditingDomain = ModelUtil.getTransactionalEditingDomain((Element)pModel);
        ApplyProfileCommand vApplySAProfileCmd = new ApplyProfileCommand(pModel.getNearestPackage(), Collections.singleton(pProfile), vEditingDomain);
        if (vApplySAProfileCmd.canExecute()) {
            try {
                vEditingDomain.getCommandStack().execute((Command)vApplySAProfileCmd);
                vProfileApplied = true;
            }
            catch (IllegalArgumentException pException) {
                CoreUtilsActivator.logError("Error during the profile application", pException);
            }
        }
        return vProfileApplied;
    }

    public static void applyStereotype(final Element pElement, final Stereotype pStereotype) {
        TransactionalEditingDomain vEditingDomain = ModelUtil.getTransactionalEditingDomain(pElement);
        RecordingCommand vApplyStereotypeCmd = new RecordingCommand(vEditingDomain, COMMAND_LABEL_APPLY_STEREOTYPE){

            protected void doExecute() {
                if (!pElement.isStereotypeApplied(pStereotype)) {
                    pElement.applyStereotype(pStereotype);
                }
            }
        };
        if (vApplyStereotypeCmd.canExecute()) {
            vEditingDomain.getCommandStack().execute((Command)vApplyStereotypeCmd);
        }
    }

    public static void applyStereotype(final Element pElement, final EClass pEClass) {
        TransactionalEditingDomain vEditingDomain = ModelUtil.getTransactionalEditingDomain(pElement);
        RecordingCommand vApplyStereotypeCmd = new RecordingCommand(vEditingDomain, COMMAND_LABEL_APPLY_STEREOTYPE){

            protected void doExecute() {
                UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)pElement.getModel()).applyStereotype(pElement, pEClass);
            }
        };
        if (vApplyStereotypeCmd.canExecute()) {
            vEditingDomain.getCommandStack().execute((Command)vApplyStereotypeCmd);
        }
    }

    public static Map<String, Profile> getSubProfiles(Profile pProfile) {
        HashMap<String, Profile> vSubProfilesMap = new HashMap<String, Profile>();
        for (Element vCurrentElement : pProfile.getOwnedElements()) {
            if (vCurrentElement instanceof Stereotype && !vSubProfilesMap.containsValue(pProfile)) {
                vSubProfilesMap.put(pProfile.getQualifiedName(), pProfile);
            }
            if (!(vCurrentElement instanceof Profile)) continue;
            vSubProfilesMap.putAll(ProfileUtil.getSubProfiles((Profile)vCurrentElement));
        }
        return vSubProfilesMap;
    }

    public static boolean applyProfilesList(Model pModel, Map<String, Profile> pProfilesMap) {
        boolean vProfilesApplied = false;
        TransactionalEditingDomain vEditingDomain = ModelUtil.getTransactionalEditingDomain((Element)pModel);
        ApplyProfileCommand vApplySubProfileCmd = new ApplyProfileCommand(pModel.getNearestPackage(), pProfilesMap.values(), vEditingDomain);
        if (vApplySubProfileCmd.canExecute()) {
            try {
                vEditingDomain.getCommandStack().execute((Command)vApplySubProfileCmd);
                vProfilesApplied = true;
            }
            catch (IllegalArgumentException pException) {
                CoreUtilsActivator.logError("Error during the profiles application", pException);
            }
        }
        return vProfilesApplied;
    }
}

