/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.utils;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.polarsys.esf.core.utils.ModelUtil;

public final class NameElementUtil {
    private static final String COMMAND_LABEL = "NameElementHelper: Create Library";

    private NameElementUtil() {
    }

    public static void nameManagerIntoOwner(Element pOwner, NamedElement pNewElement) {
        String vValidName = NameElementUtil.getValidNameIntoOwner(pOwner, pNewElement);
        if (StringUtils.isNotEmpty((CharSequence)vValidName) && !vValidName.equals(pNewElement.getName())) {
            NameElementUtil.renameElement(vValidName, pNewElement);
        }
    }

    public static String getValidNameIntoOwner(Element pOwner, String pBaseName) {
        return NameElementUtil.findValidNameIntoOwner(pOwner, pBaseName);
    }

    public static String getValidNameIntoOwner(Element pOwner, NamedElement pNewElement) {
        String vBaseName = "";
        if (pNewElement instanceof Property) {
            vBaseName = ((Property)pNewElement).getType() != null ? ((Property)pNewElement).getType().getName() : pNewElement.getName();
            vBaseName = vBaseName.toLowerCase(Locale.ENGLISH);
        } else {
            vBaseName = pNewElement.getName();
        }
        return NameElementUtil.findValidNameIntoOwner(pOwner, vBaseName);
    }

    private static String findValidNameIntoOwner(Element pOwner, String pBaseName) {
        int i = 0;
        boolean vNotValidName = true;
        String vValidName = pBaseName;
        while (vNotValidName) {
            vNotValidName = false;
            for (Element vElement : pOwner.getOwnedElements()) {
                NamedElement vNamedElement;
                if (!(vElement instanceof NamedElement) || !(vNamedElement = (NamedElement)vElement).getName().matches(vValidName)) continue;
                vNotValidName = true;
                ++i;
                break;
            }
            if (i <= 0) continue;
            vValidName = String.valueOf(pBaseName) + i;
        }
        return vValidName;
    }

    public static void renameElement(final String pNewName, final NamedElement pElement) {
        TransactionalEditingDomain vEditingDomain = ModelUtil.getTransactionalEditingDomain((Element)pElement);
        RecordingCommand vRenameCommand = new RecordingCommand(vEditingDomain, COMMAND_LABEL){

            protected void doExecute() {
                pElement.setName(pNewName);
            }
        };
        if (vRenameCommand.canExecute()) {
            vEditingDomain.getCommandStack().execute((Command)vRenameCommand);
        }
    }
}

