/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.esf.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.polarsys.esf.core.utils.CoreUtilsActivator;

public final class ModelUtil {
    private static final String COMMAND_LABEL_CREATE_NEW_ELEMENT = "ModelUtil: Create new element";
    private static final String ERROR_SERVICE_REAGITRY_SEARCH = "Error during the service registry search";

    private ModelUtil() {
    }

    public static EObject getSelectedEObjectOfType(ISelection pSelection, EClass pRefClass) {
        EObject vSelectedEObjectOfType = null;
        if (pSelection instanceof IStructuredSelection) {
            EClass vEObjectClass;
            StructuredSelection vTreeSelection = (StructuredSelection)pSelection;
            Object vSelectedObject = vTreeSelection.getFirstElement();
            if (EMFHelper.getEObject((Object)vSelectedObject) == null) {
                vSelectedEObjectOfType = null;
            }
            if (!pRefClass.isSuperTypeOf(vEObjectClass = (vSelectedEObjectOfType = EMFHelper.getEObject((Object)vSelectedObject)).eClass())) {
                vSelectedEObjectOfType = null;
            }
        }
        return vSelectedEObjectOfType;
    }

    private static Element getTopElement(Element pElement) {
        Element vTopElement = null;
        vTopElement = pElement.getOwner() != null ? ModelUtil.getTopElement(pElement.getOwner()) : pElement;
        return vTopElement;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain(Element pElement) {
        TransactionalEditingDomain vEditingDomain = null;
        Model vModel = null;
        vModel = pElement instanceof Model ? (Model)pElement : ModelUtil.getTopModel(pElement);
        if (vModel != null) {
            ServicesRegistry vServiceRegistry = null;
            try {
                vServiceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)vModel);
            }
            catch (ServiceException pException) {
                CoreUtilsActivator.logError(ERROR_SERVICE_REAGITRY_SEARCH, (Exception)((Object)pException));
            }
            try {
                vEditingDomain = (TransactionalEditingDomain)vServiceRegistry.getService(TransactionalEditingDomain.class);
            }
            catch (ServiceException pException) {
                CoreUtilsActivator.logError("Error during the editing domain search", (Exception)((Object)pException));
            }
        }
        return vEditingDomain;
    }

    public static List<Element> getElementsTypedByClass(Element pElement) {
        EList vElementsList = Collections.emptyList();
        if (pElement instanceof Class) {
            vElementsList = pElement.allOwnedElements();
        } else if (pElement instanceof Property && ((Property)pElement).getType() instanceof Class) {
            Class vElementType = (Class)((Property)pElement).getType();
            vElementsList = vElementType.allOwnedElements();
        }
        return vElementsList;
    }

    public static Model getTopModel(Element pElement) {
        Model vTopModel = null;
        Element vTopElement = ModelUtil.getTopElement(pElement);
        if (vTopElement instanceof Model) {
            vTopModel = (Model)vTopElement;
        }
        return vTopModel;
    }

    public static Class createNewBaseClassElement(final Package pOwner, final String pName) {
        Class vNewClass = null;
        TransactionalEditingDomain vEditingDomain = ModelUtil.getTransactionalEditingDomain((Element)pOwner);
        RecordingCommand vCreateNewElementCmd = new RecordingCommand(vEditingDomain, COMMAND_LABEL_CREATE_NEW_ELEMENT){
            private Class mNewClass;
            {
                super($anonymous0, $anonymous1);
                this.mNewClass = null;
            }

            protected void doExecute() {
                this.mNewClass = pOwner.createOwnedClass(pName, true);
            }

            public Collection<?> getResult() {
                List<Class> vResult = Collections.EMPTY_LIST;
                if (this.mNewClass != null) {
                    vResult = Collections.singletonList(this.mNewClass);
                }
                return vResult;
            }
        };
        if (vCreateNewElementCmd.canExecute()) {
            vEditingDomain.getCommandStack().execute((Command)vCreateNewElementCmd);
            Iterator vIterator = vCreateNewElementCmd.getResult().iterator();
            while (vNewClass == null && vIterator.hasNext()) {
                Object vObject = vIterator.next();
                if (!(vObject instanceof Class)) continue;
                vNewClass = (Class)vObject;
            }
        }
        return vNewClass;
    }

    public static Model getWorkingModel() {
        Model vWorkingModel = null;
        ModelSet vModelSet = new ModelSet();
        vModelSet = ModelUtil.getCurrentModelSet();
        UmlModel vIUMLModel = (UmlModel)vModelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        try {
            vWorkingModel = (Model)vIUMLModel.lookupRoot();
        }
        catch (NotFoundException pException) {
            CoreUtilsActivator.logError("The root of model is not found", (Exception)((Object)pException));
        }
        return vWorkingModel;
    }

    public static ModelSet getCurrentModelSet() {
        ModelSet vModelSet = new ModelSet();
        IWorkbenchPart vPart = ModelUtil.getCurrentWorkbenchPart();
        if (vPart instanceof IMultiDiagramEditor) {
            ServicesRegistry vRegistry = ((IMultiDiagramEditor)vPart).getServicesRegistry();
            try {
                vModelSet = (ModelSet)vRegistry.getService(ModelSet.class);
            }
            catch (ServiceException pException) {
                CoreUtilsActivator.logError(ERROR_SERVICE_REAGITRY_SEARCH, (Exception)((Object)pException));
            }
        }
        return vModelSet;
    }

    public static IWorkbenchPart getCurrentWorkbenchPart() {
        IEditorPart vPart = null;
        try {
            IWorkbenchPage vActivePage;
            IWorkbenchWindow vActiveWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (vActiveWorkbenchWindow != null && (vActivePage = vActiveWorkbenchWindow.getActivePage()) != null && vActivePage.getActiveEditor() instanceof IMultiDiagramEditor) {
                vPart = vActivePage.getActiveEditor();
            }
        }
        catch (NullPointerException pException) {
            CoreUtilsActivator.logError("Error during the active workbench window search", pException);
        }
        return vPart;
    }
}

