/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.OperatingSystem;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.Target;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.AbstractSettings;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageProjectSupport;
import org.eclipse.papyrus.designer.transformation.base.UIContext;
import org.eclipse.papyrus.designer.transformation.base.utils.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.ProjectManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.transformations.ApplyRecursive;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.library.Messages;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateAndConfigureProject
implements IM2MTrafoCDP {
    protected AbstractSettings settings;
    protected ILangProjectSupport projectSupport;

    protected String getTargetOS(InstanceSpecification node) {
        if (node != null) {
            OperatingSystem os;
            Target target = (Target)UMLUtil.getStereotypeApplication((Element)node, Target.class);
            if (target == null) {
                target = (Target)UMLUtil.getStereotypeApplication((Element)DepUtils.getClassifier((InstanceSpecification)node), Target.class);
            }
            if (target != null && (os = target.getUsedOS()) != null) {
                return os.getBase_Class().getName();
            }
        }
        return System.getProperty("os.name");
    }

    protected IProject getOrCreateProject(ILangProjectSupport projectSupport, String projectName, String targetLanguage, Package modelRoot) throws TransformationException {
        IProject genProject = ProjectManagement.getNamedProject((String)projectName);
        if (genProject == null || !genProject.exists()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projectsBeforeCreation = root.getProjects();
            genProject = projectSupport.createProject(projectName, modelRoot);
            try {
                root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                IProject[] projectsAfterCreation = root.getProjects();
                boolean found = false;
                int i = 0;
                while (i < projectsBeforeCreation.length) {
                    if (!projectsAfterCreation[i].getName().equals(projectsBeforeCreation[i].getName())) {
                        genProject = projectsAfterCreation[i];
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found && projectsBeforeCreation.length < projectsAfterCreation.length) {
                    genProject = projectsAfterCreation[projectsAfterCreation.length - 1];
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (genProject == null || !genProject.exists()) {
                throw new RuntimeException(String.format(Messages.CreateAndConfigureProject_CANNOT_CREATE_PROJECT, projectName, targetLanguage));
            }
            UIContext.configureProject = true;
        }
        return genProject;
    }

    void storeProjectName(IProject genProject, final String defaultProjectName) {
        if (genProject != null && TransformationContext.initialDeploymentPlan != null) {
            final String pName = genProject.getName();
            final Runnable storeProject = new Runnable(){

                @Override
                public void run() {
                    Package deploymentPlanElement = TransformationContext.initialDeploymentPlan;
                    DeploymentPlan deploymentPlan = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)deploymentPlanElement, DeploymentPlan.class);
                    EList projectMappings = deploymentPlan.getProjectMappings();
                    String newMapping = String.valueOf(defaultProjectName) + "=" + pName;
                    int j = 0;
                    while (j < projectMappings.size()) {
                        StringTokenizer str = new StringTokenizer((String)projectMappings.get(j), "=");
                        String genName = str.nextToken();
                        if (genName.equals(defaultProjectName)) {
                            projectMappings.remove(j);
                            break;
                        }
                        ++j;
                    }
                    projectMappings.add((Object)newMapping);
                }
            };
            Runnable storeProjectCmd = new Runnable(){

                @Override
                public void run() {
                    CommandSupport.exec((EObject)TransformationContext.initialDeploymentPlan, (String)Messages.CreateAndConfigureProject_CHANGE_PROJECT_MAPPING, (Runnable)storeProject);
                }
            };
            Display.getDefault().asyncExec(storeProjectCmd);
        }
    }

    public String getProjectName(Package model, InstanceSpecification node) {
        String projectName = node != null ? String.valueOf(model.getName()) + "_" + node.getName() : model.getName();
        projectName = String.valueOf(projectName) + "_" + TransformationContext.current.deploymentPlan.getName();
        DeploymentPlan depPlan = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)TransformationContext.current.deploymentPlan, DeploymentPlan.class);
        if (depPlan != null) {
            for (String mapping : depPlan.getProjectMappings()) {
                int index;
                if (!mapping.startsWith(projectName) || (index = mapping.indexOf("=")) == -1) continue;
                return mapping.substring(index + 1);
            }
        }
        return projectName;
    }

    public String getDefaultProjectName(Package model, InstanceSpecification node) {
        String projectName = String.valueOf(model.getName()) + "_" + node.getName();
        projectName = String.valueOf(projectName) + "_" + TransformationContext.current.deploymentPlan.getName();
        return projectName;
    }

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        TransformationContext tc = TransformationContext.current;
        EList topLevelInstances = DepUtils.getTopLevelInstances((Package)TransformationContext.current.deploymentPlan);
        String targetLanguage = topLevelInstances.size() > 0 ? DepUtils.getTargetLanguage((InstanceSpecification)((InstanceSpecification)topLevelInstances.iterator().next())) : DepUtils.getLanguageFromElement((Element)deploymentPlan);
        String projectName = this.getProjectName(tc.modelRoot, tc.node);
        this.projectSupport = LanguageProjectSupport.getProjectSupport((String)targetLanguage);
        IProject genProject = this.getOrCreateProject(this.projectSupport, projectName, targetLanguage, tc.deploymentPlan);
        if (genProject == null) {
            throw new TransformationException(String.format(Messages.DeployToNodes_CouldNotCreateProject, targetLanguage));
        }
        if (!genProject.getName().equals(projectName)) {
            this.storeProjectName(genProject, this.getDefaultProjectName(tc.modelRoot, tc.node));
        }
        tc.projectSupport = this.projectSupport;
        tc.project = genProject;
        if (UIContext.configureProject) {
            GatherConfigData gatherData = new GatherConfigData();
            this.settings = this.projectSupport.initialConfigurationData();
            if (this.settings != null) {
                this.settings.targetOS = this.getTargetOS(TransformationContext.current.node);
            }
            ApplyRecursive ar = new ApplyRecursive(trafo, (IM2MTrafoElem)gatherData);
            ar.applyRecursive(PackageUtil.getRootPackage((Package)deploymentPlan));
            this.projectSupport.setSettings(TransformationContext.current.project, this.settings);
        }
    }

    public class GatherConfigData
    implements IM2MTrafoElem {
        public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
            if (element instanceof Classifier) {
                CreateAndConfigureProject.this.projectSupport.gatherConfigData((Classifier)element, CreateAndConfigureProject.this.settings);
            }
        }
    }
}

