/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.properties.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.robotics.profile.robotics.skills.InAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.OutAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillResult;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class SkillReferenceFactory
extends UMLPropertyEditorFactory {
    protected ParameterDirectionKind direction;
    Operation operation;

    public SkillReferenceFactory(Operation operation, EReference reference, ParameterDirectionKind direction) {
        super(reference);
        this.operation = operation;
        this.direction = direction;
    }

    protected EObject simpleCreateObject(Control widget) {
        final Parameter parameter = (Parameter)super.simpleCreateObject(widget);
        parameter.setDirection(this.direction);
        RecordingCommand cmd = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)this.operation), "Create skill parameter"){

            protected void doExecute() {
                SkillReferenceFactory.this.operation.getOwnedParameters().add((Object)parameter);
                if (SkillReferenceFactory.this.direction == ParameterDirectionKind.IN_LITERAL) {
                    StereotypeUtil.apply((Element)parameter, InAttribute.class);
                } else if (SkillReferenceFactory.this.direction == ParameterDirectionKind.OUT_LITERAL) {
                    StereotypeUtil.apply((Element)parameter, OutAttribute.class);
                } else {
                    StereotypeUtil.apply((Element)parameter, SkillResult.class);
                }
            }
        };
        cmd.execute();
        return parameter;
    }
}

