/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.rulebased.core;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.infra.types.rulebased.AndRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.CompositeRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.NotRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.OrRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.RuleBasedTypeConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.core.RuleConfigurationTypeRegistry;

public class DefaultRuleElementMatcher
implements IElementMatcher {
    RuleBasedTypeConfiguration configuration;

    public DefaultRuleElementMatcher(RuleBasedTypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean matches(EObject eObject) {
        RuleConfiguration RuleConfiguration2 = this.configuration.getRuleConfiguration();
        return this.processRule(RuleConfiguration2, eObject);
    }

    protected boolean processRule(RuleConfiguration RuleConfiguration2, EObject eObject) {
        if (RuleConfiguration2 instanceof CompositeRuleConfiguration) {
            return this.processCompositeRule((CompositeRuleConfiguration)RuleConfiguration2, eObject);
        }
        if (RuleConfiguration2 instanceof NotRuleConfiguration) {
            RuleConfiguration composedRule = ((NotRuleConfiguration)RuleConfiguration2).getComposedRule();
            return !this.processRule(composedRule, eObject);
        }
        return RuleConfigurationTypeRegistry.getInstance().getRule(RuleConfiguration2).matches(eObject);
    }

    protected boolean processCompositeRule(CompositeRuleConfiguration compositeRule, EObject eObject) {
        Iterator iterator = compositeRule.getComposedRules().iterator();
        RuleConfiguration nextComposedRuleConfiguration = (RuleConfiguration)iterator.next();
        boolean result = this.processRule(nextComposedRuleConfiguration, eObject);
        while (iterator.hasNext()) {
            nextComposedRuleConfiguration = (RuleConfiguration)iterator.next();
            boolean resultNextComposedRuleConfiguration = this.processRule(nextComposedRuleConfiguration, eObject);
            if (compositeRule instanceof OrRuleConfiguration) {
                if (result || !resultNextComposedRuleConfiguration) continue;
                result = true;
                continue;
            }
            if (!(compositeRule instanceof AndRuleConfiguration) || !result || resultNextComposedRuleConfiguration) continue;
            result = false;
        }
        return result;
    }
}

