/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.BasicNFP_Types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DirectionKind implements Enumerator
{
    INCR(0, "incr", "incr"),
    DECR(1, "decr", "decr");

    public static final int INCR_VALUE = 0;
    public static final int DECR_VALUE = 1;
    private static final DirectionKind[] VALUES_ARRAY;
    public static final List<DirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DirectionKind[]{INCR, DECR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionKind get(int value) {
        switch (value) {
            case 0: {
                return INCR;
            }
            case 1: {
                return DECR;
            }
        }
        return null;
    }

    private DirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

