/*****************************************************************************
 * Copyright (c) 2018 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *
 *****************************************************************************/

package org.eclipse.papyrus.robotics.ros2.codegen.component

import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition
import org.eclipse.uml2.uml.Class
import org.eclipse.uml2.uml.Package
import org.eclipse.uml2.uml.util.UMLUtil

import static extension org.eclipse.papyrus.robotics.core.utils.InstanceUtils.*

class RemovePorts implements IM2MTrafoCDP {
	
	/**
	 * Remove activities from node
	 */
	def removeActivities(Class node) {
		val cd = UMLUtil.getStereotypeApplication(node, ComponentDefinition)
		for (activity : cd.activities.clone) {
			// remove activity and associated attribute
			node.getAttribute(null, activity.base_Class).destroy
			activity.base_Class.destroy
		}
	}
	
	/**
	 * remove original ports and associated types
	 */
	def removePorts(Class node) {
		for (port : node.ownedPorts.clone) {
			if (port.type !== null) {
				port.type.destroy();
			}
			port.destroy();
		}
	}
			
	override applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
		val system = deploymentPlan.system
		
		for (node : system.componentList) {
			node.removePorts		
		}
	}
	
}