/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.profile.robotics.functions.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Argument;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionsFactory;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionsPackage;
import org.eclipse.papyrus.robotics.profile.robotics.functions.impl.ArgumentImpl;
import org.eclipse.papyrus.robotics.profile.robotics.functions.impl.FunctionImpl;

public class FunctionsFactoryImpl
extends EFactoryImpl
implements FunctionsFactory {
    public static FunctionsFactory init() {
        try {
            FunctionsFactory theFunctionsFactory = (FunctionsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/robotics/functions/1");
            if (theFunctionsFactory != null) {
                return theFunctionsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new FunctionsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createArgument();
            }
            case 1: {
                return this.createFunction();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createFunctionKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertFunctionKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Argument createArgument() {
        ArgumentImpl argument = new ArgumentImpl();
        return argument;
    }

    @Override
    public Function createFunction() {
        FunctionImpl function = new FunctionImpl();
        return function;
    }

    public FunctionKind createFunctionKindFromString(EDataType eDataType, String initialValue) {
        FunctionKind result = FunctionKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFunctionKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public FunctionsPackage getFunctionsPackage() {
        return (FunctionsPackage)this.getEPackage();
    }

    @Deprecated
    public static FunctionsPackage getPackage() {
        return FunctionsPackage.eINSTANCE;
    }
}

