/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.css;

import org.eclipse.papyrus.infra.gmfdiag.css.engine.ICSSElementProviderFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.IPapyrusElementProvider;
import org.eclipse.papyrus.robotics.css.GMFRMSElementProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class GMFRMSElementProviderFactory
implements ICSSElementProviderFactory {
    private static final String ROBOTICS_PROFILE = "robotics";

    public boolean isProviderFor(CSSDiagram diagram) {
        Element element;
        Package nearestPkg;
        if (diagram.getElement() instanceof Element && (nearestPkg = (element = (Element)diagram.getElement()).getNearestPackage()) != null) {
            for (Profile profile : nearestPkg.getAllAppliedProfiles()) {
                if (profile.getName() == null || !profile.getName().contains(ROBOTICS_PROFILE)) continue;
                return true;
            }
        }
        return false;
    }

    public IPapyrusElementProvider createProvider(CSSDiagram diagram) {
        return new GMFRMSElementProvider();
    }
}

