/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.component;

import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TemplateBinding;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Callbacks {
    private static final String PUSH = "PUSH or SEND";
    private static final String QUERY = "QUERY";
    private static final String ACTION = "ACTION";
    private static final String WHOLE_PKG = "Please note that code gets generated for the whole ROS2 package, not only for the currently open component";

    public static String callBackMethodForPush(Class component, Port port) {
        boolean _tripleNotEquals;
        ActivityPort activity = ActivityUtils.getActivityForPort(component, port);
        Callbacks.checkActivity(activity, PUSH, port);
        Behavior fct = FunctionUtils.getFunction((ActivityPort)activity, (FunctionKind)FunctionKind.HANDLER);
        Callbacks.checkFunction(fct, PUSH, activity, port);
        Behavior fctCopy = component.getOwnedBehavior(fct.getName());
        BehavioralFeature _specification = fctCopy.getSpecification();
        boolean bl = _tripleNotEquals = _specification != null;
        if (_tripleNotEquals) {
            Parameter param = fctCopy.getSpecification().createOwnedParameter(InteractionUtils.getCommObject((Port)port).getName().toLowerCase(), InteractionUtils.getCommObject((Port)port));
            Helpers.useSharedPtr((TypedElement)param);
            StereotypeUtil.apply((Element)param, Const.class);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("std::bind(&");
            String _qualifiedName = component.getQualifiedName();
            _builder.append(_qualifiedName);
            String _postfix = ActivityUtils.getPostfix(component);
            _builder.append(_postfix);
            _builder.append("::");
            String _name = fct.getName();
            _builder.append(_name);
            _builder.append(", (");
            String _name_1 = component.getName();
            _builder.append(_name_1);
            String _postfix_1 = ActivityUtils.getPostfix(component);
            _builder.append(_postfix_1);
            _builder.append("*) this, std::placeholders::_1)");
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }
        return null;
    }

    public static void clientCallBackMethodForService(Class component, Port port) {
        ActivityPort activityPort = ActivityUtils.getActivityForPort(component, port);
        Callbacks.checkActivity(activityPort, QUERY, port);
        Behavior resultFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"result");
        if (resultFct != null) {
            Type clientType = Helpers.getRosType((Element)port, "ros2Library::rclcpp::Client");
            Behavior lResultFct = component.getOwnedBehavior(resultFct.getName());
            Parameter resultParam = lResultFct.getSpecification().createOwnedParameter("future", clientType);
            ApplyProfiles.applyCommonProfile((Element)resultParam);
            TemplateBinding resultTpl = (TemplateBinding)StereotypeUtil.applyApp((Element)resultParam, TemplateBinding.class);
            resultTpl.getActuals().add((Object)MessageUtils.getServiceType(port));
            Ptr resultParamPtr = (Ptr)StereotypeUtil.applyApp((Element)resultParam, Ptr.class);
            resultParamPtr.setDeclaration("::SharedFuture");
        }
    }

    public static String serverCallBackMethodForService(Class component, Port port) {
        boolean _tripleNotEquals;
        ActivityPort activityPort = ActivityUtils.getActivityForPort(component, port);
        Callbacks.checkActivity(activityPort, QUERY, port);
        Behavior fct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER);
        Callbacks.checkFunction(fct, QUERY, activityPort, port);
        Behavior fctCopy = component.getOwnedBehavior(fct.getName());
        BehavioralFeature _specification = fctCopy.getSpecification();
        boolean bl = _tripleNotEquals = _specification != null;
        if (_tripleNotEquals) {
            Parameter reqParam = fctCopy.getSpecification().createOwnedParameter("request", (Type)MessageUtils.getServiceType(port));
            Ptr refReq = (Ptr)StereotypeUtil.applyApp((Element)reqParam, Ptr.class);
            refReq.setDeclaration("::Request::SharedPtr");
            StereotypeUtil.applyApp((Element)reqParam, Const.class);
            Parameter resParam = fctCopy.getSpecification().createOwnedParameter("response", (Type)MessageUtils.getServiceType(port));
            Ptr refRes = (Ptr)StereotypeUtil.applyApp((Element)resParam, Ptr.class);
            refRes.setDeclaration("::Response::SharedPtr");
            StereotypeUtil.applyApp((Element)resParam, Const.class);
            Parameter retParam = fctCopy.getSpecification().createOwnedParameter("ret", Helpers.getRosPrimitiveType((Element)port, "primitive::bool"));
            retParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("std::bind(&");
            String _qualifiedName = component.getQualifiedName();
            _builder.append(_qualifiedName);
            String _postfix = ActivityUtils.getPostfix(component);
            _builder.append(_postfix);
            _builder.append("::");
            String _name = fct.getName();
            _builder.append(_name);
            _builder.append(", (");
            String _name_1 = component.getName();
            _builder.append(_name_1);
            String _postfix_1 = ActivityUtils.getPostfix(component);
            _builder.append(_postfix_1);
            _builder.append("*) this, std::placeholders::_1, std::placeholders::_2)");
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }
        return null;
    }

    public static void clientCallsbacksForAction(Class component, Port port) {
        Behavior goalFct;
        Behavior resultFct;
        ActivityPort activityPort = ActivityUtils.getActivityForPort(component, port);
        Callbacks.checkActivity(activityPort, ACTION, port);
        Type handleType = Helpers.getRosType((Element)port, "ros2Library::rclcpp_action::ClientGoalHandle");
        Behavior feedbackFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"feedback");
        if (feedbackFct != null) {
            Behavior lFeedbackFct = component.getOwnedBehavior(feedbackFct.getName());
            Parameter handleParam = lFeedbackFct.getSpecification().createOwnedParameter("handle", handleType);
            ApplyProfiles.applyCommonProfile((Element)handleParam);
            TemplateBinding template = (TemplateBinding)StereotypeUtil.applyApp((Element)handleParam, TemplateBinding.class);
            template.getActuals().add((Object)MessageUtils.getServiceType(port));
            Ptr handleParamPtr = (Ptr)StereotypeUtil.applyApp((Element)handleParam, Ptr.class);
            handleParamPtr.setDeclaration("::SharedPtr");
            Parameter feedbackParam = lFeedbackFct.getSpecification().createOwnedParameter("feedback", (Type)MessageUtils.getServiceType(port));
            Ptr feedbackParamPtr = (Ptr)StereotypeUtil.applyApp((Element)feedbackParam, Ptr.class);
            feedbackParamPtr.setDeclaration("::Feedback::ConstSharedPtr");
        }
        if ((resultFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"result")) != null) {
            Behavior lResultFct = component.getOwnedBehavior(resultFct.getName());
            Parameter resultParam = lResultFct.getSpecification().createOwnedParameter("result", handleType);
            TemplateBinding resultTpl = (TemplateBinding)StereotypeUtil.applyApp((Element)resultParam, TemplateBinding.class);
            resultTpl.getActuals().add((Object)MessageUtils.getServiceType(port));
            Ptr resultParamPtr = (Ptr)StereotypeUtil.applyApp((Element)resultParam, Ptr.class);
            resultParamPtr.setDeclaration("::WrappedResult &");
            StereotypeUtil.apply((Element)resultParam, Const.class);
        }
        if ((goalFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"goal")) != null) {
            Behavior lGoalFct = component.getOwnedBehavior(goalFct.getName());
            String futureTypeName = String.format("std::shared_future<rclcpp_action::ClientGoalHandle<%s>::SharedPtr>", Helpers.externalName((Type)MessageUtils.getServiceType(port)));
            lGoalFct.getSpecification().createOwnedParameter("future", (Type)Callbacks.dummyType(component, futureTypeName));
        }
    }

    public static String serverCallsbacksForAction(Class component, Port port) {
        ActivityPort activityPort = ActivityUtils.getActivityForPort(component, port);
        Callbacks.checkActivity(activityPort, ACTION, port);
        Behavior goalFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"goal");
        Callbacks.checkFunction(goalFct, "ACTION/feedback", activityPort, port);
        Behavior cancelFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"cancel");
        Callbacks.checkFunction(cancelFct, "ACTION/result", activityPort, port);
        Behavior acceptedFct = FunctionUtils.getFunction((ActivityPort)activityPort, (FunctionKind)FunctionKind.HANDLER, (String)"accepted");
        Callbacks.checkFunction(acceptedFct, "ACTION/goal", activityPort, port);
        Behavior lGoalFct = component.getOwnedBehavior(goalFct.getName());
        Behavior lCancelFct = component.getOwnedBehavior(cancelFct.getName());
        Behavior lAcceptedFct = component.getOwnedBehavior(acceptedFct.getName());
        Type goalUUID = Helpers.getRosType((Element)port, "ros2Library::rclcpp_action::GoalUUID");
        Type goalResponse = Helpers.getRosType((Element)port, "ros2Library::rclcpp_action::GoalResponse");
        Type cancelResponse = Helpers.getRosType((Element)port, "ros2Library::rclcpp_action::CancelResponse");
        Parameter uuidParam = lGoalFct.getSpecification().createOwnedParameter("uuid", goalUUID);
        StereotypeUtil.apply((Element)uuidParam, Ref.class);
        StereotypeUtil.apply((Element)uuidParam, Const.class);
        String goalTypeName = String.format("std::shared_ptr<const %s::Goal>", Helpers.externalName((Type)MessageUtils.getServiceType(port)));
        lGoalFct.getSpecification().createOwnedParameter("goal", (Type)Callbacks.dummyType(component, goalTypeName));
        Parameter goalRetParam = lGoalFct.getSpecification().createOwnedParameter("return", goalResponse);
        goalRetParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        String goalHandleTypeName = String.format("const std::shared_ptr<rclcpp_action::ServerGoalHandle<%s>>", Helpers.externalName((Type)MessageUtils.getServiceType(port)));
        lCancelFct.getSpecification().createOwnedParameter("goal_handle", (Type)Callbacks.dummyType(component, goalHandleTypeName));
        Parameter cancelRetParam = lCancelFct.getSpecification().createOwnedParameter("return", cancelResponse);
        cancelRetParam.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        lAcceptedFct.getSpecification().createOwnedParameter("goal_handle", (Type)Callbacks.dummyType(component, goalHandleTypeName));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("std::bind(&");
        String _qualifiedName = component.getQualifiedName();
        _builder.append(_qualifiedName);
        String _postfix = ActivityUtils.getPostfix(component);
        _builder.append(_postfix);
        _builder.append("::");
        String _name = goalFct.getName();
        _builder.append(_name);
        _builder.append(", (");
        String _name_1 = component.getName();
        _builder.append(_name_1);
        String _postfix_1 = ActivityUtils.getPostfix(component);
        _builder.append(_postfix_1);
        _builder.append("*) this, std::placeholders::_1, std::placeholders::_2),");
        _builder.newLineIfNotEmpty();
        _builder.append("std::bind(&");
        String _qualifiedName_1 = component.getQualifiedName();
        _builder.append(_qualifiedName_1);
        String _postfix_2 = ActivityUtils.getPostfix(component);
        _builder.append(_postfix_2);
        _builder.append("::");
        String _name_2 = cancelFct.getName();
        _builder.append(_name_2);
        _builder.append(", (");
        String _name_3 = component.getName();
        _builder.append(_name_3);
        String _postfix_3 = ActivityUtils.getPostfix(component);
        _builder.append(_postfix_3);
        _builder.append("*) this, std::placeholders::_1),");
        _builder.newLineIfNotEmpty();
        _builder.append("std::bind(&");
        String _qualifiedName_2 = component.getQualifiedName();
        _builder.append(_qualifiedName_2);
        String _postfix_4 = ActivityUtils.getPostfix(component);
        _builder.append(_postfix_4);
        _builder.append("::");
        String _name_4 = acceptedFct.getName();
        _builder.append(_name_4);
        _builder.append(", (");
        String _name_5 = component.getName();
        _builder.append(_name_5);
        String _postfix_5 = ActivityUtils.getPostfix(component);
        _builder.append(_postfix_5);
        _builder.append("*) this, std::placeholders::_1)");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public static void checkActivity(ActivityPort activityPort, String portKind, Port port) {
        try {
            if (activityPort == null) {
                String _format = String.format("The %s port \"%s\" of component \"%s\" is not connected with any activity port. Please note that code gets generated for the whole ROS2 package, not only for the currently open component", portKind, port.getName(), port.getClass_().getName());
                throw new TransformationException(_format);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void checkFunction(Behavior function, String portKind, ActivityPort activity, Port port) {
        try {
            if (function == null) {
                String _format = String.format("No handler function (for %s) is found for activity port \"%s\" associated with port \"%s\" of component \"%s\". Please note that code gets generated for the whole ROS2 package, not only for the currently open component", portKind, activity.getBase_Port().getName(), port.getName(), port.getClass_().getName());
                throw new TransformationException(_format);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Class dummyType(Class component, String name) {
        PackageableElement _packagedElement_1;
        Class dummyType;
        PackageableElement _packagedElement = component.getNearestPackage().getPackagedElement("dummytypes");
        Package pkg = (Package)_packagedElement;
        if (pkg == null) {
            pkg = component.getNearestPackage().createNestedPackage("dummytypes");
            ApplyProfiles.applyCommonProfile((Element)pkg);
            StereotypeUtil.apply((Element)pkg, NoCodeGen.class);
        }
        if ((dummyType = (Class)(_packagedElement_1 = pkg.getPackagedElement(name))) == null) {
            dummyType = pkg.createOwnedClass(name, false);
            External ext = (External)StereotypeUtil.applyApp((Element)dummyType, External.class);
            ext.setName(name);
        }
        return dummyType;
    }
}

