/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.eclipse.papyrus.junit.utils.rules.HouseKeeper;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.CDTUtil;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.LwTransformationTestSupport;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.PrepareCodegen;
import org.eclipse.papyrus.robotics.ros2.codegen.tests.RecursiveCopy;
import org.eclipse.papyrus.robotics.ros2.examples.Activator;
import org.eclipse.uml2.uml.Package;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TestClientServerExample {
    public static final String CLIENT_SERVER = "clientServer";
    public static final String SIMPLE = "simple";
    protected IProject clientServerProject;
    protected LwTransformationTestSupport tts;
    @ClassRule
    public static HouseKeeper.Static houseKeeper = new HouseKeeper.Static();

    @Before
    public void setup() {
        this.clientServerProject = houseKeeper.createProject(CLIENT_SERVER);
        CDTUtil.addCppNature(this.clientServerProject);
        IProject simpleProject = houseKeeper.createProject(SIMPLE);
        CDTUtil.addCppNature(simpleProject);
        ResourceSet rs = houseKeeper.createResourceSet();
        RecursiveCopy copier = new RecursiveCopy(Activator.class);
        Bundle srcBundle = FrameworkUtil.getBundle(Activator.class);
        copier.copy(srcBundle, "testmodels/clientServer/models", this.clientServerProject, "models");
        Resource r = rs.getResource(URI.createURI((String)"platform:/resource/clientServer/models/system/clientserver.system.uml"), true);
        assert (r != null);
        assert (r.getContents().size() > 0);
        assert (r.getContents().get(0) instanceof Package);
        Package rootPkg = (Package)r.getContents().get(0);
        PrepareCodegen prepare = new PrepareCodegen(rootPkg);
        boolean prepareOk = prepare.prepare();
        assert (prepareOk);
        this.tts = new LwTransformationTestSupport(this.getClass(), (AbstractHouseKeeperRule)houseKeeper, this.clientServerProject);
        this.tts.runTransformation(rootPkg);
    }

    @Test
    public void testSystem() throws InterruptedException {
        this.tts.validateResults(this.clientServerProject, "expectedResult/clientServer", ".");
    }
}

