/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.tables.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PropertyTableCellManager
extends AbstractCellManager {
    private static final String EXPRESSION = "Expression";
    private static final String TYPE = "Type";
    private static final String NAME = "Name";
    private static final String DESC = "Description";
    public static final String PROPERTY_TABLE = "PropertyTable";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager mngr) {
        EObject parent;
        return columnElement instanceof IAxis && (parent = ((IAxis)columnElement).eContainer()) != null && (parent = parent.eContainer()) instanceof Table && ((Table)parent).getTableConfiguration().getType().equals(PROPERTY_TABLE);
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager mngr) {
        Property p;
        boolean isEditable = false;
        if (rowElement instanceof Property && (p = (Property)rowElement).upperBound() == 1) {
            isEditable = true;
        }
        return isEditable;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        String alias;
        String value = "";
        String string = alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        if (rowElement instanceof Property && alias != null) {
            ParameterEntry parameter;
            Property p = (Property)rowElement;
            if (alias.equals(NAME)) {
                return p.getName();
            }
            if (alias.equals(TYPE)) {
                Type type = p.getType();
                return type != null ? type.getName() : "undefined";
            }
            if (alias.equals(EXPRESSION)) {
                if (p != null && p.getDefaultValue() != null) {
                    return p.getDefaultValue();
                }
            } else if (alias.equals(DESC) && p != null && (parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)p, ParameterEntry.class)) != null) {
                return parameter.getDescription();
            }
        }
        return value;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, final Object newValue, INattableModelManager tableManager) {
        String text;
        String alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        Property property = (Property)rowElement;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)property);
        CompositeCommand editingCommand = new CompositeCommand(null);
        if (newValue instanceof Type) {
            SetRequest setTypeReq = new SetRequest(domain, (EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)((Type)newValue));
            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setTypeReq));
        } else if (alias.equals(DESC)) {
            ParameterEntry parameter;
            if (property != null && (parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)property, ParameterEntry.class)) != null) {
                return new RecordingCommand(TransactionUtil.getEditingDomain((EObject)property)){

                    protected void doExecute() {
                        parameter.setDescription((String)newValue);
                    }
                };
            }
        } else if (newValue instanceof String && (text = (String)newValue) != null && alias.equals(NAME)) {
            SetRequest setNameReq = new SetRequest(domain, (EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)text);
            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setNameReq));
        }
        return new GMFtoEMFCommandWrapper((ICommand)editingCommand);
    }
}

