/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.PasteStrategyManager;
import org.eclipse.papyrus.requirements.sysml.common.command.DuplicateStereotypeAndReqCommand;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.commands.RestoreStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.strategy.paste.StereotypePasteStrategy;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.commands.DuplicateStereotypeCommand;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeReqPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new StereotypeReqPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "StereotypeRequirementStrategy";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.common.StereotypeReqStrategy";
    }

    public String getDescription() {
        return "Paste Requirement elements";
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        if (targetOwner instanceof Element) {
            org.eclipse.emf.common.command.CompoundCommand compoundCommand = new org.eclipse.emf.common.command.CompoundCommand("Copy all stereotypes");
            HashMap missingProfiles = new HashMap();
            Package targetPackage = ((Element)targetOwner).getNearestPackage();
            for (Object object : papyrusClipboard) {
                Map additionalDataMap;
                Object additionnalData;
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (target == null || !(target instanceof Element) || !((additionnalData = (additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID())).get(object)) instanceof StereotypeClipboard)) continue;
                StereotypeClipboard stereotypeClipboard = (StereotypeClipboard)additionnalData;
                Collection<EObject> stereotypeApplications = stereotypeClipboard.getstereotypeApplications();
                for (EObject stereotypeApplication : stereotypeApplications) {
                    DuplicateStereotypeAndReqCommand applyStereotypeCommand = new DuplicateStereotypeAndReqCommand((TransactionalEditingDomain)domain, (Element)target, (Element)targetOwner, stereotypeApplication);
                    Stereotype stereotypeInTargetContext = applyStereotypeCommand.getStereotypeInTargetContext();
                    Profile profile = stereotypeInTargetContext.getProfile();
                    if (!this.isProfileAppliedRecursive((Element)targetPackage, profile)) continue;
                    compoundCommand.append((Command)applyStereotypeCommand);
                }
            }
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            String preferenceProfileStrategy = preferenceStore.getString("PROFILE_STRATEGY");
            if (!"ASK_POPUP".equals(preferenceProfileStrategy) && "IMPORT_MISSING_PROFILE".equals(preferenceProfileStrategy)) {
                Set profiles = missingProfiles.keySet();
                Package rootPackage = PackageUtil.getRootPackage((Element)((Element)targetOwner));
                ApplyProfileCommand applyProfileCommand = new ApplyProfileCommand(rootPackage, profiles, (TransactionalEditingDomain)domain);
                compoundCommand.append((Command)applyProfileCommand);
                for (Profile profile : profiles) {
                    List list = (List)missingProfiles.get(profile);
                    for (DuplicateStereotypeCommand applyStereotypeCommand : list) {
                        compoundCommand.append((Command)applyStereotypeCommand);
                    }
                }
            }
            if (compoundCommand.getCommandList().isEmpty()) {
                return null;
            }
            return compoundCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public org.eclipse.gef.commands.Command getGraphicalCommand(EditingDomain domain, GraphicalEditPart targetEditPart, PapyrusClipboard<Object> papyrusClipboard) {
        View view;
        EObject targetOwner;
        Command semanticCommand;
        Object model;
        CompoundCommand compoundCommand = new CompoundCommand("Copy all stereotypes");
        if (targetEditPart != null && (model = targetEditPart.getModel()) instanceof View && (semanticCommand = this.getSemanticCommand(domain, targetOwner = (view = (View)model).getElement(), papyrusClipboard)) != null) {
            compoundCommand.add(EMFtoGEFCommandWrapper.wrap((Command)semanticCommand));
        }
        for (EObject eObject : papyrusClipboard.getTarget()) {
            if (!(eObject instanceof BasicCompartment)) continue;
            BasicCompartment basicCompartment = (BasicCompartment)eObject;
            RestoreStereotypeCompartmentCommand refreshStereotypeCompartmentCommand = new RestoreStereotypeCompartmentCommand((TransactionalEditingDomain)domain, basicCompartment);
            org.eclipse.gef.commands.Command wrap = EMFtoGEFCommandWrapper.wrap((Command)refreshStereotypeCompartmentCommand);
            compoundCommand.add(wrap);
        }
        if (compoundCommand.getCommands().isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    protected boolean isProfileAppliedRecursive(Element element, Profile profile) {
        if (element == null) {
            return Boolean.FALSE;
        }
        if (element instanceof Package) {
            Package pkg = (Package)element;
            boolean profileApplied = pkg.isProfileApplied(profile);
            if (pkg instanceof Model || pkg instanceof Profile) {
                return profileApplied;
            }
            if (!profileApplied) {
                return this.isProfileAppliedRecursive(element.getOwner(), profile);
            }
            return Boolean.TRUE;
        }
        return this.isProfileAppliedRecursive(element.getOwner(), profile);
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        PasteStrategyManager.getInstance().setActive((IStrategy)StereotypePasteStrategy.getInstance(), false);
        HashMap<Object, StereotypeClipboard> mapCopyToStereotypeData = new HashMap<Object, StereotypeClipboard>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            Element element;
            EList stereotypeApplications;
            EObject eObjectSource = (EObject)iterator.next();
            if (!(eObjectSource instanceof Element) || (stereotypeApplications = (element = (Element)eObjectSource).getStereotypeApplications()) == null || stereotypeApplications.isEmpty()) continue;
            StereotypeClipboard stereotypeClipboard = new StereotypeClipboard((Collection<EObject>)stereotypeApplications);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToStereotypeData.put(copy, stereotypeClipboard);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToStereotypeData);
    }

    protected class StereotypeClipboard
    implements IClipboardAdditionalData {
        protected Collection<EObject> stereotypeApplications;

        public StereotypeClipboard(Collection<EObject> stereotypeApplications) {
            this.stereotypeApplications = stereotypeApplications;
        }

        public Collection<EObject> getstereotypeApplications() {
            return this.stereotypeApplications;
        }
    }
}

