/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.traceability.commands;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.requirements.sysml14.common.Utils;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.profile.standard.StandardPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RefinementCreateCommand
extends RecordingCommand {
    private NamedElement source;
    private NamedElement target;

    public RefinementCreateCommand(TransactionalEditingDomain domain, NamedElement source, NamedElement target) {
        super(domain, "Create an Abstraction");
        this.source = source;
        this.target = target;
    }

    protected void doExecute() {
        Abstraction theAbstraction = UMLFactory.eINSTANCE.createAbstraction();
        this.source.getNearestPackage().getPackagedElements().add((Object)theAbstraction);
        theAbstraction.getSuppliers().add((Object)this.target);
        theAbstraction.getClients().add((Object)this.source);
        theAbstraction.setName("Refines_" + this.target.getName());
        Profile standardProfile = UMLUtil.getProfile((EPackage)StandardPackage.eINSTANCE, (EObject)this.source.getNearestPackage());
        ArrayList<Profile> requiredProfiles = new ArrayList<Profile>(Arrays.asList(standardProfile));
        ArrayList missingProfiles = Utils.getMissingRequiredProfileApplications((Package)this.source.getNearestPackage(), requiredProfiles);
        if (missingProfiles.size() > 0) {
            Utils.applyMissingProfiles((Package)this.source.getNearestPackage(), (ArrayList)missingProfiles);
        }
        Stereotype refineStereotype = theAbstraction.getApplicableStereotype("StandardProfile::Refine");
        theAbstraction.applyStereotype(refineStereotype);
    }
}

