/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.verificationandvalidationconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VV_StatusKind implements Enumerator
{
    PENDING(0, "Pending", "Pending"),
    PASSED(1, "Passed", "Passed"),
    FAILED(2, "Failed", "Failed"),
    INCONCLUSIVE(3, "Inconclusive", "Inconclusive");

    public static final int PENDING_VALUE = 0;
    public static final int PASSED_VALUE = 1;
    public static final int FAILED_VALUE = 2;
    public static final int INCONCLUSIVE_VALUE = 3;
    private static final VV_StatusKind[] VALUES_ARRAY;
    public static final List<VV_StatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VV_StatusKind[]{PENDING, PASSED, FAILED, INCONCLUSIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VV_StatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VV_StatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VV_StatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VV_StatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VV_StatusKind get(int value) {
        switch (value) {
            case 0: {
                return PENDING;
            }
            case 1: {
                return PASSED;
            }
            case 2: {
                return FAILED;
            }
            case 3: {
                return INCONCLUSIVE;
            }
        }
        return null;
    }

    private VV_StatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

