/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.engine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.kernel.service.ServiceOperatingMode;

public class EngineConfiguration<SourceElementType extends EObject> {
    protected IProject project;
    protected ServiceOperatingMode mode;
    protected URI modelURI;
    protected SourceElementType source;
    protected Map<String, String> parameters;
    protected String traceFilePath;
    protected String formatterID;
    protected boolean traceEnabled;
    protected boolean tracepointMode;

    public EngineConfiguration() {
        this.mode = ServiceOperatingMode.NORMAL;
        this.parameters = new HashMap<String, String>();
    }

    public EngineConfiguration(SourceElementType src, ServiceOperatingMode m) {
        this.source = src;
        this.mode = m;
        this.parameters = new HashMap<String, String>();
    }

    public EngineConfiguration(EngineConfiguration<SourceElementType> ec) {
        this.source = ec.getExecutionSource();
        this.mode = ec.getMode();
        this.parameters = new HashMap<String, String>();
        for (Map.Entry<String, String> p : ec.getParameters().entrySet()) {
            this.parameters.put(p.getKey(), p.getValue());
        }
        this.project = ec.getProject();
        this.modelURI = ec.getModelURI();
        this.traceFilePath = ec.getTraceFilePath();
        this.formatterID = ec.getFormatterID();
        this.traceEnabled = ec.isTraceEnabled();
        this.tracepointMode = ec.isTracepointMode();
    }

    public void setExecutionSource(SourceElementType src) {
        this.source = src;
    }

    public SourceElementType getExecutionSource() {
        return this.source;
    }

    public void setMode(ServiceOperatingMode m) {
        this.mode = m;
    }

    public ServiceOperatingMode getMode() {
        return this.mode;
    }

    public boolean addParameter(String name, String value) {
        return this.parameters.put(name, value) != null;
    }

    public boolean removeParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return this.parameters.remove(name) != null;
        }
        return false;
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public URI getModelURI() {
        return this.modelURI;
    }

    public void setModelURI(URI modelURI) {
        this.modelURI = modelURI;
    }

    public String getTraceFilePath() {
        return this.traceFilePath;
    }

    public void setTraceFilePath(String traceFilePath) {
        this.traceFilePath = traceFilePath;
    }

    public String getFormatterID() {
        return this.formatterID;
    }

    public void setFormatterID(String formatterID) {
        this.formatterID = formatterID;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public void setTracepointMode(boolean mode) {
        this.tracepointMode = mode;
    }

    public boolean isTracepointMode() {
        return this.tracepointMode;
    }
}

