/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.activities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.activities.IActivityExecution;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.loci.SemanticVisitor;
import org.eclipse.papyrus.moka.fuml.profiling.actions.AcceptEventActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityEdgeInstanceProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.CallActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ObjectNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.uml2.uml.ActivityNode;

public abstract class ActivityNodeActivation
extends SemanticVisitor
implements IActivityNodeActivation {
    public IActivityNodeActivationGroup group;
    public ActivityNode node;
    public List<IActivityEdgeInstance> incomingEdges = new ArrayList<IActivityEdgeInstance>();
    public List<IActivityEdgeInstance> outgoingEdges = new ArrayList<IActivityEdgeInstance>();
    public Boolean running;
    public List<IToken> heldTokens = new ArrayList<IToken>();

    public void run() {
        if (this.node != null) {
            Debug.println("[run] node = " + this.node.getName());
        } else {
            Debug.println("[run] Anonymous activation of type " + this.getClass().getName());
        }
        this.running = true;
    }

    public void receiveOffer() {
        Debug.println("[receiveOffer] " + (this.node == null ? "..." : "node = " + this.node.getName()));
        ActivityNodeActivation activityNodeActivation = this;
        ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(activityNodeActivation);
        ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(activityNodeActivation);
        ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(activityNodeActivation);
        PinActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(activityNodeActivation);
        AcceptEventActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(activityNodeActivation);
        CallActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(activityNodeActivation);
        activityNodeActivation._beginIsolation();
        boolean ready = this.isReady();
        ArrayList<IToken> tokens = new ArrayList();
        if (ready) {
            Debug.println("[receiveOffer] Firing.");
            tokens = this.takeOfferedTokens();
        }
        ActivityNodeActivation activityNodeActivation2 = this;
        try {
            try {
                try {
                    try {
                        try {
                            try {
                                activityNodeActivation2._endIsolation();
                            }
                            finally {
                                ActivityEdgeInstanceProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(activityNodeActivation2);
                            }
                        }
                        finally {
                            ActivityNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(activityNodeActivation2);
                        }
                    }
                    finally {
                        ObjectNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(activityNodeActivation2);
                    }
                }
                finally {
                    PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(activityNodeActivation2);
                }
            }
            finally {
                AcceptEventActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(activityNodeActivation2);
            }
        }
        finally {
            CallActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(activityNodeActivation2);
        }
        if (ready) {
            ArrayList<IToken> arrayList = tokens;
            ActivityNodeActivation activityNodeActivation3 = this;
            ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityNodeActivationProfiler$1$e1c57393(activityNodeActivation3, arrayList);
            activityNodeActivation3.fire(arrayList);
        }
    }

    public List<IToken> takeOfferedTokens() {
        ArrayList<IToken> allTokens = new ArrayList<IToken>();
        List<IActivityEdgeInstance> incomingEdges = this.incomingEdges;
        int i = 0;
        while (i < incomingEdges.size()) {
            IActivityEdgeInstance incomingEdge;
            IActivityEdgeInstance iActivityEdgeInstance = incomingEdge = incomingEdges.get(i);
            List list = iActivityEdgeInstance.takeOfferedTokens();
            ActivityEdgeInstanceProfiler.aspectOf().ajc$afterReturning$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$2$2af4857d(iActivityEdgeInstance, list);
            List tokens = list;
            int j = 0;
            while (j < tokens.size()) {
                IToken token = (IToken)tokens.get(j);
                allTokens.add(token);
                ++j;
            }
            ++i;
        }
        return allTokens;
    }

    public abstract void fire(List<IToken> var1);

    public void sendOffers(List<IToken> tokens) {
        if (tokens.size() > 0) {
            List<IActivityEdgeInstance> outgoingEdges = this.outgoingEdges;
            for (IActivityEdgeInstance outgoingEdge : outgoingEdges) {
                List<IToken> list = tokens;
                IActivityEdgeInstance iActivityEdgeInstance = outgoingEdge;
                ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityEdgeInstanceProfiler$1$49177e35(iActivityEdgeInstance, list);
                iActivityEdgeInstance.sendOffer(list);
            }
        }
    }

    public void terminate() {
        if (this.running.booleanValue()) {
            if (this.node != null) {
                Debug.println("[terminate] node = " + this.node.getName());
            } else {
                Debug.println("[terminate] Anonymous activation of type " + this.getClass().getName());
            }
        }
        this.running = false;
    }

    public Boolean isReady() {
        return this.isRunning();
    }

    public Boolean isRunning() {
        return this.running;
    }

    public void addOutgoingEdge(IActivityEdgeInstance edge) {
        edge.setSource((IActivityNodeActivation)this);
        this.getOutgoingEdges().add(edge);
    }

    public void addIncomingEdge(IActivityEdgeInstance edge) {
        edge.setTarget((IActivityNodeActivation)this);
        this.getIncomingEdges().add(edge);
    }

    public void createNodeActivations() {
    }

    public void createEdgeInstances() {
    }

    public Boolean isSourceFor(IActivityEdgeInstance edgeInstance) {
        if (edgeInstance.getSource() == this) {
            return true;
        }
        return false;
    }

    public IActivityExecution getActivityExecution() {
        return this.getGroup().getActivityExecution();
    }

    public IObject_ getExecutionContext() {
        return this.getActivityExecution().getContext();
    }

    public ILocus getExecutionLocus() {
        return this.getActivityExecution().getLocus();
    }

    public IActivityNodeActivation getNodeActivation(ActivityNode node) {
        ActivityNodeActivation activation = null;
        if (node == this.getNode()) {
            activation = this;
        }
        return activation;
    }

    public void addToken(IToken token) {
        if (this.node == null) {
            Debug.println("[addToken] ...");
        } else {
            Debug.println("[addToken] node = " + this.node.getName());
        }
        IToken transferredToken = token.transfer((IActivityNodeActivation)this);
        this.heldTokens.add(transferredToken);
    }

    public Integer removeToken(IToken token) {
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.heldTokens.size()) {
            if (this.heldTokens.get(i - 1) == token) {
                if (this.node == null) {
                    Debug.println("[removeToken] ...");
                } else {
                    Debug.println("[removeToken] node = " + this.node.getName());
                }
                this.heldTokens.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
        i = notFound ? 0 : --i;
        return i;
    }

    public void addTokens(List<IToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            IToken token = tokens.get(i);
            this.addToken(token);
            ++i;
        }
    }

    public List<IToken> takeTokens() {
        List<IToken> tokens = this.getTokens();
        this.clearTokens();
        return tokens;
    }

    public void clearTokens() {
        while (this.heldTokens.size() > 0) {
            this.heldTokens.get(0).withdraw();
        }
    }

    public List<IToken> getTokens() {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        List<IToken> heldTokens = this.heldTokens;
        int i = 0;
        while (i < heldTokens.size()) {
            IToken heldToken = heldTokens.get(i);
            tokens.add(heldToken);
            ++i;
        }
        return tokens;
    }

    public void initialize(ActivityNode node, IActivityNodeActivationGroup group) {
        this.setNode(node);
        this.setGroup(group);
        this.running = false;
    }

    public void suspend() {
        this.getGroup().suspend((IActivityNodeActivation)this);
    }

    public void resume() {
        this.getGroup().resume((IActivityNodeActivation)this);
    }

    public void setNode(ActivityNode node) {
        this.node = node;
    }

    public ActivityNode getNode() {
        return this.node;
    }

    public void setGroup(IActivityNodeActivationGroup group) {
        this.group = group;
    }

    public IActivityNodeActivationGroup getGroup() {
        return this.group;
    }

    public List<IActivityEdgeInstance> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<IActivityEdgeInstance> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public void setRunning(Boolean status) {
        this.running = status;
    }
}

