/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.loadtime.definition.DocumentParser;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

public class AspectAdminImpl
implements AspectAdmin,
SynchronousBundleListener {
    private final Map<Bundle, Definition> aspectDefinitions = new ConcurrentHashMap<Bundle, Definition>();
    private final Map<Bundle, Definition> aspectDefinitionsExported = new ConcurrentHashMap<Bundle, Definition>();
    private final Map<Bundle, Map<String, Integer>> aspectPolicies = new ConcurrentHashMap<Bundle, Map<String, Integer>>();

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.bundleResolved(event.getBundle());
        } else if (event.getType() == 64) {
            this.bundleUnresolved(event.getBundle());
        }
    }

    public void bundleResolved(Bundle bundle) {
        if (!(this.aspectDefinitions.containsKey(bundle) || this.aspectDefinitionsExported.containsKey(bundle) || this.aspectPolicies.containsKey(bundle))) {
            this.parseDefinitions(bundle);
        }
    }

    public void bundleUnresolved(Bundle bundle) {
        this.aspectDefinitions.remove(bundle);
        this.aspectDefinitionsExported.remove(bundle);
        this.aspectPolicies.remove(bundle);
    }

    @Override
    public Definition getAspectDefinition(Bundle bundle) {
        return this.aspectDefinitions.get(bundle);
    }

    @Override
    public int getAspectPolicy(Bundle bundle, String packageName) {
        Integer policy;
        Map<String, Integer> policies = this.aspectPolicies.get(bundle);
        if (policies != null && (policy = policies.get(packageName)) != null) {
            return policy;
        }
        return 0;
    }

    public String getDefinitionLocation(Bundle bundle) {
        String aopContextHeader = (String)bundle.getHeaders("").get("Eclipse-AspectContext");
        if (aopContextHeader != null) {
            aopContextHeader = aopContextHeader.trim();
            return aopContextHeader;
        }
        return "META-INF/aop.xml";
    }

    @Override
    public Definition getExportedAspectDefinitions(Bundle bundle) {
        return this.aspectDefinitionsExported.get(bundle);
    }

    public void initialize(Bundle[] bundles) {
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            int state = bundle.getState();
            if (state != 2 && state != 1) {
                this.parseDefinitions(bundle);
            }
            ++n2;
        }
    }

    @Override
    public Definition resolveImportedPackage(Bundle bundle, String packageName, int applyAspectsPolicy) {
        if (1 == applyAspectsPolicy) {
            Definition exportedAspectDefinitions = this.getExportedAspectDefinitions(bundle);
            Definition result = new Definition();
            if (exportedAspectDefinitions != null) {
                List aspectClassNames = exportedAspectDefinitions.getAspectClassNames();
                for (Object aspectClassName : aspectClassNames) {
                    String aspectName = (String)aspectClassName;
                    String aspectPackageName = this.getPackage(aspectName);
                    if (!aspectPackageName.equals(packageName)) continue;
                    result.getAspectClassNames().add(aspectName);
                }
                for (Definition.ConcreteAspect concreteAspect : exportedAspectDefinitions.getConcreteAspects()) {
                    if (concreteAspect.name == null || !this.getPackage(concreteAspect.name).equals(packageName)) continue;
                    result.getConcreteAspects().add(concreteAspect);
                }
                if (exportedAspectDefinitions.getWeaverOptions().trim().length() > 0) {
                    result.appendWeaverOptions(exportedAspectDefinitions.getWeaverOptions());
                }
            }
            if (result.getAspectClassNames().size() > 0 || result.getConcreteAspects().size() > 0 || result.getWeaverOptions().length() > 0) {
                return result;
            }
            return null;
        }
        if (2 == applyAspectsPolicy) {
            return null;
        }
        Definition exportedAspectDefinitions = this.getExportedAspectDefinitions(bundle);
        Definition result = new Definition();
        if (exportedAspectDefinitions != null) {
            List aspectClassNames = exportedAspectDefinitions.getAspectClassNames();
            for (Object aspectClassName : aspectClassNames) {
                String aspectName = (String)aspectClassName;
                String aspectPackageName = this.getPackage(aspectName);
                int aspectPolicy = this.getAspectPolicy(bundle, aspectPackageName);
                if (!aspectPackageName.equals(packageName) || aspectPolicy != 0 && 2 != aspectPolicy) continue;
                result.getAspectClassNames().add(aspectName);
            }
            for (Definition.ConcreteAspect concreteAspect : exportedAspectDefinitions.getConcreteAspects()) {
                String aspectPackageName = this.getPackage(concreteAspect.name);
                int aspectPolicy = this.getAspectPolicy(bundle, aspectPackageName);
                if (!aspectPackageName.equals(packageName) || aspectPolicy != 0 && 2 != aspectPolicy) continue;
                result.getConcreteAspects().add(concreteAspect);
            }
            if (exportedAspectDefinitions.getWeaverOptions().trim().length() > 0) {
                result.appendWeaverOptions(exportedAspectDefinitions.getWeaverOptions());
            }
        }
        if (result.getAspectClassNames().size() > 0 || result.getConcreteAspects().size() > 0 || result.getWeaverOptions().length() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public Definition resolveRequiredBundle(Bundle bundle, int applyAspectsPolicy) {
        if (1 == applyAspectsPolicy) {
            return this.getExportedAspectDefinitions(bundle);
        }
        if (2 == applyAspectsPolicy) {
            return null;
        }
        Definition exportedAspectDefinitions = this.getExportedAspectDefinitions(bundle);
        Definition result = new Definition();
        if (exportedAspectDefinitions != null) {
            int aspectPolicy;
            String aspectPackage;
            for (String aspect : exportedAspectDefinitions.getAspectClassNames()) {
                aspectPackage = this.getPackage(aspect);
                aspectPolicy = this.getAspectPolicy(bundle, aspectPackage);
                if (aspectPolicy != 0 && aspectPolicy != 2) continue;
                result.getAspectClassNames().add(aspect);
            }
            for (Definition.ConcreteAspect concreteAspect : exportedAspectDefinitions.getConcreteAspects()) {
                aspectPackage = this.getPackage(concreteAspect.name);
                aspectPolicy = this.getAspectPolicy(bundle, aspectPackage);
                if (aspectPolicy != 0 && aspectPolicy != 2) continue;
                result.getConcreteAspects().add(concreteAspect);
            }
            if (exportedAspectDefinitions.getWeaverOptions().trim().length() > 0) {
                result.appendWeaverOptions(exportedAspectDefinitions.getWeaverOptions());
            }
        }
        if (result.getAspectClassNames().size() > 0 || result.getConcreteAspects().size() > 0 || result.getWeaverOptions().length() > 0) {
            return result;
        }
        return null;
    }

    protected void parseDefinitions(Bundle bundle) {
        try {
            Definition allAspectsDefinition = null;
            LinkedHashSet<String> exportedAspects = new LinkedHashSet<String>();
            HashSet<Definition.ConcreteAspect> exportedConcreteAspects = new HashSet<Definition.ConcreteAspect>();
            HashMap<String, Integer> policies = new HashMap<String, Integer>();
            HashSet<String> exportedPackages = new HashSet<String>();
            String aopXmlLocation = this.getDefinitionLocation(bundle);
            URL aopXmlDef = bundle.getEntry(aopXmlLocation);
            if (aopXmlDef != null) {
                allAspectsDefinition = DocumentParser.parse((URL)aopXmlDef);
            }
            Dictionary manifest = bundle.getHeaders("");
            ManifestElement[] exports = ManifestElement.parseHeader((String)"Export-Package", (String)((String)manifest.get("Export-Package")));
            int i = 0;
            while (exports != null && i < exports.length) {
                String[] aspects;
                String allaspects;
                String packageName = exports[i].getValue();
                exportedPackages.add(packageName);
                String policy = exports[i].getDirective("aspect-policy");
                if (policy != null && policy.trim().toLowerCase().equals("opt-out")) {
                    policies.put(packageName, 2);
                }
                if (policy != null && policy.trim().toLowerCase().equals("opt-in")) {
                    policies.put(packageName, 1);
                }
                if ((allaspects = exports[i].getAttribute("aspects")) != null && (aspects = ManifestElement.getArrayFromList((String)allaspects)) != null) {
                    String[] stringArray = aspects;
                    int n = aspects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String aspect = stringArray[n2];
                        exportedAspects.add(String.valueOf(packageName) + "." + aspect);
                        ++n2;
                    }
                }
                ++i;
            }
            if (allAspectsDefinition != null && allAspectsDefinition.getAspectClassNames() != null) {
                for (String aspect : allAspectsDefinition.getAspectClassNames()) {
                    String packageName = this.getPackage(aspect);
                    if (!exportedPackages.contains(packageName)) continue;
                    exportedAspects.add(aspect);
                }
            }
            if (allAspectsDefinition != null && allAspectsDefinition.getConcreteAspects().size() > 0) {
                for (Definition.ConcreteAspect concreteAspect : allAspectsDefinition.getConcreteAspects()) {
                    if (concreteAspect.name == null || !exportedPackages.contains(this.getPackage(concreteAspect.name))) continue;
                    exportedConcreteAspects.add(concreteAspect);
                }
            }
            if (allAspectsDefinition != null) {
                this.aspectDefinitions.put(bundle, allAspectsDefinition);
            }
            if (exportedAspects.size() > 0 || exportedConcreteAspects.size() > 0 || allAspectsDefinition != null && allAspectsDefinition.getWeaverOptions().length() > 0) {
                Definition exportedAspectsDefinition = new Definition();
                exportedAspectsDefinition.getAspectClassNames().addAll(exportedAspects);
                exportedAspectsDefinition.getConcreteAspects().addAll(exportedConcreteAspects);
                if (allAspectsDefinition != null && allAspectsDefinition.getWeaverOptions().trim().length() > 0) {
                    exportedAspectsDefinition.appendWeaverOptions(allAspectsDefinition.getWeaverOptions());
                }
                this.aspectDefinitionsExported.put(bundle, exportedAspectsDefinition);
            }
            if (policies.size() > 0) {
                this.aspectPolicies.put(bundle, policies);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPackage(String aspect) {
        int index = aspect.lastIndexOf(46);
        if (index >= 0) {
            return aspect.substring(0, index);
        }
        return "";
    }
}

