/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.writing.impl;

import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphMappingHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphWidgetBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.XYGraphUpdateStrategy;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;

public class DefaultXYGraphUpdateStrategy
implements XYGraphUpdateStrategy {
    @Override
    public void updateXYGraph(XYGraph xy, XYGraphWidgetBinder graphMap) {
        XYGraphDescriptor gDesc = graphMap.getXYGraphDescriptor();
        gDesc.setTitle(xy.getTitle());
        gDesc.setTitleColor(XYGraphMappingHelper.mapColor(xy.getTitleColor()));
        gDesc.setTitleFont(XYGraphMappingHelper.mapFontData(xy.getTitleFontData()));
        gDesc.setZoomType(XYGraphMappingHelper.mapZoomType(xy.getZoomType()));
        gDesc.setShowLegend(xy.isShowLegend());
        gDesc.setShowTitle(xy.isShowTitle());
        gDesc.setTransparent(xy.isTransparent());
        gDesc.setShowPlotAreaBorder(xy.getPlotArea().isShowBorder());
        gDesc.setPlotAreaBackgroundColor(XYGraphMappingHelper.mapColor(xy.getPlotArea().getBackgroundColor()));
    }

    @Override
    public void addTrace(XYGraphDescriptor gDesc, TraceDescriptor trace) {
        gDesc.getTraceDescriptors().add((Object)trace);
    }

    @Override
    public void setTraceVisibility(XYGraphDescriptor gDesc, TraceDescriptor tDesc, boolean visible) {
        if (visible) {
            gDesc.getVisibleTraces().add((Object)tDesc);
        } else {
            gDesc.getVisibleTraces().remove((Object)tDesc);
        }
    }
}

