/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.common.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.papyrus.moka.xygraph.common.ui.XYGraphEditorPartSelectionProvider;
import org.eclipse.papyrus.moka.xygraph.common.ui.XYGraphLabelProvider;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphCoordinator;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.impl.MouseWheelZoomer;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.part.EditorPart;

public class XYGraphEditorPart
extends EditorPart
implements PropertyChangeListener {
    private XYGraphCoordinator coordinator;
    private XYGraphLabelProvider lblProvider;
    private boolean dirty;

    public XYGraphEditorPart(XYGraphCoordinator coordinator, XYGraphLabelProvider lblProvider) {
        this.coordinator = coordinator;
        this.lblProvider = lblProvider;
    }

    public void doSave(IProgressMonitor monitor) {
        this.dirty = false;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput((IEditorInput)new NullEditorInput());
        this.setPartName(this.coordinator.getXYGraphDescriptor().getTitle());
        site.setSelectionProvider((ISelectionProvider)new XYGraphEditorPartSelectionProvider(this.coordinator.getXYGraphDescriptor()));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        Canvas canvas = new Canvas(parent, 0);
        LightweightSystem lws = new LightweightSystem(canvas);
        lws.setContents((IFigure)this.buildGraphFromModel(canvas));
    }

    protected ToolbarArmedXYGraph buildGraphFromModel(Canvas canvas) {
        IXYGraph xyGraph = this.coordinator.buildXYGraph();
        xyGraph.addPropertyChangeListener("config", (PropertyChangeListener)this);
        xyGraph.addPropertyChangeListener("zoomType", (PropertyChangeListener)this);
        canvas.addMouseWheelListener((MouseWheelListener)new MouseWheelZoomer(xyGraph));
        return new ToolbarArmedXYGraph(xyGraph);
    }

    public void setFocus() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("config".equals(evt.getPropertyName())) {
            XYGraphDescriptor gDesc = this.coordinator.getXYGraphDescriptor();
            gDesc.getContext();
            this.coordinator.updateDescriptors((XYGraph)evt.getNewValue());
            this.lblProvider.onGraphUpdated(gDesc);
            this.dirty = true;
        }
    }
}

