/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.table.instancespecification.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.eclipse.papyrus.moka.ui.table.instancespecification.Messages;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;

public class InstanceSpecificationTableUtil {
    public static final String INSTANCE_SPEC_TABLE_TYPE = "InstanceSpecificationTable";

    public static Map<ValueSpecification, String> collectSlotsValuesAndNames(InstanceSpecification contextInstance) {
        ArrayList<InstanceSpecification> visitedInstances = new ArrayList<InstanceSpecification>();
        return InstanceSpecificationTableUtil.collectSlotsValuesAndNames(contextInstance, visitedInstances, contextInstance.getLabel());
    }

    private static Map<ValueSpecification, String> collectSlotsValuesAndNames(InstanceSpecification contextInstance, List<InstanceSpecification> visitedInstances, String namePath) {
        HashMap<ValueSpecification, String> result = new HashMap<ValueSpecification, String>();
        visitedInstances.add(contextInstance);
        for (Slot slot : contextInstance.getSlots()) {
            String slotNamePath = namePath;
            slotNamePath = slot.getDefiningFeature() != null ? String.valueOf(slotNamePath) + "." + slot.getDefiningFeature().getLabel() : String.valueOf(slotNamePath) + "." + Messages.NoFeatureName;
            int i = 0;
            while (i < slot.getValues().size()) {
                InstanceSpecification instanceSpec;
                ValueSpecification value = (ValueSpecification)slot.getValues().get(i);
                if (slot.getValues().size() > 1) {
                    slotNamePath = String.valueOf(slotNamePath) + "[" + i + "]";
                }
                result.put(value, slotNamePath);
                if (value instanceof InstanceValue && (instanceSpec = ((InstanceValue)value).getInstance()) != null && !visitedInstances.contains(instanceSpec)) {
                    result.putAll(InstanceSpecificationTableUtil.collectSlotsValuesAndNames(instanceSpec, visitedInstances, slotNamePath));
                }
                ++i;
            }
        }
        return result;
    }

    public static Map<Slot, String> collectSlotsAndNames(InstanceSpecification contextInstance) {
        ArrayList<InstanceSpecification> visitedInstances = new ArrayList<InstanceSpecification>();
        return InstanceSpecificationTableUtil.collectSlotsAndNames(contextInstance, visitedInstances, contextInstance.getLabel());
    }

    private static Map<Slot, String> collectSlotsAndNames(InstanceSpecification contextInstance, List<InstanceSpecification> visitedInstances, String namePath) {
        HashMap<Slot, String> result = new HashMap<Slot, String>();
        visitedInstances.add(contextInstance);
        for (Slot slot : contextInstance.getSlots()) {
            String slotNamePath = namePath;
            slotNamePath = slot.getDefiningFeature() != null ? String.valueOf(slotNamePath) + "." + slot.getDefiningFeature().getLabel() : String.valueOf(slotNamePath) + "." + Messages.NoFeatureName;
            result.put(slot, slotNamePath);
            int i = 0;
            while (i < slot.getValues().size()) {
                ValueSpecification value = (ValueSpecification)slot.getValues().get(i);
                String newPath = slotNamePath;
                if (value instanceof InstanceValue) {
                    InstanceSpecification instanceSpec;
                    if (slot.getValues().size() > 1) {
                        newPath = String.valueOf(newPath) + "[" + i + "]";
                    }
                    if ((instanceSpec = ((InstanceValue)value).getInstance()) != null && !visitedInstances.contains(instanceSpec)) {
                        result.putAll(InstanceSpecificationTableUtil.collectSlotsAndNames(instanceSpec, visitedInstances, newPath));
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private static void normalizeNames(Map<Slot, String> map) {
        OptionalInt maxLength = map.values().stream().mapToInt(String::length).max();
        if (maxLength.isPresent()) {
            for (Map.Entry<Slot, String> entry : map.entrySet()) {
                entry.setValue(InstanceSpecificationTableUtil.getNormalizedName(entry.getValue(), maxLength.getAsInt()));
            }
        }
    }

    private static String getNormalizedName(String value, int maxLength) {
        String result = value;
        int i = value.length();
        while (i < maxLength) {
            result = String.valueOf(result) + ".";
            ++i;
        }
        return result;
    }
}

