/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine.debug;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fmu.engine.control.EngineStatus;
import org.eclipse.papyrus.moka.fmu.engine.control.FMUControlService;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUObject;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.utils.UMLPrimitiveTypesUtils;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Property;

public class FMUDebugDialog
extends Dialog {
    protected FMUDebugDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2144);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        FMUEngineUtils.getFMUControlService().terminate();
    }

    protected void okPressed() {
        super.okPressed();
        FMUEngineUtils.getFMUControlService().terminate();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        FMUEngineUtils.getFMUControlService().terminate();
    }

    protected Control createDialogArea(Composite dialogArea) {
        Composite parent = new Composite(dialogArea, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        Label stepSizeLabel = new Label(parent, 8);
        stepSizeLabel.setText("Step size:");
        final Text stepText = new Text(parent, 4);
        stepText.setText("0.1");
        Label currentTimeLabel = new Label(parent, 8);
        currentTimeLabel.setText("Current time:");
        final Text currentTimeText = new Text(parent, 4);
        currentTimeText.setText("");
        currentTimeText.setEditable(false);
        Label inputsLabel = new Label(parent, 8);
        inputsLabel.setText("inputs:");
        final Table inputTable = new Table(parent, 2824);
        TableColumn inputColumnName = new TableColumn(inputTable, 2052);
        inputColumnName.setWidth(100);
        inputColumnName.setResizable(true);
        inputColumnName.setText("Name");
        TableColumn inputColumnValue = new TableColumn(inputTable, 2052);
        inputColumnValue.setWidth(100);
        inputColumnValue.setResizable(true);
        inputColumnValue.setText("Value");
        inputTable.setHeaderVisible(true);
        final TableEditor editor = new TableEditor(inputTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 100;
        Label outputsLabel = new Label(parent, 8);
        outputsLabel.setText("outputs:");
        final Table outputTable = new Table(parent, 2824);
        final Button initButton = new Button(parent, 0);
        initButton.setText("Init");
        final Button stepButton = new Button(parent, 0);
        stepButton.setText("Step");
        stepButton.setEnabled(false);
        inputTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)inputTable, 0);
                newEditor.setText(item.getText(1));
                newEditor.addModifyListener(me -> {
                    Text text = (Text)editor.getEditor();
                    editor.getItem().setText(1, text.getText());
                });
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent arg0) {
                        boolean validEntry = FMUDebugDialog.this.isValidEntry(editor.getItem().getText(0), editor.getItem().getText(1));
                        stepButton.setEnabled(validEntry);
                        if (!validEntry) {
                            editor.getItem().setForeground(Display.getCurrent().getSystemColor(3));
                        } else {
                            editor.getItem().setForeground(Display.getCurrent().getSystemColor(2));
                        }
                    }

                    public void keyPressed(KeyEvent arg0) {
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 1);
            }
        });
        TableColumn outputColumnName = new TableColumn(outputTable, 2052);
        outputColumnName.setWidth(100);
        outputColumnName.setResizable(true);
        outputColumnName.setText("Name");
        TableColumn outputColumnValue = new TableColumn(outputTable, 2052);
        outputColumnValue.setWidth(100);
        outputColumnValue.setResizable(true);
        outputColumnValue.setText("Value");
        outputTable.setHeaderVisible(true);
        this.createInputOutputTableItems(inputTable, true);
        this.createInputOutputTableItems(outputTable, false);
        initButton.addListener(3, new Listener(){

            public void handleEvent(Event arg0) {
                final FMUControlService fmuControlService = FMUEngineUtils.getFMUControlService();
                fmuControlService.setEngineStatus(EngineStatus.INIT);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        fmuControlService.init();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                initButton.setEnabled(false);
                                if (FMUDebugDialog.this.canParseDouble(stepText.getText())) {
                                    stepButton.setEnabled(true);
                                }
                                FMUDebugDialog.this.updateInputOutputTableItems(inputTable, true);
                                FMUDebugDialog.this.updateInputOutputTableItems(outputTable, false);
                                currentTimeText.setText("" + DEScheduler.getInstance().getCurrentTime());
                            }
                        });
                    }
                }).start();
            }
        });
        stepButton.addListener(3, new Listener(){

            public void handleEvent(Event arg0) {
                stepButton.setEnabled(false);
                final double stepSize = new Double(stepText.getText());
                FMUControlService fmuControlService = FMUEngineUtils.getFMUControlService();
                fmuControlService.setEngineStatus(EngineStatus.STEPPING);
                FMUDebugDialog.this.setInputValues(inputTable);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        FMUControlService fmuControlService = FMUEngineUtils.getFMUControlService();
                        fmuControlService.doStep(DEScheduler.getInstance().getCurrentTime(), stepSize);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FMUDebugDialog.this.updateInputOutputTableItems(outputTable, false);
                                currentTimeText.setText("" + DEScheduler.getInstance().getCurrentTime());
                                stepButton.setEnabled(true);
                            }
                        });
                    }
                }).start();
            }
        });
        stepText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                if (FMUDebugDialog.this.canParseDouble(stepText.getText())) {
                    if (!initButton.getEnabled()) {
                        stepButton.setEnabled(true);
                    }
                } else {
                    stepButton.setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        return parent;
    }

    protected boolean isValidEntry(String propertyName, String value) {
        Property property;
        FMUObject fmuObject = FMUEngineUtils.getFMUControlService().getFmuObject();
        Integer index = (Integer)fmuObject.getPropertyNameToIndexMap().get(propertyName);
        if (index != null && (property = (Property)fmuObject.getIndexToUMLPropertyMap().get(index)) != null) {
            if (UMLPrimitiveTypesUtils.getBoolean((EObject)property).equals(property.getType())) {
                return this.canParseBoolean(value);
            }
            if (UMLPrimitiveTypesUtils.getInteger((EObject)property).equals(property.getType())) {
                return this.canParseInteger(value);
            }
            if (UMLPrimitiveTypesUtils.getReal((EObject)property).equals(property.getType())) {
                return this.canParseDouble(value);
            }
            if (UMLPrimitiveTypesUtils.getString((EObject)property).equals(property.getType())) {
                return true;
            }
        }
        return false;
    }

    protected boolean canParseDouble(String s) {
        try {
            new Double(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    protected boolean canParseInteger(String s) {
        try {
            new Integer(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    protected boolean canParseBoolean(String s) {
        if (s != null) {
            return "true".equals(s.toLowerCase()) || "false".equals(s.toLowerCase());
        }
        return false;
    }

    protected void createInputOutputTableItems(Table table, boolean isInput) {
        TableItem item;
        Property p;
        FMUObject _object = FMUEngineUtils.getFMUControlService().getFmuObject();
        for (Integer k : _object.fmiGetBools().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = new TableItem(table, 0);
            item.setText(new String[]{p.getName(), ""});
        }
        for (Integer k : _object.fmiGetIntegers().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = new TableItem(table, 0);
            item.setText(new String[]{p.getName(), ""});
        }
        for (Integer k : _object.fmiGetReals().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = new TableItem(table, 0);
            item.setText(new String[]{p.getName(), ""});
        }
        for (Integer k : _object.fmiGetStrings().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = new TableItem(table, 0);
            item.setText(new String[]{p.getName(), ""});
        }
    }

    protected void updateInputOutputTableItems(Table table, boolean isInput) {
        TableItem item;
        Property p;
        FMUObject _object = FMUEngineUtils.getFMUControlService().getFmuObject();
        int i = 0;
        for (Integer k : _object.fmiGetBools().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = table.getItem(i);
            item.setText(new String[]{p.getName(), "" + _object.fmiGetBools().get(k)});
            ++i;
        }
        for (Integer k : _object.fmiGetIntegers().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = table.getItem(i);
            item.setText(new String[]{p.getName(), "" + _object.fmiGetIntegers().get(k)});
            ++i;
        }
        for (Integer k : _object.fmiGetReals().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = table.getItem(i);
            item.setText(new String[]{p.getName(), "" + _object.fmiGetReals().get(k)});
            ++i;
        }
        for (Integer k : _object.fmiGetStrings().keySet()) {
            p = (Property)_object.getIndexToUMLPropertyMap().get(k);
            if ((isInput || !FMIProfileUtil.isOutputPort((Property)p)) && (!isInput || !FMIProfileUtil.isInputPort((Property)p))) continue;
            item = table.getItem(i);
            item.setText(new String[]{p.getName(), (String)_object.fmiGetStrings().get(k)});
            ++i;
        }
        table.redraw();
    }

    protected void setInputValues(Table inputTable) {
        HashMap<Integer, Boolean> boolMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, String> stringMap = new HashMap<Integer, String>();
        HashMap<Integer, Integer> integerMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> realMap = new HashMap<Integer, Double>();
        FMUObject fmuObject = FMUEngineUtils.getFMUControlService().getFmuObject();
        TableItem[] tableItemArray = inputTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem t = tableItemArray[n2];
            String inputName = t.getText(0);
            String value = t.getText(1);
            Integer propertyIndex = (Integer)fmuObject.getPropertyNameToIndexMap().get(inputName);
            Property property = (Property)fmuObject.getIndexToUMLPropertyMap().get(propertyIndex);
            if (UMLPrimitiveTypesUtils.getBoolean((EObject)property).equals(property.getType())) {
                Boolean booleanValue = Boolean.parseBoolean(value);
                boolMap.put(propertyIndex, booleanValue);
            } else if (UMLPrimitiveTypesUtils.getInteger((EObject)property).equals(property.getType())) {
                Integer integerValue = Integer.parseInt(value);
                integerMap.put(propertyIndex, integerValue);
            } else if (UMLPrimitiveTypesUtils.getString((EObject)property).equals(property.getType())) {
                stringMap.put(propertyIndex, value);
            } else if (UMLPrimitiveTypesUtils.getReal((EObject)property).equals(property.getType())) {
                Double realValue = Double.parseDouble(value);
                realMap.put(propertyIndex, realValue);
            }
            ++n2;
        }
        fmuObject.fmiSetBools(boolMap);
        fmuObject.fmiSetIntegers(integerMap);
        fmuObject.fmiSetReals(realMap);
        fmuObject.fmiSetStrings(stringMap);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("FMU Controller");
    }
}

