/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.service;

import org.eclipse.papyrus.moka.datavisualization.service.VariableEntry;
import org.eclipse.papyrus.moka.xygraph.mapping.common.Variable;
import org.eclipse.papyrus.moka.xygraph.mapping.util.DataBatch;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;

public class VariableDataEntry
extends VariableEntry {
    private TraceDescriptor traceDescriptor;
    private DataBatch valuesBatch;
    private int lastFlushedIndex = -1;

    public VariableDataEntry(Variable variable, TraceDescriptor trace) {
        super(variable);
        this.traceDescriptor = trace;
    }

    public VariableDataEntry(Variable variable) {
        super(variable);
        this.traceDescriptor = null;
    }

    public void setData(DataBatch valuesBatch) {
        if (this.valuesBatch != null) {
            this.valuesBatch.clean();
        }
        this.valuesBatch = valuesBatch;
        this.resetFlushedIndex();
        this.markUpdate();
    }

    public DataBatch getValuesBatch() {
        return this.valuesBatch;
    }

    public void markFlush() {
        this.lastFlushedIndex = this.valuesBatch.size();
    }

    public void resetFlushedIndex() {
        this.lastFlushedIndex = 0;
    }

    public int getLastFlushedIndex() {
        return this.lastFlushedIndex;
    }

    public TraceDescriptor getTraceDescriptor() {
        return this.traceDescriptor;
    }

    public void setTraceDescriptor(TraceDescriptor traceDescriptor) {
        this.traceDescriptor = traceDescriptor;
    }
}

