/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine;

import org.eclipse.papyrus.moka.composites.Semantics.impl.CommonBehaviors.Communications.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CommonBehaviors.Communications.CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions.CS_DefaultRequestPropagationStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.Loci.LociL3.CS_Executor;
import org.eclipse.papyrus.moka.discreteevent.AbstractPushPullStrategy;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.Event;
import org.eclipse.papyrus.moka.discreteevent.actions.Action;
import org.eclipse.papyrus.moka.fmu.control.queue.FMIRootExecution;
import org.eclipse.papyrus.moka.fmu.engine.control.FMUControlService;
import org.eclipse.papyrus.moka.fmu.engine.de.FMIPushPullStrategy;
import org.eclipse.papyrus.moka.fmu.engine.de.FMUStepEnd;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUConstructStrategy;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUExecutionFactory;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMULocus;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.fmu.json.JSONSocketClient;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutor;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.IntermediateActions.DefaultCreateObjectActionStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.IntermediateActions.DefaultGetAssociationStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.RedefinitionBasedDispatchStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.Communications.FIFOGetNextEventStrategy;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Loci.LociL1.FirstChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.control.queue.ExecutionController;
import org.eclipse.papyrus.moka.fuml.control.queue.ExecutionLoop;
import org.eclipse.papyrus.moka.timedfuml.TimedUmlExecutionEngine;
import org.eclipse.papyrus.moka.timedfuml.control.queue.TimedExecutionLoop;
import org.eclipse.uml2.uml.Class;

public class MokaEngineForFMUExport
extends TimedUmlExecutionEngine {
    Thread mainThread = null;

    protected void initDEScheduler() {
        DEScheduler.init((double)-1.0, (AbstractPushPullStrategy)new FMIPushPullStrategy());
    }

    protected void doPreRunActions() {
        FMUStepEnd stepEnd = new FMUStepEnd();
        DEScheduler.getInstance().pushEvent(new Event(0.0, (Action)stepEnd));
    }

    public ILocus initializeLocus() {
        this.locus = new FMULocus();
        this.locus.setExecutor((IExecutor)new CS_Executor());
        this.locus.setFactory((IExecutionFactory)new FMUExecutionFactory());
        return this.locus;
    }

    protected void run_() {
        ExecutionController.getInstance().setExecutionLoop((ExecutionLoop)new TimedExecutionLoop());
        FMUControlService controlService = FMUEngineUtils.getFMUControlService();
        controlService.setRootExecution(new FMIRootExecution((Class)this.executionEntryPoint, this.executionArguments, this.locus));
        Runnable execution = new Runnable(){

            @Override
            public void run() {
                JSONSocketClient client = FMUEngineUtils.getJsonSocketClient();
                client.setFmu(FMUEngineUtils.getFMUControlService());
                client.start();
                FMUEngineUtils.getFMUControlService().waitForTermination();
            }
        };
        this.mainThread = new Thread(execution, "Moka - Main thread");
        this.mainThread.start();
    }

    public void waitForTermination() throws InterruptedException {
        if (this.mainThread != null) {
            this.mainThread.join();
        }
    }

    protected void registerSemanticStrategies(ILocus locus) {
        locus.getFactory().setStrategy((ISemanticStrategy)new FirstChoiceStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new FIFOGetNextEventStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new RedefinitionBasedDispatchStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new DefaultCreateObjectActionStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new DefaultGetAssociationStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new CS_DispatchOperationOfInterfaceStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new CS_DefaultRequestPropagationStrategy());
        locus.getFactory().setStrategy((ISemanticStrategy)new FMUConstructStrategy());
    }
}

