/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.ui.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.moka.fmi.ui.Activator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractFMIDialog
extends Dialog {
    private FieldEditorPreferencePage page;
    private String dialogTitle;
    protected IPreferenceStore store;

    public AbstractFMIDialog(Shell parentShell, String dialogTitle) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
        newShell.setSize(500, 170);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.page = new FieldEditorPreferencePage(1){

            public void createControl(Composite parentComposite) {
                this.noDefaultAndApplyButton();
                super.createControl(parentComposite);
            }

            protected void createFieldEditors() {
                Composite fieldEditorParent = this.getFieldEditorParent();
                List<? extends FieldEditor> additionalFields = AbstractFMIDialog.this.additionalFields(fieldEditorParent);
                for (FieldEditor fieldEditor : additionalFields) {
                    this.addField(fieldEditor);
                }
            }

            protected void updateApplyButton() {
                AbstractFMIDialog.this.updateButtons(this.isValid());
                super.updateApplyButton();
            }
        };
        this.page.createControl(composite);
        Control pageControl = this.page.getControl();
        pageControl.setLayoutData((Object)new GridData(1808));
        return pageControl;
    }

    protected abstract List<? extends FieldEditor> additionalFields(Composite var1);

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons(this.page.isValid());
    }

    private void updateButtons(boolean isValid) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(isValid);
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.store = store;
    }
}

