/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.engine.MokaProcess;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.engine.MokaExecutionEngineJob;
import org.eclipse.papyrus.moka.ui.Activator;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;
import org.eclipse.papyrus.moka.utils.helper.EditorUtils;

public class MokaLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected MokaDebugTarget debugTarget;

    protected final IExecutionEngine getExecutionEngine(ILaunchConfiguration configuration) {
        String selectedExecutionEngine = null;
        try {
            selectedExecutionEngine = configuration.getAttribute(MokaConstants.EXECUTION_ENGINE_ATTRIBUTE_NAME, "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (selectedExecutionEngine == null || selectedExecutionEngine.isEmpty()) {
            selectedExecutionEngine = Activator.getDefault().getPreferenceStore().getString("Default execution engine");
        }
        return this.instantiateExecutionEngine(selectedExecutionEngine);
    }

    protected final EObject getExecutionEntryPoint(ILaunchConfiguration configuration) {
        EObject executionEntryPoint = null;
        String modelURI = null;
        try {
            modelURI = configuration.getAttribute(MokaConstants.URI_ATTRIBUTE_NAME, "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (modelURI != null) {
            ServicesRegistry servicesRegistry = (ServicesRegistry)EditorUtils.getEditorPart((String)modelURI).getAdapter(ServicesRegistry.class);
            ResourceSet resourceSet = null;
            try {
                resourceSet = (ResourceSet)servicesRegistry.getService(ModelSet.class);
            }
            catch (ServiceException serviceException) {
                resourceSet = new ResourceSetImpl();
            }
            Resource resource = resourceSet.getResource(URI.createURI((String)modelURI), true);
            String uriFragment = null;
            try {
                uriFragment = configuration.getAttribute(MokaConstants.FRAGMENT_ATTRIBUTE_NAME, "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            executionEntryPoint = resource.getEObject(uriFragment);
        }
        return executionEntryPoint;
    }

    protected IExecutionEngine instantiateExecutionEngine(String selectedExecutionEngine) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor("org.eclipse.papyrus.moka.engine");
        try {
            IConfigurationElement e = null;
            if (selectedExecutionEngine == null || selectedExecutionEngine.equals("")) {
                e = config[0];
            } else {
                int i = 0;
                while (i < config.length) {
                    if (config[i].getNamespaceIdentifier().equals(selectedExecutionEngine)) {
                        e = config[i];
                    }
                    ++i;
                }
            }
            Object o = e.createExecutableExtension("class");
            return (IExecutionEngine)o;
        }
        catch (CoreException ex) {
            org.eclipse.papyrus.infra.core.Activator.log.equals((Object)ex);
        }
        catch (Exception ex) {
            org.eclipse.papyrus.infra.core.Activator.log.equals(ex);
        }
        return null;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Start Moka Execution", 4);
        monitor.subTask("Create execution engine");
        IExecutionEngine engine = this.getExecutionEngine(configuration);
        if (engine == null) {
            this.abort("Could not instantiate execution engine", null);
        }
        monitor.worked(1);
        monitor.subTask("Figure out execution entry point");
        EObject executionEntryPoint = this.getExecutionEntryPoint(configuration);
        if (executionEntryPoint == null) {
            this.abort("The specified execution entry point is not valid or could not be found", null);
        }
        monitor.worked(1);
        monitor.subTask("Start execution engine");
        this.debugTarget = new MokaDebugTarget(launch);
        launch.addDebugTarget((IDebugTarget)this.debugTarget);
        String arguments = configuration.getAttribute(MokaConstants.ARGS_ATTRIBUTE_NAME, "");
        MokaExecutionEngineJob executionEngineJob = MokaExecutionEngineJob.getInstance();
        executionEngineJob.initialize(launch, engine, executionEntryPoint, arguments.split("\\s+"));
        MokaProcess executionEngineprocess = new MokaProcess(launch, (Job)executionEngineJob);
        launch.addProcess((IProcess)executionEngineprocess);
        this.debugTarget.setProcess(executionEngineprocess);
        executionEngineprocess.schedule(30);
        monitor.worked(1);
        monitor.done();
    }

    protected void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.moka.debug", 0, message, e));
    }
}

