/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IParameterValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.BasicBehaviors.Execution;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.CommonBehavior.SM_ObjectActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.RegionActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.StateMachineConfiguration;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines.StateMachineEventAccepter;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IRegionActivation;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateMachineConfiguration;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateMachineExecution;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IVertexActivation;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Vertex;

public class StateMachineExecution
extends Execution
implements IStateMachineExecution {
    protected List<IRegionActivation> regionActivation;
    protected IStateMachineConfiguration configuration;

    public StateMachineExecution() {
        this.regionActivation = new ArrayList<IRegionActivation>();
        this.configuration = new StateMachineConfiguration(this);
    }

    public IStateMachineConfiguration getConfiguration() {
        return this.configuration;
    }

    public StateMachineExecution(IObject_ context) {
        this.context = context;
        this.regionActivation = new ArrayList<IRegionActivation>();
        this.configuration = new StateMachineConfiguration(this);
    }

    protected void initRegions() {
        StateMachine machine = null;
        if (!this.getTypes().isEmpty()) {
            machine = (StateMachine)this.getTypes().get(0);
        }
        if (machine != null) {
            for (Region region : machine.getRegions()) {
                RegionActivation activation = (RegionActivation)this.locus.getFactory().instantiateVisitor((Element)region);
                activation.setParent((ISemanticVisitor)this);
                activation.setNode((NamedElement)region);
                this.regionActivation.add(activation);
            }
        }
    }

    public IVertexActivation getVertexActivation(Vertex vertex) {
        int i = 0;
        IVertexActivation vertexActivation = null;
        while (vertexActivation == null && i < this.regionActivation.size()) {
            vertexActivation = this.regionActivation.get(i).getVertexActivation(vertex);
            ++i;
        }
        return vertexActivation;
    }

    public void execute() {
        if (this.context != null && this.context.getObjectActivation() != null) {
            this.context.register((IEventAccepter)new StateMachineEventAccepter(this));
        }
        this.initRegions();
        for (IRegionActivation activation : this.regionActivation) {
            activation.activate();
        }
        for (IRegionActivation activation : this.regionActivation) {
            activation.activateTransitions();
        }
        for (IRegionActivation regionActivation : this.regionActivation) {
            regionActivation.enter(null, null);
        }
    }

    public IValue new_() {
        if (this.context != null) {
            return new StateMachineExecution(this.context);
        }
        return new StateMachineExecution();
    }

    public List<IRegionActivation> getRegionActivation() {
        return this.regionActivation;
    }

    public void startBehavior(Class classifier, List<IParameterValue> inputs) {
        if (this.objectActivation == null) {
            this.objectActivation = new SM_ObjectActivation();
            this.objectActivation.setObject((IObject_)this);
        }
        this.objectActivation.startBehavior(classifier, inputs);
    }

    public void terminate() {
        int i = 0;
        while (i < this.regionActivation.size()) {
            this.regionActivation.get(i).terminate();
            ++i;
        }
        this.regionActivation.clear();
    }
}

