/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.ui.tester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.moka.datavisualization.util.VisualizationUtil;

public class DataSourcePropertyTester
extends PropertyTester {
    public static final String IS_DATASOURCE = "isDataSource";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_DATASOURCE.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.containsDataSource((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        return false;
    }

    private boolean containsDataSource(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object next : selection) {
            EObject obj = EMFHelper.getEObject(next);
            if (VisualizationUtil.getDataSourceStereotype((EObject)obj) != null) continue;
            return false;
        }
        return true;
    }
}

