/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.DefaultValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterFactory;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterList;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.MokaVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IParameterValue;

public class ParameterValueVariableAdapter
extends MokaVariableAdapter<IParameterValue> {
    protected String parameterName;

    public ParameterValueVariableAdapter(MokaDebugTarget debugTarget, IParameterValue parameterValue) {
        super(debugTarget, parameterValue);
    }

    public ParameterValueVariableAdapter(MokaDebugTarget debugTarget, IParameterValue parameterValue, String parameterName) {
        this(debugTarget, parameterValue);
        this.parameterName = parameterName;
    }

    @Override
    public IValue getValue() throws DebugException {
        if (this.value == null) {
            if (((IParameterValue)this.adaptedVariable).getValues().size() == 1) {
                this.value = MokaValueAdapterFactory.getInstance().instantiate(((IParameterValue)this.adaptedVariable).getValues().iterator().next(), this.debugTarget);
            } else if (((IParameterValue)this.adaptedVariable).getValues().size() > 1) {
                MokaValueAdapterList valueList = new MokaValueAdapterList(this.debugTarget);
                for (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue currentValue : ((IParameterValue)this.adaptedVariable).getValues()) {
                    valueList.add(currentValue);
                }
                this.value = valueList;
            } else {
                this.value = new DefaultValueAdapter(this.debugTarget, (Object)null);
            }
        }
        return this.value;
    }

    public String getName() throws DebugException {
        if (this.parameterName != null && !this.parameterName.isEmpty()) {
            return this.parameterName;
        }
        if (((IParameterValue)this.adaptedVariable).getParameter() != null && ((IParameterValue)this.adaptedVariable).getParameter().getName() != null && !((IParameterValue)this.adaptedVariable).getParameter().getName().isEmpty()) {
            return ((IParameterValue)this.adaptedVariable).getParameter().getName();
        }
        return "<empty>";
    }
}

