/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.variables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.DefaultValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterFactory;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapterList;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.MokaVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.ILink;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStructuredValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.VisibilityKind;

public class FeatureValueVariableAdapter
extends MokaVariableAdapter<IFeatureValue> {
    protected IStructuredValue featureValueOwner;

    public FeatureValueVariableAdapter(MokaDebugTarget debugTarget, IStructuredValue owner, IFeatureValue featureValue) {
        super(debugTarget, featureValue);
        this.featureValueOwner = owner;
    }

    @Override
    public IValue getValue() throws DebugException {
        if (this.value == null) {
            List<org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue> resultValues = this.getValues();
            if (resultValues.size() == 1) {
                this.value = MokaValueAdapterFactory.getInstance().instantiate(resultValues.iterator().next(), this.debugTarget);
            } else if (resultValues.size() > 1) {
                MokaValueAdapterList adapterList = new MokaValueAdapterList(this.debugTarget);
                for (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue currentValue : resultValues) {
                    adapterList.add(currentValue);
                }
                this.value = adapterList;
            } else {
                this.value = new DefaultValueAdapter(this.debugTarget, (Object)null);
            }
        }
        return this.value;
    }

    public String getName() throws DebugException {
        StructuralFeature feature = ((IFeatureValue)this.adaptedVariable).getFeature();
        if (feature != null) {
            return feature.getName();
        }
        return "<unamed feature>";
    }

    public boolean isFeaturePublic() {
        if (this.adaptedVariable != null) {
            return ((IFeatureValue)this.adaptedVariable).getFeature().getVisibility() == VisibilityKind.PUBLIC_LITERAL;
        }
        return false;
    }

    public boolean isFeatureProtected() {
        if (this.adaptedVariable != null) {
            return ((IFeatureValue)this.adaptedVariable).getFeature().getVisibility() == VisibilityKind.PROTECTED_LITERAL;
        }
        return false;
    }

    public boolean isFeaturePrivate() {
        if (this.adaptedVariable != null) {
            return ((IFeatureValue)this.adaptedVariable).getFeature().getVisibility() == VisibilityKind.PRIVATE_LITERAL;
        }
        return false;
    }

    protected List<org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue> getValues() {
        ArrayList resultValues = null;
        Association association = null;
        StructuralFeature feature = ((IFeatureValue)this.adaptedVariable).getFeature();
        if (this.featureValueOwner instanceof IExtensionalValue && feature instanceof Property) {
            association = ((Property)feature).getAssociation();
        }
        if (association != null) {
            List<ILink> links = this.getMatchingLinks(association, ((IFeatureValue)this.adaptedVariable).getFeature(), (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)this.featureValueOwner, ((IExtensionalValue)this.featureValueOwner).getLocus());
            resultValues = new ArrayList();
            int i = 0;
            while (i < links.size()) {
                resultValues.addAll(links.get(i).getFeatureValue(((IFeatureValue)this.adaptedVariable).getFeature()).getValues());
                ++i;
            }
        } else {
            resultValues = ((IFeatureValue)this.adaptedVariable).getValues();
        }
        return resultValues;
    }

    protected List<ILink> getMatchingLinks(Association association, StructuralFeature end, org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue oppositeValue, ILocus locus) {
        return this.getMatchingLinksForEndValue(association, end, oppositeValue, null, locus);
    }

    private List<ILink> getMatchingLinksForEndValue(Association association, StructuralFeature end, org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue oppositeValue, org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue endValue, ILocus locus) {
        Property oppositeEnd = this.getOppositeEnd(association, end);
        List extent = locus.getExtent((Classifier)association);
        ArrayList<ILink> links = new ArrayList<ILink>();
        int i = 0;
        while (i < extent.size()) {
            IExtensionalValue link = (IExtensionalValue)extent.get(i);
            org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue value = (org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)link.getFeatureValue((StructuralFeature)oppositeEnd).getValues().get(0);
            if (value instanceof IReference) {
                value = ((IReference)value).getReferent();
            }
            if (value.equals(oppositeValue).booleanValue()) {
                boolean matches = true;
                if (endValue != null) {
                    matches = ((org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue)link.getFeatureValue(end).getValues().get(0)).equals(endValue);
                }
                if (matches) {
                    if (!end.isOrdered() | links.size() == 0) {
                        links.add((ILink)link);
                    } else {
                        int n = link.getFeatureValue(end).getPosition();
                        boolean continueSearching = true;
                        int j = 0;
                        while (continueSearching & j < links.size()) {
                            continueSearching = ((ILink)links.get(++j - 1)).getFeatureValue(end).getPosition() < n;
                        }
                        if (continueSearching) {
                            links.add((ILink)link);
                        } else {
                            links.add(j - 1, (ILink)link);
                        }
                    }
                }
            }
            ++i;
        }
        return links;
    }

    private Property getOppositeEnd(Association association, StructuralFeature end) {
        Property oppositeEnd = (Property)association.getMemberEnds().get(0);
        if (oppositeEnd == end) {
            oppositeEnd = (Property)association.getMemberEnds().get(1);
        }
        return oppositeEnd;
    }
}

