/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.engine;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.animation.engine.rendering.IAnimation;
import org.eclipse.papyrus.moka.debug.engine.DebugServiceHelper;
import org.eclipse.papyrus.moka.debug.engine.IMokaThread;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugElement;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.engine.MokaThreadState;
import org.eclipse.papyrus.moka.debug.model.data.mapping.MokaStackFrame;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IObjectActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.utils.helper.semantics.SemanticHelper;
import org.eclipse.uml2.uml.NamedElement;

public class MokaThread
extends MokaDebugElement
implements IMokaThread {
    protected IObject_ object;
    protected ISemanticVisitor suspensionPoint;
    protected ReentrantLock threadLock;
    private Condition resumeCondition;
    protected boolean suspensionRequired;
    protected MokaThreadState status;

    public MokaThread(MokaDebugTarget debugTarget, IObject_ object) {
        super(debugTarget);
        this.object = object;
        this.threadLock = new ReentrantLock(true);
        this.resumeCondition = this.threadLock.newCondition();
        this.suspensionRequired = false;
        this.status = MokaThreadState.RUNNING;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.status.equals((Object)MokaThreadState.SUSPENDED);
    }

    public void resume() throws DebugException {
        this.threadLock.lock();
        try {
            this.setSuspensionFlag(false);
            this.setSuspensionPoint(null);
            this.status = MokaThreadState.RUNNING;
            this.fireChangeEvent(1);
            this.resumeCondition.signal();
            if (!this.debugTarget.hasSuspendedThread()) {
                this.debugTarget.resume();
            }
        }
        finally {
            this.threadLock.unlock();
        }
    }

    public void suspend() throws DebugException {
        this.threadLock.lock();
        try {
            this.setSuspensionFlag(true);
            this.status = MokaThreadState.SUSPENDED;
            this.fireChangeEvent(2);
        }
        finally {
            this.threadLock.unlock();
        }
    }

    @Override
    public void suspend(ISemanticVisitor visitor) {
        block7: {
            this.threadLock.lock();
            try {
                if (!this.suspensionRequired) break block7;
                this.suspensionRequired = false;
                try {
                    IAnimation animationService = DebugServiceHelper.INSTANCE.getAnimationService();
                    NamedElement visitedModelElement = SemanticHelper.getModelElement((ISemanticVisitor)visitor);
                    if (animationService != null) {
                        animationService.renderAs((EObject)visitedModelElement, this.object, AnimationKind.SUSPENDED);
                    }
                    this.resumeCondition.await();
                    if (animationService != null) {
                        animationService.renderAs((EObject)visitedModelElement, this.object, AnimationKind.VISITED);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this.threadLock.unlock();
            }
        }
    }

    public boolean canStepOver() {
        return false;
    }

    public void stepOver() throws DebugException {
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.status.equals((Object)MokaThreadState.STEPPING);
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public void stepInto() throws DebugException {
        this.threadLock.lock();
        try {
            this.status = MokaThreadState.STEPPING;
            this.resumeCondition.signal();
        }
        finally {
            this.threadLock.unlock();
        }
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isTerminated() {
        return this.status.equals((Object)MokaThreadState.TERMINATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        this.status = MokaThreadState.TERMINATED;
        this.fireTerminateEvent();
        IObject_ iObject_ = this.object;
        synchronized (iObject_) {
            IObjectActivation objectActivation = this.object.getObjectActivation();
            if (objectActivation != null) {
                objectActivation.stop();
                objectActivation.setObject(null);
                this.object.setObjectActivation(null);
            }
        }
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        IStackFrame[] stackFrames = new IStackFrame[]{};
        if (this.isSuspended()) {
            stackFrames = new IStackFrame[]{new MokaStackFrame(this.debugTarget, this)};
        }
        return stackFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getStackFrames().length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return null;
    }

    public String getName() throws DebugException {
        return this.object.getIdentifier();
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    @Override
    public void setLogicalThread(IObject_ object) {
        this.object = object;
    }

    @Override
    public IObject_ getLogicalThread() {
        return this.object;
    }

    @Override
    public boolean getSuspensionFlag() {
        return this.suspensionRequired;
    }

    @Override
    public void setSuspensionFlag(boolean mustSuspend) {
        this.suspensionRequired = mustSuspend;
    }

    @Override
    public ISemanticVisitor getSuspensionPoint() {
        return this.suspensionPoint;
    }

    @Override
    public void setSuspensionPoint(ISemanticVisitor visitor) {
        this.suspensionPoint = visitor;
    }

    @Override
    public void registered() {
        this.fireCreationEvent();
    }

    @Override
    public void unregistered() {
        this.fireTerminateEvent();
    }
}

