/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.wizards.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.aas.wizards.ui.NewModelWizardAAS;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.PapyrusProjectCreationPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectWizardAAS
extends NewModelWizardAAS {
    private static final String DOT = ".";
    private static final String SLASH = "/";
    public static final String WIZARD_ID = "org.eclipse.papyrus.aas.wizards.createproject";
    private PapyrusProjectCreationPage myProjectPage;

    public boolean isCreateProjectWizard() {
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        String imagePath = "platform:/plugin/org.eclipse.papyrus.aas.wizards/icons/WizardAAS.gif";
        this.setWindowTitle("New AAS Project");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromImage((Image)NewModelWizardAAS.ImageFromPath(imagePath)));
        this.setMyProjectPage(new PapyrusProjectCreationPage(Messages.NewPapyrusProjectWizard_0));
        this.getMyProjectPage().setDescription(Messages.NewPapyrusProjectWizard_1);
    }

    public void addPages() {
        this.setNewProjectPage((IWizardPage)this.getMyProjectPage());
        this.selectArchitectureContextPage = new SelectArchitectureContextPage();
        super.addPages();
    }

    @Override
    public boolean performFinish() {
        IProject newProjectHandle;
        try {
            newProjectHandle = this.createNewProject();
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(Messages.NewPapyrusProjectWizard_exception_on_opening) + (Object)((Object)e));
            return false;
        }
        if (newProjectHandle == null) {
            return false;
        }
        return super.performFinish();
    }

    protected IProject createNewProject() throws CoreException {
        IProject project = this.getMyProjectPage().getProjectHandle();
        java.net.URI projectLocationURI = null;
        if (!this.getMyProjectPage().useDefaults()) {
            projectLocationURI = this.getMyProjectPage().getLocationURI();
        }
        IProjectDescription projectDescription = null;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        if (!project.exists()) {
            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (projectLocationURI != null) {
                projectDescription.setLocationURI(projectLocationURI);
            }
            project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
        } else {
            project.open((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progressMonitor, 1));
        }
        return project;
    }

    protected URI createNewModelURI(String categoryId) {
        String extension = this.getExtension();
        String folder = "AAS";
        IPath newFilePath = this.getMyProjectPage().getProjectHandle().getFullPath().append(String.valueOf(this.getMyProjectPage().getFileName()) + DOT + extension);
        return URI.createPlatformResourceURI((String)newFilePath.toString(), (boolean)true);
    }

    public PapyrusProjectCreationPage getMyProjectPage() {
        return this.myProjectPage;
    }

    public void setMyProjectPage(PapyrusProjectCreationPage myProjectPage) {
        this.myProjectPage = myProjectPage;
    }

    protected WizardNewProjectCreationPage createNewProjectCreationPage() {
        return this.myProjectPage;
    }
}

