/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.editors;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.papyrus.aas.AASPackage;
import org.eclipse.papyrus.aas.tables.configurations.editors.AASElementTypesEnumerator;
import org.eclipse.papyrus.aas.tables.configurations.editors.CreateKeyTypeCellEditorButtonAction;
import org.eclipse.papyrus.aas.tables.configurations.editors.SelectKeyTypeCellEditorButtonAction;
import org.eclipse.papyrus.aas.tables.configurations.manager.provider.KeyTypeEnumComboBoxDataProvider;
import org.eclipse.papyrus.infra.nattable.celleditor.ActionComboBoxCellEditor;
import org.eclipse.papyrus.infra.nattable.celleditor.action.CompositeCellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.celleditor.action.ICellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.config.SingleUMLReferenceCellEditorConfiguration;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class KeyTypeCellEditorConfiguration
extends SingleUMLReferenceCellEditorConfiguration {
    public static final String ID = "org.eclipse.papyrus.aas.tables.configurations.KeyTypeCellEditorConfiguration";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "Cell editor for Key Type modification";
    }

    public boolean handles(Table table, Object axisElement) {
        Property prop;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        Boolean res = false;
        String id = object.toString();
        if (id.startsWith("property_of_stereotype:/") && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)table.getContext(), (String)id)) != null && prop.getOwner() != null && prop.getOwner() instanceof Stereotype) {
            Stereotype current = (Stereotype)prop.getOwner();
            EClass stereotypeDef = (EClass)current.getProfile().getDefinition((NamedElement)current);
            EStructuralFeature feature = stereotypeDef.getEStructuralFeature(prop.getName());
            res = feature == AASPackage.eINSTANCE.getKey_Type();
        }
        return res;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        super.configureCellEditor(configRegistry, axis, configLabel);
        Object axisElement = AxisUtils.getRepresentedElement((Object)axis);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        int selectedAxisIndex = AxisUtils.getUniqueSelectedAxisIndex((INattableModelManager)modelManager);
        AbstractAxisProvider axisProvider = modelManager.getTable().getCurrentColumnAxisProvider();
        EObject context = modelManager.getTable().getContext();
        modelManager.getColumnElement(selectedAxisIndex);
        KeyTypeEnumComboBoxDataProvider dataProvider = new KeyTypeEnumComboBoxDataProvider(AASPackage.eINSTANCE.getKeyElements());
        ArrayList<IElementType> creatableElementType = new ArrayList<IElementType>();
        creatableElementType.add((IElementType)AASElementTypesEnumerator.CONCEPTDESCRIPTION);
        ActionComboBoxCellEditor comboBoxCellEditor = new ActionComboBoxCellEditor((IComboBoxDataProvider)dataProvider);
        CompositeCellEditorButtonAction actions = new CompositeCellEditorButtonAction();
        comboBoxCellEditor.setCellEditorButtonAction((ICellEditorButtonAction)actions);
        CreateKeyTypeCellEditorButtonAction createNewElement = new CreateKeyTypeCellEditorButtonAction(creatableElementType, false, context);
        createNewElement.setTooltipText("Create a new reference");
        actions.addAction((ICellEditorButtonAction)createNewElement);
        SelectKeyTypeCellEditorButtonAction selectexistingElement = new SelectKeyTypeCellEditorButtonAction(creatableElementType, false, context);
        selectexistingElement.setTooltipText("Select an existing reference");
        actions.addAction((ICellEditorButtonAction)selectexistingElement);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", configLabel);
    }
}

