/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements;

import java.util.List;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.Property;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PropertyGenerator.class);
    private Property propInstance;
    private List<Key> semanticKeys;
    private String parent;
    private ConceptDescription conceptDesc;

    public PropertyGenerator(Property propInstance) {
        this.propInstance = propInstance;
        try {
            this.semanticKeys = propInstance.getSemanticIdentifier().getKeys();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception in Semantic ID Declaration while initialising " + this.getClass().getSimpleName());
        }
        try {
            this.conceptDesc = this.propInstance.getSemanticDescription();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception while fetching ConceptDescription for the semantic Id definition of the Property: " + this.getClass().getSimpleName());
        }
        if (propInstance.getParentSEC() != null) {
            this.parent = propInstance.getParentSEC().getIdShort();
        } else if (propInstance.getParentSub() != null) {
            this.parent = propInstance.getParentSub().getIdShort();
        } else {
            logger.error("Property: " + propInstance.getIdShort() + "has no Parent defined");
        }
        logger.info("PropertyGenerator Initialised for Property : " + propInstance.getIdShort());
    }

    public String generateProperty() {
        String propText = "\t\tProperty " + this.parent + "_" + this.propInstance.getIdShort() + "= new Property();\r\n" + "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setIdShort(\"" + this.propInstance.getIdShort() + "\");\r\n" + "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setValueType(ValueType." + this.propInstance.getValueType() + ");\r\n" + this.generateSemanticReference() + this.generateModelingInfo() + this.generateParentalRelation() + this.generateValueDelegates() + "\r\n\r\n";
        logger.info("Property Code generated for Property: " + this.propInstance.getIdShort());
        return propText;
    }

    private String generateModelingInfo() {
        String setModelingKind = "";
        if (this.propInstance.getKind() != null) {
            setModelingKind = "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setModelingKind(ModelingKind." + this.propInstance.getKind() + ");\r\n";
            logger.info("Generated ModelingKind Info for Property: " + this.propInstance.getIdShort());
        } else {
            logger.info("Generated ModelingKind Info for Property: " + this.propInstance.getIdShort() + " not generated.");
        }
        return setModelingKind;
    }

    private String generateParentalRelation() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isSubModelProperty = true;
        if (stackTraceElements[3].getMethodName() == "generateSubModelElementCollection") {
            isSubModelProperty = false;
        }
        String addProperty = "";
        if (isSubModelProperty) {
            addProperty = "\t\taddSubmodelElement(" + this.parent + "_" + this.propInstance.getIdShort() + ");\r\n";
            logger.info("Property " + this.propInstance.getIdShort() + " added to Submodel: ");
        } else {
            SubModelElementCollection parentSEC = this.propInstance.getParentSEC();
            String immediateParent = "";
            if (parentSEC.getParentSEC() != null) {
                immediateParent = parentSEC.getParentSEC().getIdShort();
            } else if (parentSEC.getParentSub() != null) {
                immediateParent = parentSEC.getParentSub().getIdShort();
            } else {
                logger.error("Property: " + parentSEC.getIdShort() + "has no Parent defined");
            }
            addProperty = "\t\t" + immediateParent + "_" + parentSEC.getIdShort() + "value.add(" + this.parent + "_" + this.propInstance.getIdShort() + ");\r\n\r\n";
            logger.info("Property " + this.propInstance.getIdShort() + " added to SubmodelElementCollection: " + this.propInstance.getParentSEC().getIdShort());
        }
        return addProperty;
    }

    private String generateValueCode() {
        String setValue = "";
        if (this.propInstance.getValue() != null) {
            setValue = "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setValue(\"" + this.propInstance.getValue() + "\");\r\n";
            logger.info("Generated Value Info for Property: " + this.propInstance.getIdShort());
        } else {
            logger.info("Value Info for Property: " + this.propInstance.getIdShort() + " not generated.");
        }
        return setValue;
    }

    private String generateSemanticReference() {
        String semanticStr = "";
        if (this.semanticKeys != null && this.conceptDesc == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tList<IKey> " + this.parent + "_" + this.propInstance.getIdShort().toLowerCase() + "Keys= new ArrayList<IKey>();\r\n";
            for (Key key : this.semanticKeys) {
                String basyxKeyElement = FileUtils.removeUnderScore(key.getType().toString());
                semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.propInstance.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + basyxKeyElement + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
            }
            semanticStr = String.valueOf(semanticStr) + "\t\tReference " + this.parent + "_" + this.propInstance.getIdShort() + "Ref = new Reference(" + this.parent + "_" + this.propInstance.getIdShort().toLowerCase() + "Keys" + ");\r\n" + "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setSemanticId(" + this.parent + "_" + this.propInstance.getIdShort() + "Ref); \r\n \r\n";
            logger.info("Semantic Id reference for Property: " + this.propInstance.getIdShort() + "generated.");
        } else if (this.conceptDesc != null && this.semanticKeys == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setSemanticId(conceptDescriptions." + this.conceptDesc.getIdShort() + ".getReference()); \r\n \r\n";
        } else {
            logger.debug("No Semantic Id reference for Property: " + this.propInstance.getIdShort() + "found. Thus, not generated.");
        }
        return semanticStr;
    }

    private String generateValueDelegates() {
        String valueDelegate = "";
        String valueCode = "";
        String getterCode = "";
        String setterCode = "";
        if (this.propInstance.isDynamic()) {
            valueDelegate = String.valueOf(valueDelegate) + "\t\tValueDelegate<" + this.convertBaSyxToJavaTypes(this.propInstance.getValueType()) + "> valDel" + this.parent + "_" + this.propInstance.getIdShort() + " = ValueDelegate.installOn(" + this.parent + "_" + this.propInstance.getIdShort() + "); \r\n";
            getterCode = String.valueOf(getterCode) + "\t\tvalDel" + this.parent + "_" + this.propInstance.getIdShort() + ".setGetHandler(dew::get_" + this.parent + "_" + this.propInstance.getIdShort() + "); \r\n";
            setterCode = String.valueOf(setterCode);
            valueDelegate = String.valueOf(valueDelegate) + getterCode + setterCode;
            return valueDelegate;
        }
        valueCode = String.valueOf(valueCode) + "\t\t" + this.parent + "_" + this.propInstance.getIdShort() + ".setValue(\"" + this.propInstance.getValue() + "\");\r\n";
        return valueCode;
    }

    private String convertBaSyxToJavaTypes(String valueType) {
        switch (valueType) {
            case "Int8": {
                return "Byte";
            }
            case "Int16": 
            case "UInt8": {
                return "Short";
            }
            case "UInt16": 
            case "Integer": 
            case "Int32": {
                return "Integer";
            }
            case "NonPositiveInteger": 
            case "NonNegativeInteger": 
            case "PositiveInteger": 
            case "NegativeInteger": {
                return "BigInteger";
            }
            case "UInt32": 
            case "Int64": {
                return "Long";
            }
            case "UInt64": {
                return "BigInteger";
            }
            case "Double": {
                return "Double";
            }
            case "Float": {
                return "Float";
            }
            case "Boolean": {
                return "Boolean";
            }
            case "String": {
                return "String";
            }
            case "Duration": 
            case "DayTimeDuration": {
                return "Duration";
            }
            case "YearMonthDuration": {
                return "Duration";
            }
            case "QName": {
                return "QName";
            }
            case "NOTATION": {
                return "QName";
            }
            case "AnyURI": {
                return "String";
            }
            case "LangString": {
                return "LangString";
            }
            case "Base64Binary": 
            case "HexBinary": {
                return "Byte[]";
            }
            case "GDay": 
            case "GYear": 
            case "GMonthDay": 
            case "GYearMonth": 
            case "DateTime": 
            case "GMonth": {
                return "XMLGregorianCalendar";
            }
            case "DateTimeStamp": 
            case "ID": 
            case "None": 
            case "IDREF": 
            case "AnyType": 
            case "AnySimpleType": 
            case "ENTITY": {
                return "String";
            }
        }
        return "Object";
    }
}

