/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements;

import io.adminshell.aas.v3.model.LangString;
import java.util.List;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLPGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MLPGenerator.class);
    private MultiLanguageProperty mlpInstance;
    private List<Key> semanticKeys;
    private String parent;
    private ConceptDescription conceptDesc;

    public MLPGenerator(MultiLanguageProperty mlpInstance) {
        this.mlpInstance = mlpInstance;
        try {
            this.semanticKeys = mlpInstance.getSemanticIdentifier().getKeys();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception in Semantic ID Declaration while initialising " + this.getClass().getSimpleName());
        }
        try {
            this.conceptDesc = this.mlpInstance.getSemanticDescription();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception while fetching ConceptDescription for the semantic Id definition of the MultiLanguageProperty: " + this.getClass().getSimpleName());
        }
        if (mlpInstance.getParentSEC() != null) {
            this.parent = mlpInstance.getParentSEC().getIdShort();
        } else if (mlpInstance.getParentSub() != null) {
            this.parent = mlpInstance.getParentSub().getIdShort();
        } else {
            logger.error("MultiLanguageProperty: " + mlpInstance.getIdShort() + "has no Parent defined");
        }
        logger.info("MLPGenerator Initialised for MLP : " + mlpInstance.getIdShort());
    }

    public String generateMultiLanguageProperty() {
        String multiLangPropText = "\t\tMultiLanguageProperty " + this.parent + "_" + this.mlpInstance.getIdShort() + "= new MultiLanguageProperty();\r\n" + "\t\t" + this.parent + "_" + this.mlpInstance.getIdShort() + ".setIdShort(\"" + this.mlpInstance.getIdShort() + "\");\r\n" + this.generateSemanticReference() + "\t\t" + this.parent + "_" + this.mlpInstance.getIdShort() + ".setValue(LangStrings.fromStringPairs(" + this.generateLangStringContent() + "));\r\n" + this.generateModelingInfo() + this.generateParentalRelation() + "\r\n\r\n";
        logger.info("MultiLanguageProperty Code generated for MultiLanguageProperty: " + this.mlpInstance.getIdShort());
        return multiLangPropText;
    }

    private String generateModelingInfo() {
        String setModelingKind = "";
        if (this.mlpInstance.getKind() != null) {
            setModelingKind = "\t\t" + this.parent + "_" + this.mlpInstance.getIdShort() + ".setModelingKind(ModelingKind." + this.mlpInstance.getKind() + ");\r\n";
            logger.info("Generated ModelingKind Info for Operation: " + this.mlpInstance.getIdShort());
        } else {
            logger.info("Generated ModelingKind Info for Operation: " + this.mlpInstance.getIdShort() + " not generated.");
        }
        return setModelingKind;
    }

    private String generateLangStringContent() {
        List langStringValues = this.mlpInstance.getValues();
        String langStringContent = "";
        for (LangString langStringValue : langStringValues) {
            langStringContent = String.valueOf(langStringContent) + "\"" + langStringValue.getLanguage() + "\", \"" + langStringValue.getValue() + "\", ";
        }
        if (langStringContent != null && langStringContent.length() > 1) {
            langStringContent = langStringContent.substring(0, langStringContent.length() - 2);
        }
        if (!langStringContent.isEmpty()) {
            logger.info("LangString Content for " + this.mlpInstance.getIdShort() + " generated");
        } else {
            logger.debug("LangString Content for " + this.mlpInstance.getIdShort() + " not generated");
        }
        return langStringContent;
    }

    private String generateParentalRelation() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isSubModelMultiLangProperty = true;
        if (stackTraceElements[3].getMethodName() == "generateSubModelElementCollection") {
            isSubModelMultiLangProperty = false;
        }
        String addMultiLangProperty = "";
        if (isSubModelMultiLangProperty) {
            addMultiLangProperty = "\t\taddSubmodelElement(" + this.parent + "_" + this.mlpInstance.getIdShort() + ");\r\n";
            logger.info("MultiLanguageProperty " + this.mlpInstance.getIdShort() + " added to Submodel: " + this.mlpInstance.getParentSub().getIdShort());
        } else {
            SubModelElementCollection parentSEC = this.mlpInstance.getParentSEC();
            String immediateParent = "";
            if (parentSEC.getParentSEC() != null) {
                immediateParent = parentSEC.getParentSEC().getIdShort();
            } else if (parentSEC.getParentSub() != null) {
                immediateParent = parentSEC.getParentSub().getIdShort();
            } else {
                logger.error("Property: " + parentSEC.getIdShort() + "has no Parent defined");
            }
            addMultiLangProperty = "\t\t" + immediateParent + "_" + parentSEC.getIdShort() + "value.add(" + this.parent + "_" + this.mlpInstance.getIdShort() + ");\r\n\r\n";
            logger.info("MultiLanguageProperty " + this.mlpInstance.getIdShort() + " added to SubmodelElementCollection: " + this.mlpInstance.getParentSEC().getIdShort());
        }
        return addMultiLangProperty;
    }

    private String generateSemanticReference() {
        String semanticStr = "";
        if (this.semanticKeys != null && this.conceptDesc == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tList<IKey> " + this.parent + "_" + this.mlpInstance.getIdShort().toLowerCase() + "Keys= new ArrayList<IKey>();\r\n";
            for (Key key : this.semanticKeys) {
                String basyxKeyElement = FileUtils.removeUnderScore(key.getType().toString());
                semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.mlpInstance.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + basyxKeyElement + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
            }
            semanticStr = String.valueOf(semanticStr) + "\t\tReference " + this.parent + "_" + this.mlpInstance.getIdShort() + "Ref = new Reference(" + this.parent + "_" + this.mlpInstance.getIdShort().toLowerCase() + "Keys" + ");\r\n" + "\t\t" + this.parent + "_" + this.mlpInstance.getIdShort() + ".setSemanticId(" + this.parent + "_" + this.mlpInstance.getIdShort() + "Ref); \r\n \r\n";
            logger.info("Semantic Id reference for Submodel: " + this.mlpInstance.getIdShort() + "generated.");
        } else if (this.conceptDesc != null && this.semanticKeys == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.mlpInstance.getIdShort() + ".setSemanticId(conceptDescriptions." + this.conceptDesc.getIdShort() + ".getReference()); \r\n \r\n";
        } else {
            logger.debug("No Semantic Id reference for Submodel: " + this.mlpInstance.getIdShort() + "found. Thus, not generated.");
        }
        return semanticStr;
    }
}

