/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static void clearFile(String fileName) {
        try {
            PrintWriter writer = new PrintWriter(fileName);
            writer.close();
            logger.debug("Successfully cleared contents in " + fileName);
        }
        catch (FileNotFoundException e) {
            logger.error("File " + fileName + "not found!");
            e.printStackTrace();
        }
    }

    public static String readFile(String fileName) {
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fis.read(data);
            fis.close();
            logger.debug("Successfully read contents of file: " + fileName);
            return new String(data, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while reading file content.");
            return "File Error!";
        }
    }

    public static boolean removeLine(String fileName, String lineToRemove) {
        boolean success = false;
        try {
            String delete;
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            String task = "";
            while ((delete = file.readLine()) != null) {
                if (delete.startsWith(lineToRemove)) {
                    success = true;
                    continue;
                }
                task = String.valueOf(task) + delete + "\n";
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(task);
            file.close();
            writer.close();
            logger.debug("Successfully Line removed!");
        }
        catch (Exception e) {
            logger.error("Error during line removal!");
            e.printStackTrace();
        }
        return success;
    }

    public static void writeData(String fileName, String data) {
        try {
            FileUtils.clearFile(fileName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName, StandardCharsets.UTF_8, true));
            writer.write(data);
            writer.newLine();
            writer.close();
            logger.debug("Successfully written into file: " + fileName);
        }
        catch (IOException iOException) {
            logger.error("Error while opening the file!");
        }
    }

    public static boolean createDirectories(String fullPath) {
        File directory = new File(fullPath);
        logger.debug("Creating folder: " + directory.getAbsolutePath());
        if (!directory.exists()) {
            directory.mkdirs();
            logger.debug(String.valueOf(directory.getAbsolutePath()) + " successfully created.");
            return true;
        }
        logger.error(String.valueOf(directory.getAbsolutePath()) + " not successfully created.");
        return false;
    }

    public static String getCurrentWorkingDirectory() {
        File directory = new File("");
        return directory.getAbsolutePath();
    }

    public static String getFullPathFromNamespace(String namespace) {
        return namespace.replace(".", "/");
    }

    public static String removeUnderScore(String input) {
        String refinedInput = "";
        refinedInput = input.replaceAll("_", "").toUpperCase();
        return refinedInput;
    }
}

