/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.policies;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.parametric.commands.CustomBindingConnectorReorientCommand;
import org.eclipse.papyrus.sysml.diagram.parametric.commands.CustomParametricContextLinkCreateCommand;
import org.eclipse.papyrus.sysml.diagram.parametric.commands.ReorientReferenceRelationshipRequestWithGraphical;
import org.eclipse.papyrus.sysml.diagram.parametric.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.parametric.provider.ElementTypes;
import org.eclipse.papyrus.sysml.diagram.parametric.provider.GraphicalTypeRegistry;
import org.eclipse.papyrus.uml.service.types.command.CommentAnnotatedElementsCreateCommand;
import org.eclipse.papyrus.uml.service.types.command.CommentAnnotatedElementsReorientCommand;
import org.eclipse.papyrus.uml.service.types.command.ConnectorReorientCommand;

public class CustomDefaultSemanticEditPolicy
extends DefaultSemanticEditPolicy {
    private IGraphicalTypeRegistry registry = new CustomGraphicalTypeRegistry();
    private IGraphicalTypeRegistry inheritedRegistry = new GraphicalTypeRegistry();

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (ElementTypes.COMMENT_ANNOTATED_ELEMENT == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementsCreateCommand(req));
        }
        if (ElementTypes.CONTEXT_LINK == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CustomParametricContextLinkCreateCommand(req));
        }
        String newEdgeGraphicalType = this.registry.getEdgeGraphicalType(req.getElementType());
        if (this.inheritedRegistry.isKnownEdgeType(newEdgeGraphicalType)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!this.registry.isKnownEdgeType(newEdgeGraphicalType)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCreateRelationshipCommand(req);
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        String reconnectedViewType;
        View reconnectedView = (View)req.getParameter("graphical_edge");
        String string = reconnectedViewType = reconnectedView != null ? reconnectedView.getType() : "undefined_type";
        if (ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint().equals(reconnectedViewType)) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementsReorientCommand(req));
        }
        if ("link_uml_connector".equals(reconnectedViewType)) {
            if (req instanceof ReorientReferenceRelationshipRequestWithGraphical) {
                return this.getGEFWrapper((ICommand)new CustomBindingConnectorReorientCommand((ReorientReferenceRelationshipRequestWithGraphical)req));
            }
            return this.getGEFWrapper((ICommand)new ConnectorReorientCommand(req));
        }
        return super.getReorientReferenceRelationshipCommand(req);
    }
}

