/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.utils;

import java.util.Collection;
import org.eclipse.papyrus.sysml.diagram.common.utils.SysMLMultiplicityElementUtil;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ValueSpecification;

public class ParameterLabelUtil {
    protected static final String DIRECTION_FORMAT = "%s %s";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MULTIPLICITY_FORMAT = "%s [%s..%s]";
    protected static final String DEFAULT_VALUE_FORMAT = "%s= %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    public static String getPrintString(Parameter parameter, Collection<String> displayValue) {
        if (displayValue.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        if (parameter != null) {
            String multiplicity;
            if (displayValue.contains("direction") || displayValue.contains("parametersDirection")) {
                String direction;
                switch (parameter.getDirection().getValue()) {
                    case 0: {
                        direction = "in";
                        break;
                    }
                    case 2: {
                        direction = "out";
                        break;
                    }
                    case 1: {
                        direction = "inout";
                        break;
                    }
                    case 3: {
                        direction = "return";
                        break;
                    }
                    default: {
                        direction = "in";
                    }
                }
                result = String.format(DIRECTION_FORMAT, direction, result);
            }
            if ((displayValue.contains("name") || displayValue.contains("parametersName")) && parameter.isSetName()) {
                String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)parameter);
                result = String.format(NAME_FORMAT, result, name);
            }
            if (displayValue.contains("type") || displayValue.contains("parametersType")) {
                String type = "<Undefined>";
                if (parameter.getType() != null) {
                    type = UMLLabelInternationalization.getInstance().getLabel((NamedElement)parameter.getType());
                }
                if (displayValue.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
            if ((multiplicity = SysMLMultiplicityElementUtil.formatMultiplicity((MultiplicityElement)parameter, displayValue)) != null && !multiplicity.isEmpty()) {
                result = String.valueOf(result) + " " + multiplicity;
            }
            if ((displayValue.contains("parametersDefault") || displayValue.contains("defaultValue")) && parameter.getDefaultValue() != null) {
                ValueSpecification valueSpecification = parameter.getDefaultValue();
                result = String.format(DEFAULT_VALUE_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification, (boolean)true));
            }
            if (displayValue.contains("parametersModifiers") || displayValue.contains("modifiers")) {
                StringBuffer sb = new StringBuffer();
                if (parameter.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (parameter.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (parameter.isStream()) {
                    sb.append(sb.length() == 0 ? "stream" : ", stream");
                }
                if (parameter.isException()) {
                    sb.append(sb.length() == 0 ? "exception" : ", exception");
                }
                if (sb.length() != 0) {
                    result = String.format(MODIFIER_FORMAT, result, sb.toString());
                }
            }
        }
        return result;
    }
}

