/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.strategy.paste;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PartPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new PartPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "partPasteStrategy";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.common.partPasteStrategy";
    }

    public String getDescription() {
        return "Paste part elements with association";
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.strategy.paste";
    }

    public String getCategoryLabel() {
        return "Paste all copied elements";
    }

    @Deprecated
    public Image getImage() {
        return null;
    }

    @Deprecated
    public int getPriority() {
        return 1;
    }

    public void setOptions(Map<String, Object> options) {
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        Map additionalDataMap;
        if ((targetOwner instanceof Classifier || targetOwner instanceof Package) && (additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID())) != null) {
            org.eclipse.emf.common.command.CompoundCommand compoundCommand = new org.eclipse.emf.common.command.CompoundCommand("Copy associations for parts");
            for (Object object : papyrusClipboard) {
                ICommand editCommand;
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                Object additionnalData = additionalDataMap.get(object);
                BasicEList listDuplicatedAssociation = new BasicEList();
                EObject associationContainer = null;
                if (target != null && target instanceof Property && targetOwner instanceof Classifier && additionnalData instanceof PartAdditionalData) {
                    Classifier block = (Classifier)targetOwner;
                    Property property = (Property)target;
                    PartAdditionalData partAdditionalData = (PartAdditionalData)additionnalData;
                    Association newAssociation = partAdditionalData.getDuplicatedAssociation();
                    this.restoreAssociationPartContext(block, property, newAssociation);
                    listDuplicatedAssociation.add((Object)newAssociation);
                    associationContainer = block.eContainer();
                } else if (target != null && target instanceof Classifier && targetOwner instanceof Package && additionnalData instanceof PartBlockAdditionalData) {
                    Classifier classifier = (Classifier)target;
                    EList allAttributes = classifier.getAllAttributes();
                    PartBlockAdditionalData partBlockAdditionalData = (PartBlockAdditionalData)additionnalData;
                    for (Property property : allAttributes) {
                        Association duplicatedAssociation = partBlockAdditionalData.getDuplicatedAssociationByPropertyName(property.getName());
                        if (duplicatedAssociation == null) continue;
                        this.restoreAssociationPartContext(classifier, property, duplicatedAssociation);
                        listDuplicatedAssociation.add((Object)duplicatedAssociation);
                    }
                    associationContainer = targetOwner;
                }
                if (associationContainer == null || listDuplicatedAssociation.isEmpty()) continue;
                MoveRequest moveRequest = new MoveRequest(associationContainer, (List)listDuplicatedAssociation);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetOwner);
                if (provider == null || (editCommand = provider.getEditCommand((IEditCommandRequest)moveRequest)) == null) continue;
                GMFtoEMFCommandWrapper gmFtoEMFCommandWrapper = new GMFtoEMFCommandWrapper(editCommand);
                compoundCommand.append((Command)gmFtoEMFCommandWrapper);
            }
            if (compoundCommand.getCommandList().isEmpty()) {
                return null;
            }
            return compoundCommand;
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getGraphicalCommand(EditingDomain domain, GraphicalEditPart targetEditPart, PapyrusClipboard<Object> papyrusClipboard) {
        View targetView = (View)targetEditPart.getModel();
        EObject targetOwner = targetView.getElement();
        Command semanticCommand = this.getSemanticCommand(domain, targetOwner, papyrusClipboard);
        if (semanticCommand != null) {
            CompoundCommand compoundCommand = new CompoundCommand("Association Part Semantic And Graphical paste");
            EMFtoGEFCommandWrapper emFtoGEFCommandWrapper = new EMFtoGEFCommandWrapper(semanticCommand);
            compoundCommand.add((org.eclipse.gef.commands.Command)emFtoGEFCommandWrapper);
            return compoundCommand;
        }
        return null;
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, PartBlockAdditionalData> mapCopyPartData = new HashMap<Object, PartBlockAdditionalData>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            EObject eObjectSource = (EObject)iterator.next();
            if (!(eObjectSource instanceof Element)) continue;
            Element elementSource = (Element)eObjectSource;
            Object clipboardAdditionalData = null;
            if (elementSource instanceof Property && UMLUtil.getStereotypeApplication((Element)elementSource.getOwner(), Block.class) != null) {
                Property propertySource = (Property)elementSource;
                Association association = propertySource.getAssociation();
                if (association != null) {
                    clipboardAdditionalData = new PartAdditionalData(association);
                }
            } else if (elementSource instanceof Classifier && UMLUtil.getStereotypeApplication((Element)elementSource, Block.class) != null) {
                Classifier block = (Classifier)elementSource;
                clipboardAdditionalData = new PartBlockAdditionalData(block);
            }
            if (clipboardAdditionalData == null) continue;
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyPartData.put(copy, (PartBlockAdditionalData)clipboardAdditionalData);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyPartData);
    }

    protected Association duplicateAssociation(Association association) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        copier.copy((EObject)association);
        EObject eObject = (EObject)copier.get((Object)association);
        return (Association)eObject;
    }

    protected void restoreAssociationPartContext(Classifier classifier, Property property, Association association) {
        EList memberEnds = association.getMemberEnds();
        if (memberEnds != null && !memberEnds.isEmpty()) {
            Property blockProperty = (Property)memberEnds.get(0);
            blockProperty.setType((Type)classifier);
        }
        memberEnds.add((Object)property);
    }

    protected class PartAdditionalData
    implements IClipboardAdditionalData {
        protected Association asssociation;

        public PartAdditionalData(Association asssociation) {
            this.asssociation = PartPasteStrategy.this.duplicateAssociation(asssociation);
        }

        public Association getDuplicatedAssociation() {
            return PartPasteStrategy.this.duplicateAssociation(this.asssociation);
        }
    }

    protected class PartBlockAdditionalData
    implements IClipboardAdditionalData {
        protected Map<String, Association> mapPropertyNameToAssociation = new HashMap<String, Association>();

        public PartBlockAdditionalData(Classifier block) {
            EList allAttributes = block.getAllAttributes();
            for (Property property : allAttributes) {
                Association association = property.getAssociation();
                Association newAssociation = PartPasteStrategy.this.duplicateAssociation(association);
                this.mapPropertyNameToAssociation.put(property.getName(), newAssociation);
            }
        }

        public Association getDuplicatedAssociationByPropertyName(String propertyName) {
            Association association = this.mapPropertyNameToAssociation.get(propertyName);
            return PartPasteStrategy.this.duplicateAssociation(association);
        }
    }
}

