/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.sysml.diagram.common.utils.SysMLMultiplicityElementUtil;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.papyrus.sysml.portandflows.FlowSpecification;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FlowPortLabelParser
extends PropertyLabelParser {
    protected static final String DIRECTION_FORMAT = "%s %s";
    protected static final String CONJUGATED_FORMAT = "~%s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Port) {
            ValueSpecification valueSpecification;
            String multiplicity;
            Property property = (Property)eObject;
            FlowPort flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)property, FlowPort.class);
            if (flowPort != null && maskValues.contains("direction")) {
                String direction;
                switch (flowPort.getDirection().getValue()) {
                    case 0: {
                        direction = "in";
                        break;
                    }
                    case 1: {
                        direction = "out";
                        break;
                    }
                    case 2: {
                        direction = "inout";
                        break;
                    }
                    default: {
                        direction = "inout";
                    }
                }
                if (property.getType() == null || property.getType() != null && UMLUtil.getStereotypeApplication((Element)property.getType(), FlowSpecification.class) == null) {
                    result = String.format(DIRECTION_FORMAT, direction, result);
                }
            }
            if (maskValues.contains("visibility")) {
                String visibility;
                switch (property.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format(DIRECTION_FORMAT, visibility, result);
            }
            if (maskValues.contains("derived") && property.isDerived()) {
                result = String.format("%s/", result);
            }
            if (maskValues.contains("name") && property.isSetName()) {
                String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
                result = String.format("%s%s", result, name);
            }
            if (maskValues.contains("type")) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property.getType());
                }
                if (maskValues.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    if (flowPort != null && flowPort.isConjugated()) {
                        type = String.format(CONJUGATED_FORMAT, type);
                    }
                    result = String.format("%s: %s", result, type);
                }
            }
            if (maskValues.contains("multiplicity") && (multiplicity = SysMLMultiplicityElementUtil.formatMultiplicity((MultiplicityElement)property, maskValues)) != null && !multiplicity.isEmpty()) {
                result = String.valueOf(result) + " " + multiplicity;
            }
            if (maskValues.contains("defaultValue") && property.getDefaultValue() != null && (valueSpecification = property.getDefaultValue()) instanceof InstanceValue) {
                result = String.format("%s= %s", result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification, (boolean)true));
            }
            if (maskValues.contains("modifiers")) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append(sb.length() == 0 ? UMLLabelInternationalization.getInstance().getLabel((NamedElement)p) : ", redefines " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)p));
                    }
                }
                if (sb.length() != 0) {
                    result = String.format("%s{%s}", result, sb.toString());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return PortandflowsPackage.eINSTANCE.getFlowPort_Direction().equals(feature) || PortandflowsPackage.eINSTANCE.getFlowPort_IsConjugated().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        Port semElement;
        FlowPort flowPort;
        List<EObject> semanticElementsBeingParsed = super.getSemanticElementsBeingParsed(element);
        if (element != null && element instanceof Port && (flowPort = (FlowPort)UMLUtil.getStereotypeApplication((Element)(semElement = (Port)element), FlowPort.class)) != null) {
            semanticElementsBeingParsed.add((EObject)flowPort);
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("direction", "Direction");
        masks.put("visibility", "Visibility");
        masks.put("derived", "Is Derived");
        masks.put("name", "Name");
        masks.put("type", "Type");
        masks.put("undefinedType", "Show <Undefined> type");
        masks.put("multiplicity", "Multiplicity");
        masks.put("defaultMultiplicity", "Show default multiplicity");
        masks.put("defaultValue", "Default Value");
        masks.put("modifiers", "Modifiers");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("direction", "name", "type", "undefinedType");
    }
}

