/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.sysml14.sysml.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.interoperability.sysml14.sysml.Activator;
import org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper.PreserveXMIIDHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.concurrent.ResourceAccessHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformation;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.MigrationResourceSetImpl;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SysMLImportTransformation
extends AbstractImportTransformation {
    private static final String NOTATION_FILE_EXTENSION = "notation";
    protected ModelExtent umlPrimitivesTypes;
    protected ModelExtent sysML14Profile;
    protected ModelExtent blockDefinitionViewpoint;
    protected ModelExtent internalBlockViewpoint;
    protected ModelExtent parametricViewpoint;
    protected ModelExtent requirementViewpoint;
    protected ModelExtent requirementNatTable11;
    protected ModelExtent allocationNatTable11;
    protected ModelExtent requirementNatTable14;
    protected ModelExtent allocationNatTable14;
    protected ModelExtent requirementTableViewpoint;
    protected ModelExtent allocationTableViewpoint;

    public SysMLImportTransformation(URI sourceURI, ThreadConfig config, IDependencyAnalysisHelper analysisHelper) {
        super(sourceURI, config, analysisHelper);
        DEBUG = true;
    }

    public SysMLImportTransformation(URI sourceURI) {
        super(sourceURI);
    }

    protected void initTransformationProperties(ExecutionContextImpl context) {
    }

    protected Diagnostic loadInPapyrusProfiles() {
        this.resourceSet.getResource(this.sourceURI.trimFileExtension().appendFileExtension("uml"), true);
        this.resourceSet.getResource(this.sourceURI.trimFileExtension().appendFileExtension(NOTATION_FILE_EXTENSION), true);
        return null;
    }

    protected int countSupportedElements() {
        return -1;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.subTask("Loading source model " + this.getModelName());
        long startLoad = System.nanoTime();
        this.initResourceSet(monitor);
        int numberOfElements = this.countSupportedElements();
        monitor.beginTask("Importing " + this.getModelName(), numberOfElements);
        monitor.subTask("Loading transformations (This may take a few seconds for the first import)...");
        this.loadTransformations(monitor);
        List<ModelExtent> extents = this.getModelExtents();
        String statusMessage = String.format("Import %s", this.getModelName());
        MultiStatus generationStatus = new MultiStatus("org.eclipse.papyrus.interoperability.sysml14.sysml", 0, statusMessage, null);
        this.context = this.createExecutionContext(monitor, generationStatus);
        this.getInPapyrusProfiles();
        long endLoad = System.nanoTime();
        this.loadingTime = endLoad - startLoad;
        this.prepareExtensions();
        long startExtensions = System.nanoTime();
        IStatus result = this.importExtensions(this.context, monitor, AbstractImportTransformation.ExtensionFunction::executeBefore);
        long endExtensions = System.nanoTime();
        this.importExtensionsTime = endExtensions - startExtensions;
        generationStatus.add(result);
        HashMap<EObject, String> oldUMLIds = new HashMap<EObject, String>();
        Resource oldUMLResource = this.resourceSet.getResource(this.sourceURI.trimFileExtension().appendFileExtension("uml"), true);
        TreeIterator UMLContents = oldUMLResource.getAllContents();
        while (UMLContents.hasNext()) {
            EObject eObject = (EObject)UMLContents.next();
            oldUMLIds.put(eObject, ((XMIResource)oldUMLResource).getID(eObject));
        }
        monitor.subTask("Importing semantic model...");
        URI semanticTransformationURI = this.getSemanticTransformationURI();
        if (semanticTransformationURI != null) {
            result = this.runTransformation(semanticTransformationURI, extents, monitor);
            generationStatus.add(result);
        }
        if (generationStatus.getSeverity() <= 2) {
            this.targetURI = this.convertToPapyrus(this.sourceURI, "uml");
            this.umlResource = this.createUMLResource((ResourceSet)this.resourceSet, this.sourceURI, this.targetURI);
            this.configureResource((XMIResource)this.umlResource);
            List outUMLObjects = this.getInOutUMLModel().getContents();
            this.umlResource.getContents().addAll((Collection)outUMLObjects);
            new PreserveXMIIDHelper(new Context(this.context)).keepIdForUMLResource((XMIResource)this.umlResource, oldUMLIds);
            oldUMLIds.clear();
            HashMap<EObject, String> oldNotationIds = new HashMap<EObject, String>();
            Resource oldNotationResource = this.resourceSet.getResource(this.sourceURI.trimFileExtension().appendFileExtension(NOTATION_FILE_EXTENSION), true);
            TreeIterator notationContents = oldNotationResource.getAllContents();
            while (notationContents.hasNext()) {
                EObject eObject = (EObject)notationContents.next();
                oldNotationIds.put(eObject, ((XMIResource)oldNotationResource).getID(eObject));
            }
            extents = this.getDiagramsModelExtents();
            Collection<URI> transformations = this.getDiagramTransformationURIs();
            monitor.subTask("Importing diagrams and tables...");
            for (URI transformationURI : transformations) {
                result = this.runTransformation(transformationURI, extents, monitor);
                generationStatus.add(result);
            }
            if (generationStatus.getSeverity() <= 2) {
                URI notationModelURI = this.convertToPapyrus(this.sourceURI, NOTATION_FILE_EXTENSION);
                GMFResource notationResource = new GMFResource(notationModelURI);
                this.resourceSet.getResources().add((Object)notationResource);
                List outNotationObjects = this.getInoutNotationModel().getContents();
                notationResource.getContents().addAll((Collection)outNotationObjects);
                this.configureResource((XMIResource)notationResource);
                new PreserveXMIIDHelper(new Context(this.context)).keepIdForNotationResource((XMIResource)notationResource, oldNotationIds);
                oldNotationIds.clear();
                monitor.subTask("Cleaning-up target model...");
                URI sashModelURI = this.convertToPapyrus(this.sourceURI, "di");
                XMIResourceImpl sashResource = new XMIResourceImpl(sashModelURI);
                this.configureResource((XMIResource)sashResource);
                this.uriMappings.put(this.sourceURI, this.targetURI);
                monitor.subTask("Handling fragments...");
                Collection resourcesToSave = this.handleFragments(this.umlResource, (Resource)notationResource, (Resource)sashResource);
                monitor.subTask("Analyzing dangling references...");
                long startDangling = System.nanoTime();
                this.handleDanglingURIs(resourcesToSave);
                long endDangling = System.nanoTime();
                this.danglingRefTime = endDangling - startDangling;
                monitor.subTask("Saving models...");
                for (Resource resource : resourcesToSave) {
                    try {
                        this.cleanMetadataAnnotations(resource);
                        ResourceAccessHelper.INSTANCE.saveResource(resource, null);
                    }
                    catch (Exception ex) {
                        Activator.log.error((Throwable)ex);
                        generationStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.interoperability.sysml14.sysml", "An exception occurred during save", (Throwable)ex));
                    }
                }
            }
        }
        long startExtensionsAfter = System.nanoTime();
        result = this.importExtensions(this.context, monitor, AbstractImportTransformation.ExtensionFunction::executeAfter);
        long endExtensionsAfter = System.nanoTime();
        this.importExtensionsTime += endExtensionsAfter - startExtensionsAfter;
        this.context = null;
        monitor.subTask("Releasing memory...");
        this.unloadResourceSet((ResourceSet)this.resourceSet);
        this.dispose();
        monitor.done();
        return generationStatus;
    }

    protected Collection<URI> getDiagramTransformationURIs() {
        return ListHelper.asList((Object[])new URI[]{this.getTransformationURI("SysMLNotation", "org.eclipse.papyrus.interoperability.sysml14.sysml")});
    }

    protected URI getSemanticTransformationURI() {
        return this.getTransformationURI("SysMLSemantic", "org.eclipse.papyrus.interoperability.sysml14.sysml");
    }

    protected Collection<URI> getProfilesTransformationURI() {
        return Collections.emptyList();
    }

    protected Collection<URI> getAllTransformationURIs() {
        Collection additionalTransformationURIs;
        Collection<URI> profilesTransformationURI;
        Collection<URI> diagramTransformationURI;
        ArrayList<URI> allTransformations = new ArrayList<URI>();
        URI semanticTransformationURI = this.getSemanticTransformationURI();
        if (semanticTransformationURI != null) {
            allTransformations.add(semanticTransformationURI);
        }
        if ((diagramTransformationURI = this.getDiagramTransformationURIs()) != null) {
            allTransformations.addAll(diagramTransformationURI);
        }
        if ((profilesTransformationURI = this.getProfilesTransformationURI()) != null) {
            allTransformations.addAll(profilesTransformationURI);
        }
        if ((additionalTransformationURIs = this.getAdditionalTransformationURIs()) != null) {
            allTransformations.addAll(additionalTransformationURIs);
        }
        return allTransformations;
    }

    protected List<ModelExtent> getModelExtents() {
        LinkedList<ModelExtent> allExtents = new LinkedList<ModelExtent>();
        allExtents.add(this.getInSysML1_4Profile());
        allExtents.add(this.getInUMLPrimitivesTypes());
        allExtents.add(this.getInSysMLStandardLibrary());
        allExtents.add(this.getInUMLProfileStandard());
        allExtents.add(this.getInOutUMLModel());
        return allExtents;
    }

    protected List<ModelExtent> getDiagramsModelExtents() {
        LinkedList<ModelExtent> allExtents = new LinkedList<ModelExtent>();
        allExtents.add(this.getOutUMLModelForDiagrams());
        allExtents.add(this.getInSysML1_4Profile());
        allExtents.add(this.getInRequirementNatTableSysML11());
        allExtents.add(this.getInAllocationNatTableSysML11());
        allExtents.add(this.getInRequirementNatTableSysML14());
        allExtents.add(this.getInAllocationNatTableSysML14());
        allExtents.add(this.getInoutNotationModel());
        return allExtents;
    }

    public ModelExtent getInOutUMLModel() {
        Resource oldUMLResource = this.resourceSet.getResource(this.sourceURI.trimFileExtension().appendFileExtension("uml"), true);
        this.outUML = oldUMLResource != null ? new BasicModelExtent((List)oldUMLResource.getContents()) : new BasicModelExtent();
        return this.outUML;
    }

    public ModelExtent getOutUMLModelForDiagrams() {
        this.outUML = this.umlResource != null ? new BasicModelExtent((List)this.umlResource.getContents()) : new BasicModelExtent();
        return this.outUML;
    }

    public ModelExtent getInoutNotationModel() {
        Resource oldNotationResource = this.resourceSet.getResource(this.sourceURI.trimFileExtension().appendFileExtension(NOTATION_FILE_EXTENSION), true);
        this.outNotation = oldNotationResource != null ? new BasicModelExtent((List)oldNotationResource.getContents()) : new BasicModelExtent();
        return this.outNotation;
    }

    protected ModelExtent getInSysML1_4Profile() {
        URI sysMLProfile = URI.createURI((String)"pathmap://SysML14_PROFILES/SysML.profile.uml");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.sysML14Profile = new BasicModelExtent((List)fCMProfile.getContents());
        return this.sysML14Profile;
    }

    protected ModelExtent getInUMLPrimitivesTypes() {
        URI umlPrimitivesTypesURI = URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
        Resource umlPrimitivesTypesResource = this.resourceSet.getResource(umlPrimitivesTypesURI, true);
        this.umlPrimitivesTypes = new BasicModelExtent((List)umlPrimitivesTypesResource.getContents());
        return this.umlPrimitivesTypes;
    }

    protected ModelExtent getInSysMLStandardLibrary() {
        URI sysMLProfile = URI.createURI((String)"pathmap://SysML14_LIBRARIES/SysML-Standard-Library.uml");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.sysML14Profile = new BasicModelExtent((List)fCMProfile.getContents());
        return this.sysML14Profile;
    }

    protected ModelExtent getInUMLProfileStandard() {
        URI sysMLProfile = URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.sysML14Profile = new BasicModelExtent((List)fCMProfile.getContents());
        return this.sysML14Profile;
    }

    protected ModelExtent getInRequirementNatTableSysML11() {
        URI sysMLProfile = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.sysml.nattable.requirement.config/configs/requirement.nattableconfiguration");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.requirementNatTable11 = new BasicModelExtent((List)fCMProfile.getContents());
        return this.requirementNatTable11;
    }

    protected ModelExtent getInAllocationNatTableSysML11() {
        URI sysMLProfile = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.sysml.nattable.allocation.config/resources/allocation.nattableconfiguration");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.allocationNatTable11 = new BasicModelExtent((List)fCMProfile.getContents());
        return this.allocationNatTable11;
    }

    protected ModelExtent getInRequirementNatTableSysML14() {
        URI sysMLProfile = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.sysml14.nattable.requirement/resources/requirement.nattableconfiguration");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.requirementNatTable14 = new BasicModelExtent((List)fCMProfile.getContents());
        return this.requirementNatTable14;
    }

    protected ModelExtent getInAllocationNatTableSysML14() {
        URI sysMLProfile = URI.createURI((String)"platform:/plugin/org.eclipse.papyrus.sysml14.nattable.allocation/resources/allocation.nattableconfiguration");
        Resource fCMProfile = this.resourceSet.getResource(sysMLProfile, true);
        this.allocationNatTable14 = new BasicModelExtent((List)fCMProfile.getContents());
        return this.allocationNatTable14;
    }

    protected URI convertToPapyrus(URI initialModelURI, String extension) {
        URI uriWithoutExtension = initialModelURI.trimFileExtension();
        String lastSegment = uriWithoutExtension.lastSegment();
        lastSegment = String.valueOf(lastSegment) + "_converted";
        uriWithoutExtension = uriWithoutExtension.trimSegments(1);
        uriWithoutExtension = uriWithoutExtension.appendSegment(lastSegment);
        return uriWithoutExtension.appendFileExtension(extension);
    }

    protected Resource createUMLResource(ResourceSet resourceSet, URI sourceResourceURI, URI targetResourceURI) {
        return resourceSet.createResource(targetResourceURI, "org.eclipse.uml2.uml_5_0_0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResourceSet(IProgressMonitor monitor) {
        this.resourceSet = new MigrationResourceSetImpl();
        Class<UMLUtil> clazz = UMLUtil.class;
        synchronized (UMLUtil.class) {
            UMLUtil.init((ResourceSet)this.resourceSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
            this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
            this.resourceSet.getLoadOptions().put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
            monitor.subTask("Loading source model " + this.getModelName());
            try {
                this.resourceSet.getResource(this.sourceURI, true);
                this.loadInPapyrusProfiles();
            }
            catch (Exception ex) {
                Activator.log.error("An error occurred while loading " + this.getModelName(), (Throwable)ex);
            }
            return;
        }
    }

    protected void dispose() {
        this.umlPrimitivesTypes = null;
        this.sysML11Profile = null;
        this.sysML14Profile = null;
        this.blockDefinitionViewpoint = null;
        this.internalBlockViewpoint = null;
        this.parametricViewpoint = null;
        this.requirementViewpoint = null;
        this.requirementNatTable11 = null;
        this.allocationNatTable11 = null;
        this.requirementNatTable14 = null;
        this.allocationNatTable14 = null;
        this.requirementTableViewpoint = null;
        this.allocationTableViewpoint = null;
        this.umlResource = null;
        this.outUML = null;
        this.outNotation = null;
        this.inPapyrusProfiles = null;
        this.inParameters = null;
        this.outSashModel = null;
        this.resourceSet = null;
        this.context = null;
    }
}

