/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and Others.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *  
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.wizard;

import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.AbstractDialogData;

/**
 * This allows to defined the extensions needed for the migration.
 */
public class TransformationSysMLDialogData extends AbstractDialogData {

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.migration.common.wizard.pages.AbstractDialogData#getExtensions()
	 */
	@Override
	public String[] getExtensions() {
		return new String[] { "*.di", "*" };

	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.migration.common.wizard.pages.AbstractDialogData#getExtensionsNames()
	 */
	@Override
	public String[] getExtensionsNames() {
		return new String[] { "*.di", "*" };
	}

}
