/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.transformations.notation;

import java.util.List;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;

public class RpyNode {
    int[] topLeft;
    int[] topRight;
    int[] bottomRight;
    int[] bottomLeft;
    float xPos;
    float yPos;
    float xRatio;
    float yRatio;

    public RpyNode(List<String> polygon, List<String> transform) {
        this.topLeft = new int[]{Integer.parseInt(polygon.get(1)), Integer.parseInt(polygon.get(2))};
        this.topRight = new int[]{Integer.parseInt(polygon.get(3)), Integer.parseInt(polygon.get(4))};
        this.bottomRight = new int[]{Integer.parseInt(polygon.get(5)), Integer.parseInt(polygon.get(6))};
        this.bottomLeft = new int[]{Integer.parseInt(polygon.get(7)), Integer.parseInt(polygon.get(8))};
        this.xPos = Float.parseFloat(transform.get(4));
        this.yPos = Float.parseFloat(transform.get(5));
        this.xRatio = Float.parseFloat(transform.get(0));
        this.yRatio = Float.parseFloat(transform.get(3));
    }

    public int getX() {
        return Math.round(this.xPos);
    }

    public int getY() {
        return Math.round(this.yPos);
    }

    public int getHeight() {
        return Math.round(this.yRatio * (float)(this.bottomLeft[1] - this.topLeft[1]));
    }

    public int getWidth() {
        return Math.round(this.xRatio * (float)(this.topRight[0] - this.topLeft[0]));
    }

    public int getRelativeHeight() {
        return this.bottomLeft[1] - this.topLeft[1];
    }

    public int getRelativeWidth() {
        return this.topRight[0] - this.topLeft[0];
    }

    public Anchor getAnchor(List<String> port) {
        int yPort;
        IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        int xPort = Integer.parseInt(port.get(0));
        if (xPort < this.topLeft[0]) {
            xPort = this.topLeft[0];
        }
        if (xPort > this.topRight[0]) {
            xPort = this.topRight[0];
        }
        if ((yPort = Integer.parseInt(port.get(1))) < this.topLeft[1]) {
            yPort = this.topLeft[1];
        }
        if (yPort > this.bottomLeft[1]) {
            yPort = this.bottomLeft[1];
        }
        float xRatio = new Float(xPort).floatValue() / new Float(this.getRelativeWidth()).floatValue();
        float yRatio = new Float(yPort).floatValue() / new Float(this.getRelativeHeight()).floatValue();
        if (xRatio > 1.0f) {
            xRatio = 1.0f;
        }
        if (yRatio > 1.0f) {
            yRatio = 1.0f;
        }
        String id = "(" + xRatio + "," + yRatio + ")";
        anchor.setId(id);
        return anchor;
    }
}

