/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.importer.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.interoperability.rpy.Activator;
import org.eclipse.papyrus.interoperability.rpy.messages.Messages;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyContent;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFeature;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFeatureValue;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNode;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNodeList;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpySimpleValueElement;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpySyntaxFactory;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.SimpleValueList;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class RpyUtil {
    public static final String GUID_STRING = "GUID";
    public static final String OLDID_STRING = "OLDID";
    public static final String ID_SEPARATOR = "-";
    public static final String EANNOTATION_SOURCE__RPY_FILENAME = "Rpy Filename";
    public static final Object RAW_CONTAINER_NAME;
    public static final String RAW_CONTAINER_VALUE_FEATURE_NAME = "value";
    private static final String ID_FEATURE_NAME = "_id";
    private static final String IHANDLE_NAME = "IHandle";
    private static final String ISUBSYSTEM_HANDLE_NAME = "ISubsystemHandle";
    private static final String INOBJECT_HANDLE_NAME = "INObjectHandle";
    private static final String ICLASSIFIER_HANDLE_NAME = "IClassifierHandle";
    public static final String HANDLE_FILE_NAME_REF = "_filename";
    public static final String ELEMENT_FILE_NAME_REF = "fileName";
    private static final String ELEMENT_PERSIST_AT = "_persistAs";
    private static final String NAME_FEATURE_NAME = "_name";
    private static final String SUBSYSTEM_FEATURE_NAME = "_subsystem";
    private static final String CLASS_FEATURE_NAME = "_class";
    private static final String M2_CLASS_FEATURE_NAME = "_m2Class";
    public static List<String> SUPPORTED_EXTENSIONS;
    public static Map<String, String> nodeTypeToExtensionMap;
    private static final String FILE_EXTENSION_PROPERTIES = "fileextension.properties";
    private static final String NULL_STRING = "NULL";
    public static final String OWNED_ELEMENT_FEATURE_NAME = "graphElements";
    public static final String UNKNWON_CLASS_NAME = "UnknownType";

    static {
        block14: {
            RAW_CONTAINER_NAME = "IRPYRawContainer";
            SUPPORTED_EXTENSIONS = new ArrayList<String>();
            nodeTypeToExtensionMap = new HashMap<String, String>();
            Properties prop = new Properties();
            InputStream input = null;
            try {
                try {
                    input = RpyUtil.class.getResourceAsStream(FILE_EXTENSION_PROPERTIES);
                    prop.load(input);
                    for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                        String[] valueTable;
                        SUPPORTED_EXTENSIONS.add((String)entry.getKey());
                        String valueString = (String)entry.getValue();
                        String[] stringArray = valueTable = valueString.split(",");
                        int n = valueTable.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String value = stringArray[n2];
                            nodeTypeToExtensionMap.put(value, (String)entry.getKey());
                            ++n2;
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (input == null) break block14;
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static List<RpyFeature> getNodeFeatures(RpyNode context) {
        ArrayList<RpyFeature> ret = new ArrayList<RpyFeature>();
        for (RpyContent content : context.getContents()) {
            if (!(content instanceof RpyFeature)) continue;
            ret.add((RpyFeature)content);
        }
        return ret;
    }

    public static RpyFeatureValue getFeatureValue(RpyFeature feature) {
        RpyNode node;
        RpyFeatureValue value = feature.getValue();
        if (value instanceof RpyNodeList && ((RpyNodeList)value).getValues().size() == 1 && RAW_CONTAINER_NAME.equals((node = (RpyNode)((RpyNodeList)value).getValues().get(0)).getName())) {
            return RpyUtil.getNodeFeatureValue(node, RAW_CONTAINER_VALUE_FEATURE_NAME);
        }
        return value;
    }

    public static RpyFeatureValue getNodeFeatureValue(RpyNode context, String featureName) {
        for (RpyFeature feature : RpyUtil.getNodeFeatures(context)) {
            if (!featureName.equals(feature.getName())) continue;
            return RpyUtil.getFeatureValue(feature);
        }
        return null;
    }

    public static String getID(RpyNode node) {
        if (!RpyUtil.isRpyIHandle(node)) {
            return RpyUtil.getNodeFeatureValueAsString(node, ID_FEATURE_NAME);
        }
        return null;
    }

    public static String getNodeFeatureValueAsString(RpyNode context, String featureName) {
        RpyFeatureValue value = RpyUtil.getNodeFeatureValue(context, featureName);
        if (value instanceof SimpleValueList) {
            return RpyUtil.getStringValue((SimpleValueList)value);
        }
        return null;
    }

    public static String getStringValue(SimpleValueList value) {
        if (!value.getValueElements().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            if (value.isIsGUID()) {
                builder.append(GUID_STRING);
                builder.append(ID_SEPARATOR);
            }
            if (value.isIsOldID()) {
                builder.append(OLDID_STRING);
                builder.append(ID_SEPARATOR);
            }
            for (RpySimpleValueElement simpleValueElem : value.getValueElements()) {
                for (String val : simpleValueElem.getValues()) {
                    builder.append(val);
                }
            }
            return builder.toString();
        }
        return null;
    }

    public static boolean containsHandle(RpyNodeList nodeList) {
        for (RpyNode node : nodeList.getValues()) {
            if (!RpyUtil.isRpyIHandle(node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRpyIHandle(RpyNode node) {
        return IHANDLE_NAME.equals(node.getName()) || ISUBSYSTEM_HANDLE_NAME.equals(node.getName()) || INOBJECT_HANDLE_NAME.equals(node.getName()) || ICLASSIFIER_HANDLE_NAME.equals(node.getName());
    }

    public static String getIHandleFileRef(RpyNode node) {
        return RpyUtil.getPathStringInFeature(node, HANDLE_FILE_NAME_REF);
    }

    public static String getElementFileRef(RpyNode node) {
        String fileName = RpyUtil.getPathStringInFeature(node, ELEMENT_FILE_NAME_REF);
        if (fileName != null) {
            String nodeType = node.getName();
            String extension = nodeTypeToExtensionMap.get(nodeType);
            if (extension != null) {
                fileName = String.valueOf(fileName) + "." + extension;
                return fileName;
            }
            Activator.log.error(NLS.bind((String)Messages.RpyUtil_UnknownExtension, (Object[])new String[]{nodeType, fileName, RpyUtil.getNodeIndexInFile(node), node.eResource().getURI().toFileString()}), null);
        }
        return null;
    }

    public static String getElementPersistAt(RpyNode node) {
        return RpyUtil.getPathStringInFeature(node, ELEMENT_PERSIST_AT);
    }

    private static String getPathStringInFeature(RpyNode node, String featurePath) {
        String stringValue = RpyUtil.getNodeFeatureValueAsString(node, featurePath);
        if (stringValue != null && stringValue.startsWith("\"")) {
            stringValue = stringValue.replaceAll("\"", "");
        }
        return stringValue;
    }

    public static boolean isDirectReference(RpyFeature feature) {
        if (feature.getValue() instanceof SimpleValueList) {
            SimpleValueList simpleValueList = (SimpleValueList)feature.getValue();
            return (simpleValueList.isIsGUID() || simpleValueList.isIsOldID()) && !feature.getName().equals(ID_FEATURE_NAME);
        }
        return false;
    }

    public static String getReferencedID(RpyNode handleOrReference) {
        if (RpyUtil.isElementRef(handleOrReference) || RpyUtil.isRpyIHandle(handleOrReference)) {
            return RpyUtil.getNodeFeatureValueAsString(handleOrReference, ID_FEATURE_NAME);
        }
        return null;
    }

    public static boolean isElementRef(RpyNode node) {
        return RpyUtil.getElementFileRef(node) != null;
    }

    public static String getNodeIndexInFile(RpyNode node) {
        ICompositeNode xtextNode = NodeModelUtils.getNode((EObject)node);
        String index = ID_SEPARATOR;
        if (xtextNode != null) {
            index = Integer.toString(xtextNode.getStartLine());
        }
        return index;
    }

    public static String getReferencedSubsystemFromHandle(RpyNode node) {
        String subSystemName = RpyUtil.getPathStringInFeature(node, SUBSYSTEM_FEATURE_NAME);
        if (subSystemName != null && !subSystemName.isEmpty()) {
            return subSystemName;
        }
        return null;
    }

    public static String getReferencedClassFromHandle(RpyNode node) {
        String className = RpyUtil.getPathStringInFeature(node, CLASS_FEATURE_NAME);
        if (className != null && !className.isEmpty()) {
            return className;
        }
        return null;
    }

    public static String getReferencedNameFromHandle(RpyNode node) {
        String name = RpyUtil.getPathStringInFeature(node, NAME_FEATURE_NAME);
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return null;
    }

    public static boolean isNull(SimpleValueList rpyFeatureValue) {
        return NULL_STRING.equals(RpyUtil.getStringValue(rpyFeatureValue));
    }

    public static RpyNode createProxyNodeFromHandler(RpyNode handlerNode) {
        String m2Class = RpyUtil.getNodeFeatureValueAsString(handlerNode, M2_CLASS_FEATURE_NAME);
        if (m2Class != null) {
            RpyNode ret = RpySyntaxFactory.eINSTANCE.createRpyNode();
            ret.setName(m2Class.replaceAll("\"", ""));
            for (RpyFeature feature : RpyUtil.getNodeFeatures(handlerNode)) {
                if (!ID_FEATURE_NAME.equals(feature.getName()) && !NAME_FEATURE_NAME.equals(feature.getName()) && !HANDLE_FILE_NAME_REF.equals(feature.getName())) continue;
                ret.getContents().add((Object)((RpyContent)EcoreUtil.copy((EObject)feature)));
            }
            return ret;
        }
        return null;
    }
}

