/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.importer.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyProjectHandler;
import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyUtil;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyContent;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyFile;
import org.eclipse.papyrus.interoperability.rpy.parser.rpySyntax.RpyNode;

public class RpyFileHandler {
    private Map<String, RpyNode> idToNodeMap = new HashMap<String, RpyNode>();
    private RpyFile rpyFile;
    private RpyProjectHandler project;

    public URI getURI() {
        if (this.rpyFile != null && this.rpyFile.eResource() != null) {
            return this.rpyFile.eResource().getURI();
        }
        return null;
    }

    public RpyFile getRpyFile() {
        return this.rpyFile;
    }

    public RpyFileHandler(Resource resource, RpyProjectHandler project) {
        this.project = project;
        if (resource != null && !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof RpyFile) {
            this.rpyFile = (RpyFile)resource.getContents().get(0);
        }
        TreeIterator iterator = this.rpyFile.eAllContents();
        while (iterator.hasNext()) {
            RpyNode node;
            String id;
            EObject obj = (EObject)iterator.next();
            if (!(obj instanceof RpyNode) || (id = RpyUtil.getID(node = (RpyNode)obj)) == null) continue;
            this.idToNodeMap.put(id, node);
        }
    }

    public List<RpyContent> getContents() {
        return this.rpyFile.getContents();
    }

    public RpyNode getNodeById(String id) {
        return this.idToNodeMap.get(id);
    }
}

