/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.rpy.wizard;

import org.eclipse.papyrus.interoperability.rpy.messages.Messages;
import org.eclipse.papyrus.interoperability.rpy.transformations.RpyImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.AbstractTransformationWizard;
import org.eclipse.swt.widgets.Control;

/**
 * 
 * @author Vincent Lorenzo
 *
 */
public class TransformationRpyWizard extends AbstractTransformationWizard {

	public TransformationRpyWizard() {
		super(Messages.TransformationRpyWizard_WizardTitle, new RpyDialogData());
	}

	/**
	 * 
	 * @see org.eclipse.papyrus.uml.m2m.qvto.common.wizard.AbstractTransformationWizard#createTransformationLauncher(org.eclipse.papyrus.migration.common.MigrationParameters.Config, org.eclipse.swt.widgets.Control)
	 *
	 * @param config
	 * @param baseControl
	 * @return
	 */
	@Override
	protected AbstractImportTransformationLauncher createTransformationLauncher(ThreadConfig config, Control baseControl) {
		return new RpyImportTransformationLauncher(config, baseControl);
	}

}
