/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.rpy.wizard;

import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyFileUtils;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.AbstractDialogData;

/**
 * 
 * @author Vincent Lorenzo
 *
 */
public class RpyDialogData extends AbstractDialogData {

	/**
	 * 
	 * @see org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.AbstractDialogData#getExtensions()
	 *
	 * @return
	 */
	@Override
	public String[] getExtensions() {
		return new String[] { RpyFileUtils.ALL_RPY_FILES, RpyFileUtils.STRING_STAR };

	}

	/**
	 * 
	 * @see org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.AbstractDialogData#getExtensionsNames()
	 *
	 * @return
	 */
	@Override
	public String[] getExtensionsNames() {
		return new String[] { RpyFileUtils.ALL_RPY_FILES, RpyFileUtils.STRING_ALL };
	}

}
