/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.util.UMLRpyAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class UMLRpyItemProviderAdapterFactory extends UMLRpyAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UMLRpyItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CCollaborationChartItemProvider cCollaborationChartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCCollaborationChartAdapter() {
		if (cCollaborationChartItemProvider == null) {
			cCollaborationChartItemProvider = new CCollaborationChartItemProvider(this);
		}

		return cCollaborationChartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIActionStateItemProvider cgiActionStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIActionStateAdapter() {
		if (cgiActionStateItemProvider == null) {
			cgiActionStateItemProvider = new CGIActionStateItemProvider(this);
		}

		return cgiActionStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIActiveXItemProvider cgiActiveXItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIActiveXAdapter() {
		if (cgiActiveXItemProvider == null) {
			cgiActiveXItemProvider = new CGIActiveXItemProvider(this);
		}

		return cgiActiveXItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIAnchorItemProvider cgiAnchorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIAnchorAdapter() {
		if (cgiAnchorItemProvider == null) {
			cgiAnchorItemProvider = new CGIAnchorItemProvider(this);
		}

		return cgiAnchorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIAnnotationItemProvider cgiAnnotationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIAnnotationAdapter() {
		if (cgiAnnotationItemProvider == null) {
			cgiAnnotationItemProvider = new CGIAnnotationItemProvider(this);
		}

		return cgiAnnotationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIArrowItemProvider cgiArrowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIArrowAdapter() {
		if (cgiArrowItemProvider == null) {
			cgiArrowItemProvider = new CGIArrowItemProvider(this);
		}

		return cgiArrowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIAssociationEndItemProvider cgiAssociationEndItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIAssociationEndAdapter() {
		if (cgiAssociationEndItemProvider == null) {
			cgiAssociationEndItemProvider = new CGIAssociationEndItemProvider(this);
		}

		return cgiAssociationEndItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIAssociationRoleItemProvider cgiAssociationRoleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIAssociationRoleAdapter() {
		if (cgiAssociationRoleItemProvider == null) {
			cgiAssociationRoleItemProvider = new CGIAssociationRoleItemProvider(this);
		}

		return cgiAssociationRoleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIBasicClassItemProvider cgiBasicClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIBasicClassAdapter() {
		if (cgiBasicClassItemProvider == null) {
			cgiBasicClassItemProvider = new CGIBasicClassItemProvider(this);
		}

		return cgiBasicClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIBlockStateItemProvider cgiBlockStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIBlockStateAdapter() {
		if (cgiBlockStateItemProvider == null) {
			cgiBlockStateItemProvider = new CGIBlockStateItemProvider(this);
		}

		return cgiBlockStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIBoxItemProvider cgiBoxItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIBoxAdapter() {
		if (cgiBoxItemProvider == null) {
			cgiBoxItemProvider = new CGIBoxItemProvider(this);
		}

		return cgiBoxItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIButtonArrayItemProvider cgiButtonArrayItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIButtonArrayAdapter() {
		if (cgiButtonArrayItemProvider == null) {
			cgiButtonArrayItemProvider = new CGIButtonArrayItemProvider(this);
		}

		return cgiButtonArrayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIClassItemProvider cgiClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIClassAdapter() {
		if (cgiClassItemProvider == null) {
			cgiClassItemProvider = new CGIClassItemProvider(this);
		}

		return cgiClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassChart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIClassChartItemProvider cgiClassChartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassChart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIClassChartAdapter() {
		if (cgiClassChartItemProvider == null) {
			cgiClassChartItemProvider = new CGIClassChartItemProvider(this);
		}

		return cgiClassChartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassifierRole} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIClassifierRoleItemProvider cgiClassifierRoleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassifierRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIClassifierRoleAdapter() {
		if (cgiClassifierRoleItemProvider == null) {
			cgiClassifierRoleItemProvider = new CGIClassifierRoleItemProvider(this);
		}

		return cgiClassifierRoleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGICompartmentItemProvider cgiCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGICompartmentAdapter() {
		if (cgiCompartmentItemProvider == null) {
			cgiCompartmentItemProvider = new CGICompartmentItemProvider(this);
		}

		return cgiCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIComponentItemProvider cgiComponentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIComponentAdapter() {
		if (cgiComponentItemProvider == null) {
			cgiComponentItemProvider = new CGIComponentItemProvider(this);
		}

		return cgiComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompositeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGICompositeClassItemProvider cgiCompositeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompositeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGICompositeClassAdapter() {
		if (cgiCompositeClassItemProvider == null) {
			cgiCompositeClassItemProvider = new CGICompositeClassItemProvider(this);
		}

		return cgiCompositeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIConnector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIConnectorItemProvider cgiConnectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIConnector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIConnectorAdapter() {
		if (cgiConnectorItemProvider == null) {
			cgiConnectorItemProvider = new CGIConnectorItemProvider(this);
		}

		return cgiConnectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIContainArrow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIContainArrowItemProvider cgiContainArrowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIContainArrow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIContainArrowAdapter() {
		if (cgiContainArrowItemProvider == null) {
			cgiContainArrowItemProvider = new CGIContainArrowItemProvider(this);
		}

		return cgiContainArrowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIDiagramFrame} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIDiagramFrameItemProvider cgiDiagramFrameItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIDiagramFrame}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIDiagramFrameAdapter() {
		if (cgiDiagramFrameItemProvider == null) {
			cgiDiagramFrameItemProvider = new CGIDiagramFrameItemProvider(this);
		}

		return cgiDiagramFrameItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeShape} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIFreeShapeItemProvider cgiFreeShapeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeShape}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIFreeShapeAdapter() {
		if (cgiFreeShapeItemProvider == null) {
			cgiFreeShapeItemProvider = new CGIFreeShapeItemProvider(this);
		}

		return cgiFreeShapeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeText} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIFreeTextItemProvider cgiFreeTextItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeText}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIFreeTextAdapter() {
		if (cgiFreeTextItemProvider == null) {
			cgiFreeTextItemProvider = new CGIFreeTextItemProvider(this);
		}

		return cgiFreeTextItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIGenericElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIGenericElementItemProvider cgiGenericElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIGenericElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIGenericElementAdapter() {
		if (cgiGenericElementItemProvider == null) {
			cgiGenericElementItemProvider = new CGIGenericElementItemProvider(this);
		}

		return cgiGenericElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIImageItemProvider cgiImageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIImageAdapter() {
		if (cgiImageItemProvider == null) {
			cgiImageItemProvider = new CGIImageItemProvider(this);
		}

		return cgiImageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImageData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIImageDataItemProvider cgiImageDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImageData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIImageDataAdapter() {
		if (cgiImageDataItemProvider == null) {
			cgiImageDataItemProvider = new CGIImageDataItemProvider(this);
		}

		return cgiImageDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInformationFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIInformationFlowItemProvider cgiInformationFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInformationFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIInformationFlowAdapter() {
		if (cgiInformationFlowItemProvider == null) {
			cgiInformationFlowItemProvider = new CGIInformationFlowItemProvider(this);
		}

		return cgiInformationFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInheritance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIInheritanceItemProvider cgiInheritanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInheritance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIInheritanceAdapter() {
		if (cgiInheritanceItemProvider == null) {
			cgiInheritanceItemProvider = new CGIInheritanceItemProvider(this);
		}

		return cgiInheritanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMFCCtrl} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMFCCtrlItemProvider cgimfcCtrlItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMFCCtrl}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMFCCtrlAdapter() {
		if (cgimfcCtrlItemProvider == null) {
			cgimfcCtrlItemProvider = new CGIMFCCtrlItemProvider(this);
		}

		return cgimfcCtrlItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMessageLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMessageLabelItemProvider cgiMessageLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMessageLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMessageLabelAdapter() {
		if (cgiMessageLabelItemProvider == null) {
			cgiMessageLabelItemProvider = new CGIMessageLabelItemProvider(this);
		}

		return cgiMessageLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscChartItemProvider cgiMscChartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscChartAdapter() {
		if (cgiMscChartItemProvider == null) {
			cgiMscChartItemProvider = new CGIMscChartItemProvider(this);
		}

		return cgiMscChartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscColumnCR} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscColumnCRItemProvider cgiMscColumnCRItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscColumnCR}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscColumnCRAdapter() {
		if (cgiMscColumnCRItemProvider == null) {
			cgiMscColumnCRItemProvider = new CGIMscColumnCRItemProvider(this);
		}

		return cgiMscColumnCRItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscConditionMark} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscConditionMarkItemProvider cgiMscConditionMarkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscConditionMark}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscConditionMarkAdapter() {
		if (cgiMscConditionMarkItemProvider == null) {
			cgiMscConditionMarkItemProvider = new CGIMscConditionMarkItemProvider(this);
		}

		return cgiMscConditionMarkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscExecutionOccurrence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscExecutionOccurrenceItemProvider cgiMscExecutionOccurrenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscExecutionOccurrence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscExecutionOccurrenceAdapter() {
		if (cgiMscExecutionOccurrenceItemProvider == null) {
			cgiMscExecutionOccurrenceItemProvider = new CGIMscExecutionOccurrenceItemProvider(this);
		}

		return cgiMscExecutionOccurrenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOccurrence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscInteractionOccurrenceItemProvider cgiMscInteractionOccurrenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOccurrence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscInteractionOccurrenceAdapter() {
		if (cgiMscInteractionOccurrenceItemProvider == null) {
			cgiMscInteractionOccurrenceItemProvider = new CGIMscInteractionOccurrenceItemProvider(this);
		}

		return cgiMscInteractionOccurrenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperand} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscInteractionOperandItemProvider cgiMscInteractionOperandItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscInteractionOperandAdapter() {
		if (cgiMscInteractionOperandItemProvider == null) {
			cgiMscInteractionOperandItemProvider = new CGIMscInteractionOperandItemProvider(this);
		}

		return cgiMscInteractionOperandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscInteractionOperatorItemProvider cgiMscInteractionOperatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscInteractionOperatorAdapter() {
		if (cgiMscInteractionOperatorItemProvider == null) {
			cgiMscInteractionOperatorItemProvider = new CGIMscInteractionOperatorItemProvider(this);
		}

		return cgiMscInteractionOperatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscMessage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIMscMessageItemProvider cgiMscMessageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscMessage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIMscMessageAdapter() {
		if (cgiMscMessageItemProvider == null) {
			cgiMscMessageItemProvider = new CGIMscMessageItemProvider(this);
		}

		return cgiMscMessageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIObjectInstanceItemProvider cgiObjectInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIObjectInstanceAdapter() {
		if (cgiObjectInstanceItemProvider == null) {
			cgiObjectInstanceItemProvider = new CGIObjectInstanceItemProvider(this);
		}

		return cgiObjectInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIObjectLinkItemProvider cgiObjectLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIObjectLinkAdapter() {
		if (cgiObjectLinkItemProvider == null) {
			cgiObjectLinkItemProvider = new CGIObjectLinkItemProvider(this);
		}

		return cgiObjectLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPackage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIPackageItemProvider cgiPackageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIPackageAdapter() {
		if (cgiPackageItemProvider == null) {
			cgiPackageItemProvider = new CGIPackageItemProvider(this);
		}

		return cgiPackageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPartition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIPartitionItemProvider cgiPartitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPartition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIPartitionAdapter() {
		if (cgiPartitionItemProvider == null) {
			cgiPartitionItemProvider = new CGIPartitionItemProvider(this);
		}

		return cgiPartitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPortConnector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIPortConnectorItemProvider cgiPortConnectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPortConnector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIPortConnectorAdapter() {
		if (cgiPortConnectorItemProvider == null) {
			cgiPortConnectorItemProvider = new CGIPortConnectorItemProvider(this);
		}

		return cgiPortConnectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIStateItemProvider cgiStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIStateAdapter() {
		if (cgiStateItemProvider == null) {
			cgiStateItemProvider = new CGIStateItemProvider(this);
		}

		return cgiStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIStateChart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGIStateChartItemProvider cgiStateChartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIStateChart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGIStateChartAdapter() {
		if (cgiStateChartItemProvider == null) {
			cgiStateChartItemProvider = new CGIStateChartItemProvider(this);
		}

		return cgiStateChartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGISwimlaneFrame} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGISwimlaneFrameItemProvider cgiSwimlaneFrameItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGISwimlaneFrame}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGISwimlaneFrameAdapter() {
		if (cgiSwimlaneFrameItemProvider == null) {
			cgiSwimlaneFrameItemProvider = new CGISwimlaneFrameItemProvider(this);
		}

		return cgiSwimlaneFrameItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIText} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGITextItemProvider cgiTextItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIText}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGITextAdapter() {
		if (cgiTextItemProvider == null) {
			cgiTextItemProvider = new CGITextItemProvider(this);
		}

		return cgiTextItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITextBox} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGITextBoxItemProvider cgiTextBoxItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITextBox}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGITextBoxAdapter() {
		if (cgiTextBoxItemProvider == null) {
			cgiTextBoxItemProvider = new CGITextBoxItemProvider(this);
		}

		return cgiTextBoxItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITrans} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGITransItemProvider cgiTransItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITrans}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCGITransAdapter() {
		if (cgiTransItemProvider == null) {
			cgiTransItemProvider = new CGITransItemProvider(this);
		}

		return cgiTransItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CollEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollEventItemProvider collEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CollEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollEventAdapter() {
		if (collEventItemProvider == null) {
			collEventItemProvider = new CollEventItemProvider(this);
		}

		return collEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptEventAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAcceptEventActionItemProvider iAcceptEventActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptEventAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAcceptEventActionAdapter() {
		if (iAcceptEventActionItemProvider == null) {
			iAcceptEventActionItemProvider = new IAcceptEventActionItemProvider(this);
		}

		return iAcceptEventActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptTimeEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAcceptTimeEventItemProvider iAcceptTimeEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptTimeEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAcceptTimeEventAdapter() {
		if (iAcceptTimeEventItemProvider == null) {
			iAcceptTimeEventItemProvider = new IAcceptTimeEventItemProvider(this);
		}

		return iAcceptTimeEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IActionItemProvider iActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIActionAdapter() {
		if (iActionItemProvider == null) {
			iActionItemProvider = new IActionItemProvider(this);
		}

		return iActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IActivityDiagramItemProvider iActivityDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIActivityDiagramAdapter() {
		if (iActivityDiagramItemProvider == null) {
			iActivityDiagramItemProvider = new IActivityDiagramItemProvider(this);
		}

		return iActivityDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityGraph} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IActivityGraphItemProvider iActivityGraphItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityGraph}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIActivityGraphAdapter() {
		if (iActivityGraphItemProvider == null) {
			iActivityGraphItemProvider = new IActivityGraphItemProvider(this);
		}

		return iActivityGraphItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IActorItemProvider iActorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIActorAdapter() {
		if (iActorItemProvider == null) {
			iActorItemProvider = new IActorItemProvider(this);
		}

		return iActorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnchor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAnchorItemProvider iAnchorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnchor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAnchorAdapter() {
		if (iAnchorItemProvider == null) {
			iAnchorItemProvider = new IAnchorItemProvider(this);
		}

		return iAnchorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnnotation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAnnotationItemProvider iAnnotationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnnotation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAnnotationAdapter() {
		if (iAnnotationItemProvider == null) {
			iAnnotationItemProvider = new IAnnotationItemProvider(this);
		}

		return iAnnotationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IArgument} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IArgumentItemProvider iArgumentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IArgument}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIArgumentAdapter() {
		if (iArgumentItemProvider == null) {
			iArgumentItemProvider = new IArgumentItemProvider(this);
		}

		return iArgumentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAssociationClassItemProvider iAssociationClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAssociationClassAdapter() {
		if (iAssociationClassItemProvider == null) {
			iAssociationClassItemProvider = new IAssociationClassItemProvider(this);
		}

		return iAssociationClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEnd} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAssociationEndItemProvider iAssociationEndItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEnd}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAssociationEndAdapter() {
		if (iAssociationEndItemProvider == null) {
			iAssociationEndItemProvider = new IAssociationEndItemProvider(this);
		}

		return iAssociationEndItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEndHandle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAssociationEndHandleItemProvider iAssociationEndHandleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEndHandle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAssociationEndHandleAdapter() {
		if (iAssociationEndHandleItemProvider == null) {
			iAssociationEndHandleItemProvider = new IAssociationEndHandleItemProvider(this);
		}

		return iAssociationEndHandleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationRole} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAssociationRoleItemProvider iAssociationRoleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAssociationRoleAdapter() {
		if (iAssociationRoleItemProvider == null) {
			iAssociationRoleItemProvider = new IAssociationRoleItemProvider(this);
		}

		return iAssociationRoleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IAttributeItemProvider iAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIAttributeAdapter() {
		if (iAttributeItemProvider == null) {
			iAttributeItemProvider = new IAttributeItemProvider(this);
		}

		return iAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IBlockItemProvider iBlockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIBlockAdapter() {
		if (iBlockItemProvider == null) {
			iBlockItemProvider = new IBlockItemProvider(this);
		}

		return iBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBody} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IBodyItemProvider iBodyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBody}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIBodyAdapter() {
		if (iBodyItemProvider == null) {
			iBodyItemProvider = new IBodyItemProvider(this);
		}

		return iBodyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBranch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IBranchItemProvider iBranchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBranch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIBranchAdapter() {
		if (iBranchItemProvider == null) {
			iBranchItemProvider = new IBranchItemProvider(this);
		}

		return iBranchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICallActionItemProvider iCallActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICallActionAdapter() {
		if (iCallActionItemProvider == null) {
			iCallActionItemProvider = new ICallActionItemProvider(this);
		}

		return iCallActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallOperation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICallOperationItemProvider iCallOperationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallOperation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICallOperationAdapter() {
		if (iCallOperationItemProvider == null) {
			iCallOperationItemProvider = new ICallOperationItemProvider(this);
		}

		return iCallOperationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IClassItemProvider iClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIClassAdapter() {
		if (iClassItemProvider == null) {
			iClassItemProvider = new IClassItemProvider(this);
		}

		return iClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassHandle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IClassHandleItemProvider iClassHandleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassHandle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIClassHandleAdapter() {
		if (iClassHandleItemProvider == null) {
			iClassHandleItemProvider = new IClassHandleItemProvider(this);
		}

		return iClassHandleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IClassInstanceItemProvider iClassInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIClassInstanceAdapter() {
		if (iClassInstanceItemProvider == null) {
			iClassInstanceItemProvider = new IClassInstanceItemProvider(this);
		}

		return iClassInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IClassifierItemProvider iClassifierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIClassifierAdapter() {
		if (iClassifierItemProvider == null) {
			iClassifierItemProvider = new IClassifierItemProvider(this);
		}

		return iClassifierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifierRole} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IClassifierRoleItemProvider iClassifierRoleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifierRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIClassifierRoleAdapter() {
		if (iClassifierRoleItemProvider == null) {
			iClassifierRoleItemProvider = new IClassifierRoleItemProvider(this);
		}

		return iClassifierRoleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICodeGenConfigInfoItemProvider iCodeGenConfigInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICodeGenConfigInfoAdapter() {
		if (iCodeGenConfigInfoItemProvider == null) {
			iCodeGenConfigInfoItemProvider = new ICodeGenConfigInfoItemProvider(this);
		}

		return iCodeGenConfigInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfoHandle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICodeGenConfigInfoHandleItemProvider iCodeGenConfigInfoHandleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfoHandle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICodeGenConfigInfoHandleAdapter() {
		if (iCodeGenConfigInfoHandleItemProvider == null) {
			iCodeGenConfigInfoHandleItemProvider = new ICodeGenConfigInfoHandleItemProvider(this);
		}

		return iCodeGenConfigInfoHandleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaboration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICollaborationItemProvider iCollaborationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaboration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICollaborationAdapter() {
		if (iCollaborationItemProvider == null) {
			iCollaborationItemProvider = new ICollaborationItemProvider(this);
		}

		return iCollaborationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaborationDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICollaborationDiagramItemProvider iCollaborationDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaborationDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICollaborationDiagramAdapter() {
		if (iCollaborationDiagramItemProvider == null) {
			iCollaborationDiagramItemProvider = new ICollaborationDiagramItemProvider(this);
		}

		return iCollaborationDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IColor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IColorItemProvider iColorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IColor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIColorAdapter() {
		if (iColorItemProvider == null) {
			iColorItemProvider = new IColorItemProvider(this);
		}

		return iColorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICombinedFragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICombinedFragmentItemProvider iCombinedFragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICombinedFragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICombinedFragmentAdapter() {
		if (iCombinedFragmentItemProvider == null) {
			iCombinedFragmentItemProvider = new ICombinedFragmentItemProvider(this);
		}

		return iCombinedFragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ICommentItemProvider iCommentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createICommentAdapter() {
		if (iCommentItemProvider == null) {
			iCommentItemProvider = new ICommentItemProvider(this);
		}

		return iCommentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IComponentItemProvider iComponentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIComponentAdapter() {
		if (iComponentItemProvider == null) {
			iComponentItemProvider = new IComponentItemProvider(this);
		}

		return iComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IComponentDiagramItemProvider iComponentDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIComponentDiagramAdapter() {
		if (iComponentDiagramItemProvider == null) {
			iComponentDiagramItemProvider = new IComponentDiagramItemProvider(this);
		}

		return iComponentDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IComponentInstanceItemProvider iComponentInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIComponentInstanceAdapter() {
		if (iComponentInstanceItemProvider == null) {
			iComponentInstanceItemProvider = new IComponentInstanceItemProvider(this);
		}

		return iComponentInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConfiguration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IConfigurationItemProvider iConfigurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConfiguration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIConfigurationAdapter() {
		if (iConfigurationItemProvider == null) {
			iConfigurationItemProvider = new IConfigurationItemProvider(this);
		}

		return iConfigurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConnector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IConnectorItemProvider iConnectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConnector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIConnectorAdapter() {
		if (iConnectorItemProvider == null) {
			iConnectorItemProvider = new IConnectorItemProvider(this);
		}

		return iConnectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IConstraintItemProvider iConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIConstraintAdapter() {
		if (iConstraintItemProvider == null) {
			iConstraintItemProvider = new IConstraintItemProvider(this);
		}

		return iConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstructor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IConstructorItemProvider iConstructorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstructor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIConstructorAdapter() {
		if (iConstructorItemProvider == null) {
			iConstructorItemProvider = new IConstructorItemProvider(this);
		}

		return iConstructorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IContextSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IContextSpecificationItemProvider iContextSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IContextSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIContextSpecificationAdapter() {
		if (iContextSpecificationItemProvider == null) {
			iContextSpecificationItemProvider = new IContextSpecificationItemProvider(this);
		}

		return iContextSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IControlledFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IControlledFileItemProvider iControlledFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IControlledFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIControlledFileAdapter() {
		if (iControlledFileItemProvider == null) {
			iControlledFileItemProvider = new IControlledFileItemProvider(this);
		}

		return iControlledFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDefaultDrvdTrans} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IDefaultDrvdTransItemProvider iDefaultDrvdTransItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDefaultDrvdTrans}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIDefaultDrvdTransAdapter() {
		if (iDefaultDrvdTransItemProvider == null) {
			iDefaultDrvdTransItemProvider = new IDefaultDrvdTransItemProvider(this);
		}

		return iDefaultDrvdTransItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IDependencyItemProvider iDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIDependencyAdapter() {
		if (iDependencyItemProvider == null) {
			iDependencyItemProvider = new IDependencyItemProvider(this);
		}

		return iDependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDeploymentDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IDeploymentDiagramItemProvider iDeploymentDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDeploymentDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIDeploymentDiagramAdapter() {
		if (iDeploymentDiagramItemProvider == null) {
			iDeploymentDiagramItemProvider = new IDeploymentDiagramItemProvider(this);
		}

		return iDeploymentDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IDescriptionItemProvider iDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIDescriptionAdapter() {
		if (iDescriptionItemProvider == null) {
			iDescriptionItemProvider = new IDescriptionItemProvider(this);
		}

		return iDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDestructor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IDestructorItemProvider iDestructorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDestructor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIDestructorAdapter() {
		if (iDestructorItemProvider == null) {
			iDestructorItemProvider = new IDestructorItemProvider(this);
		}

		return iDestructorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IDiagramItemProvider iDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIDiagramAdapter() {
		if (iDiagramItemProvider == null) {
			iDiagramItemProvider = new IDiagramItemProvider(this);
		}

		return iDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEmbededFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IEmbededFileItemProvider iEmbededFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEmbededFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIEmbededFileAdapter() {
		if (iEmbededFileItemProvider == null) {
			iEmbededFileItemProvider = new IEmbededFileItemProvider(this);
		}

		return iEmbededFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEnumerationLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IEnumerationLiteralItemProvider iEnumerationLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEnumerationLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIEnumerationLiteralAdapter() {
		if (iEnumerationLiteralItemProvider == null) {
			iEnumerationLiteralItemProvider = new IEnumerationLiteralItemProvider(this);
		}

		return iEnumerationLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IEventItemProvider iEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIEventAdapter() {
		if (iEventItemProvider == null) {
			iEventItemProvider = new IEventItemProvider(this);
		}

		return iEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventHandle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IEventHandleItemProvider iEventHandleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventHandle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIEventHandleAdapter() {
		if (iEventHandleItemProvider == null) {
			iEventHandleItemProvider = new IEventHandleItemProvider(this);
		}

		return iEventHandleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventReception} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IEventReceptionItemProvider iEventReceptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventReception}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIEventReceptionAdapter() {
		if (iEventReceptionItemProvider == null) {
			iEventReceptionItemProvider = new IEventReceptionItemProvider(this);
		}

		return iEventReceptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IExecutionOccurrenceItemProvider iExecutionOccurrenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIExecutionOccurrenceAdapter() {
		if (iExecutionOccurrenceItemProvider == null) {
			iExecutionOccurrenceItemProvider = new IExecutionOccurrenceItemProvider(this);
		}

		return iExecutionOccurrenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExternalHyperlink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IExternalHyperlinkItemProvider iExternalHyperlinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExternalHyperlink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIExternalHyperlinkAdapter() {
		if (iExternalHyperlinkItemProvider == null) {
			iExternalHyperlinkItemProvider = new IExternalHyperlinkItemProvider(this);
		}

		return iExternalHyperlinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IFileItemProvider iFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIFileAdapter() {
		if (iFileItemProvider == null) {
			iFileItemProvider = new IFileItemProvider(this);
		}

		return iFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFileFragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IFileFragmentItemProvider iFileFragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFileFragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIFileFragmentAdapter() {
		if (iFileFragmentItemProvider == null) {
			iFileFragmentItemProvider = new IFileFragmentItemProvider(this);
		}

		return iFileFragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IFlowItemProvider iFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIFlowAdapter() {
		if (iFlowItemProvider == null) {
			iFlowItemProvider = new IFlowItemProvider(this);
		}

		return iFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IFlowItemItemProvider iFlowItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIFlowItemAdapter() {
		if (iFlowItemItemProvider == null) {
			iFlowItemItemProvider = new IFlowItemItemProvider(this);
		}

		return iFlowItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowchart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IFlowchartItemProvider iFlowchartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowchart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIFlowchartAdapter() {
		if (iFlowchartItemProvider == null) {
			iFlowchartItemProvider = new IFlowchartItemProvider(this);
		}

		return iFlowchartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFolder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IFolderItemProvider iFolderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFolder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIFolderAdapter() {
		if (iFolderItemProvider == null) {
			iFolderItemProvider = new IFolderItemProvider(this);
		}

		return iFolderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFork} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IForkItemProvider iForkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFork}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIForkAdapter() {
		if (iForkItemProvider == null) {
			iForkItemProvider = new IForkItemProvider(this);
		}

		return iForkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGeneralization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IGeneralizationItemProvider iGeneralizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGeneralization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIGeneralizationAdapter() {
		if (iGeneralizationItemProvider == null) {
			iGeneralizationItemProvider = new IGeneralizationItemProvider(this);
		}

		return iGeneralizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGuard} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IGuardItemProvider iGuardItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGuard}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIGuardAdapter() {
		if (iGuardItemProvider == null) {
			iGuardItemProvider = new IGuardItemProvider(this);
		}

		return iGuardItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHandleWithData} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IHandleWithDataItemProvider iHandleWithDataItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHandleWithData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIHandleWithDataAdapter() {
		if (iHandleWithDataItemProvider == null) {
			iHandleWithDataItemProvider = new IHandleWithDataItemProvider(this);
		}

		return iHandleWithDataItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHistoryConnector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IHistoryConnectorItemProvider iHistoryConnectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHistoryConnector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIHistoryConnectorAdapter() {
		if (iHistoryConnectorItemProvider == null) {
			iHistoryConnectorItemProvider = new IHistoryConnectorItemProvider(this);
		}

		return iHistoryConnectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHyperLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IHyperLinkItemProvider iHyperLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHyperLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIHyperLinkAdapter() {
		if (iHyperLinkItemProvider == null) {
			iHyperLinkItemProvider = new IHyperLinkItemProvider(this);
		}

		return iHyperLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationFlow} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInformationFlowItemProvider iInformationFlowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationFlow}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInformationFlowAdapter() {
		if (iInformationFlowItemProvider == null) {
			iInformationFlowItemProvider = new IInformationFlowItemProvider(this);
		}

		return iInformationFlowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInformationItemItemProvider iInformationItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInformationItemAdapter() {
		if (iInformationItemItemProvider == null) {
			iInformationItemItemProvider = new IInformationItemItemProvider(this);
		}

		return iInformationItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInstanceItemProvider iInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInstanceAdapter() {
		if (iInstanceItemProvider == null) {
			iInstanceItemProvider = new IInstanceItemProvider(this);
		}

		return iInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSlot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInstanceSlotItemProvider iInstanceSlotItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSlot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInstanceSlotAdapter() {
		if (iInstanceSlotItemProvider == null) {
			iInstanceSlotItemProvider = new IInstanceSlotItemProvider(this);
		}

		return iInstanceSlotItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInstanceSpecificationItemProvider iInstanceSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInstanceSpecificationAdapter() {
		if (iInstanceSpecificationItemProvider == null) {
			iInstanceSpecificationItemProvider = new IInstanceSpecificationItemProvider(this);
		}

		return iInstanceSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInstanceValueItemProvider iInstanceValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInstanceValueAdapter() {
		if (iInstanceValueItemProvider == null) {
			iInstanceValueItemProvider = new IInstanceValueItemProvider(this);
		}

		return iInstanceValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOccurrence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInteractionOccurrenceItemProvider iInteractionOccurrenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOccurrence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInteractionOccurrenceAdapter() {
		if (iInteractionOccurrenceItemProvider == null) {
			iInteractionOccurrenceItemProvider = new IInteractionOccurrenceItemProvider(this);
		}

		return iInteractionOccurrenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperand} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInteractionOperandItemProvider iInteractionOperandItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInteractionOperandAdapter() {
		if (iInteractionOperandItemProvider == null) {
			iInteractionOperandItemProvider = new IInteractionOperandItemProvider(this);
		}

		return iInteractionOperandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInteractionOperatorItemProvider iInteractionOperatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInteractionOperatorAdapter() {
		if (iInteractionOperatorItemProvider == null) {
			iInteractionOperatorItemProvider = new IInteractionOperatorItemProvider(this);
		}

		return iInteractionOperatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInterfaceItemItemProvider iInterfaceItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInterfaceItemAdapter() {
		if (iInterfaceItemItemProvider == null) {
			iInterfaceItemItemProvider = new IInterfaceItemItemProvider(this);
		}

		return iInterfaceItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItemTrigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInterfaceItemTriggerItemProvider iInterfaceItemTriggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItemTrigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInterfaceItemTriggerAdapter() {
		if (iInterfaceItemTriggerItemProvider == null) {
			iInterfaceItemTriggerItemProvider = new IInterfaceItemTriggerItemProvider(this);
		}

		return iInterfaceItemTriggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInternalHyperlink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IInternalHyperlinkItemProvider iInternalHyperlinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInternalHyperlink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIInternalHyperlinkAdapter() {
		if (iInternalHyperlinkItemProvider == null) {
			iInternalHyperlinkItemProvider = new IInternalHyperlinkItemProvider(this);
		}

		return iInternalHyperlinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ILabelItemProvider iLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createILabelAdapter() {
		if (iLabelItemProvider == null) {
			iLabelItemProvider = new ILabelItemProvider(this);
		}

		return iLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ILinkItemProvider iLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createILinkAdapter() {
		if (iLinkItemProvider == null) {
			iLinkItemProvider = new ILinkItemProvider(this);
		}

		return iLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILinkInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ILinkInstanceItemProvider iLinkInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILinkInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createILinkInstanceAdapter() {
		if (iLinkInstanceItemProvider == null) {
			iLinkInstanceItemProvider = new ILinkInstanceItemProvider(this);
		}

		return iLinkInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILiteralSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ILiteralSpecificationItemProvider iLiteralSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILiteralSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createILiteralSpecificationAdapter() {
		if (iLiteralSpecificationItemProvider == null) {
			iLiteralSpecificationItemProvider = new ILiteralSpecificationItemProvider(this);
		}

		return iLiteralSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMHyperLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMHyperLinkItemProvider imHyperLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMHyperLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMHyperLinkAdapter() {
		if (imHyperLinkItemProvider == null) {
			imHyperLinkItemProvider = new IMHyperLinkItemProvider(this);
		}

		return imHyperLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMSC} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMSCItemProvider imscItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMSC}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMSCAdapter() {
		if (imscItemProvider == null) {
			imscItemProvider = new IMSCItemProvider(this);
		}

		return imscItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMatrixInstanceItemProvider iMatrixInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMatrixInstanceAdapter() {
		if (iMatrixInstanceItemProvider == null) {
			iMatrixInstanceItemProvider = new IMatrixInstanceItemProvider(this);
		}

		return iMatrixInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixLayout} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMatrixLayoutItemProvider iMatrixLayoutItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixLayout}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMatrixLayoutAdapter() {
		if (iMatrixLayoutItemProvider == null) {
			iMatrixLayoutItemProvider = new IMatrixLayoutItemProvider(this);
		}

		return iMatrixLayoutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMatrixViewItemProvider iMatrixViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMatrixViewAdapter() {
		if (iMatrixViewItemProvider == null) {
			iMatrixViewItemProvider = new IMatrixViewItemProvider(this);
		}

		return iMatrixViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMessageItemProvider iMessageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMessageAdapter() {
		if (iMessageItemProvider == null) {
			iMessageItemProvider = new IMessageItemProvider(this);
		}

		return iMessageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessagePoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMessagePointItemProvider iMessagePointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessagePoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMessagePointAdapter() {
		if (iMessagePointItemProvider == null) {
			iMessagePointItemProvider = new IMessagePointItemProvider(this);
		}

		return iMessagePointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMetaLinkHandle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMetaLinkHandleItemProvider iMetaLinkHandleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMetaLinkHandle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMetaLinkHandleAdapter() {
		if (iMetaLinkHandleItemProvider == null) {
			iMetaLinkHandleItemProvider = new IMetaLinkHandleItemProvider(this);
		}

		return iMetaLinkHandleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModelElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IModelElementItemProvider iModelElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModelElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIModelElementAdapter() {
		if (iModelElementItemProvider == null) {
			iModelElementItemProvider = new IModelElementItemProvider(this);
		}

		return iModelElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IModuleItemProvider iModuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIModuleAdapter() {
		if (iModuleItemProvider == null) {
			iModuleItemProvider = new IModuleItemProvider(this);
		}

		return iModuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMultiplicityItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IMultiplicityItemItemProvider iMultiplicityItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMultiplicityItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIMultiplicityItemAdapter() {
		if (iMultiplicityItemItemProvider == null) {
			iMultiplicityItemItemProvider = new IMultiplicityItemItemProvider(this);
		}

		return iMultiplicityItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.INode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected INodeItemProvider iNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.INode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createINodeAdapter() {
		if (iNodeItemProvider == null) {
			iNodeItemProvider = new INodeItemProvider(this);
		}

		return iNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IObjectLinkItemProvider iObjectLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIObjectLinkAdapter() {
		if (iObjectLinkItemProvider == null) {
			iObjectLinkItemProvider = new IObjectLinkItemProvider(this);
		}

		return iObjectLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLinkHandle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IObjectLinkHandleItemProvider iObjectLinkHandleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLinkHandle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIObjectLinkHandleAdapter() {
		if (iObjectLinkHandleItemProvider == null) {
			iObjectLinkHandleItemProvider = new IObjectLinkHandleItemProvider(this);
		}

		return iObjectLinkHandleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectModelDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IObjectModelDiagramItemProvider iObjectModelDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectModelDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIObjectModelDiagramAdapter() {
		if (iObjectModelDiagramItemProvider == null) {
			iObjectModelDiagramItemProvider = new IObjectModelDiagramItemProvider(this);
		}

		return iObjectModelDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IObjectNodeItemProvider iObjectNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIObjectNodeAdapter() {
		if (iObjectNodeItemProvider == null) {
			iObjectNodeItemProvider = new IObjectNodeItemProvider(this);
		}

		return iObjectNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IOperation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IOperationItemProvider iOperationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IOperation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIOperationAdapter() {
		if (iOperationItemProvider == null) {
			iOperationItemProvider = new IOperationItemProvider(this);
		}

		return iOperationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPackage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPackageItemProvider iPackageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPackageAdapter() {
		if (iPackageItemProvider == null) {
			iPackageItemProvider = new IPackageItemProvider(this);
		}

		return iPackageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPanelDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPanelDiagramItemProvider iPanelDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPanelDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPanelDiagramAdapter() {
		if (iPanelDiagramItemProvider == null) {
			iPanelDiagramItemProvider = new IPanelDiagramItemProvider(this);
		}

		return iPanelDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPartItemProvider iPartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPartAdapter() {
		if (iPartItemProvider == null) {
			iPartItemProvider = new IPartItemProvider(this);
		}

		return iPartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPinItemProvider iPinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPinAdapter() {
		if (iPinItemProvider == null) {
			iPinItemProvider = new IPinItemProvider(this);
		}

		return iPinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPortItemProvider iPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPortAdapter() {
		if (iPortItemProvider == null) {
			iPortItemProvider = new IPortItemProvider(this);
		}

		return iPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPrimitiveOperation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPrimitiveOperationItemProvider iPrimitiveOperationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPrimitiveOperation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPrimitiveOperationAdapter() {
		if (iPrimitiveOperationItemProvider == null) {
			iPrimitiveOperationItemProvider = new IPrimitiveOperationItemProvider(this);
		}

		return iPrimitiveOperationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProfile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IProfileItemProvider iProfileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProfile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIProfileAdapter() {
		if (iProfileItemProvider == null) {
			iProfileItemProvider = new IProfileItemProvider(this);
		}

		return iProfileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IProjectItemProvider iProjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIProjectAdapter() {
		if (iProjectItemProvider == null) {
			iProjectItemProvider = new IProjectItemProvider(this);
		}

		return iProjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProperty} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPropertyItemProvider iPropertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProperty}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPropertyAdapter() {
		if (iPropertyItemProvider == null) {
			iPropertyItemProvider = new IPropertyItemProvider(this);
		}

		return iPropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPropertyContainerItemProvider iPropertyContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPropertyContainerAdapter() {
		if (iPropertyContainerItemProvider == null) {
			iPropertyContainerItemProvider = new IPropertyContainerItemProvider(this);
		}

		return iPropertyContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyMetaclass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPropertyMetaclassItemProvider iPropertyMetaclassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyMetaclass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPropertyMetaclassAdapter() {
		if (iPropertyMetaclassItemProvider == null) {
			iPropertyMetaclassItemProvider = new IPropertyMetaclassItemProvider(this);
		}

		return iPropertyMetaclassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertySubject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IPropertySubjectItemProvider iPropertySubjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertySubject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIPropertySubjectAdapter() {
		if (iPropertySubjectItemProvider == null) {
			iPropertySubjectItemProvider = new IPropertySubjectItemProvider(this);
		}

		return iPropertySubjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReception} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IReceptionItemProvider iReceptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReception}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIReceptionAdapter() {
		if (iReceptionItemProvider == null) {
			iReceptionItemProvider = new IReceptionItemProvider(this);
		}

		return iReceptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReferenceActivity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IReferenceActivityItemProvider iReferenceActivityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReferenceActivity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIReferenceActivityAdapter() {
		if (iReferenceActivityItemProvider == null) {
			iReferenceActivityItemProvider = new IReferenceActivityItemProvider(this);
		}

		return iReferenceActivityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRelation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IRelationItemProvider iRelationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRelation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIRelationAdapter() {
		if (iRelationItemProvider == null) {
			iRelationItemProvider = new IRelationItemProvider(this);
		}

		return iRelationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IRequirementItemProvider iRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIRequirementAdapter() {
		if (iRequirementItemProvider == null) {
			iRequirementItemProvider = new IRequirementItemProvider(this);
		}

		return iRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISendAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISendActionItemProvider iSendActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISendAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISendActionAdapter() {
		if (iSendActionItemProvider == null) {
			iSendActionItemProvider = new ISendActionItemProvider(this);
		}

		return iSendActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISequenceDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISequenceDiagramItemProvider iSequenceDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISequenceDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISequenceDiagramAdapter() {
		if (iSequenceDiagramItemProvider == null) {
			iSequenceDiagramItemProvider = new ISequenceDiagramItemProvider(this);
		}

		return iSequenceDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISlot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISlotItemProvider iSlotItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISlot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISlotAdapter() {
		if (iSlotItemProvider == null) {
			iSlotItemProvider = new ISlotItemProvider(this);
		}

		return iSlotItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IState} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStateItemProvider iStateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IState}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIStateAdapter() {
		if (iStateItemProvider == null) {
			iStateItemProvider = new IStateItemProvider(this);
		}

		return iStateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStateChartItemProvider iStateChartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIStateChartAdapter() {
		if (iStateChartItemProvider == null) {
			iStateChartItemProvider = new IStateChartItemProvider(this);
		}

		return iStateChartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChartDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStateChartDiagramItemProvider iStateChartDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChartDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIStateChartDiagramAdapter() {
		if (iStateChartDiagramItemProvider == null) {
			iStateChartDiagramItemProvider = new IStateChartDiagramItemProvider(this);
		}

		return iStateChartDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateVertex} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStateVertexItemProvider iStateVertexItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateVertex}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIStateVertexAdapter() {
		if (iStateVertexItemProvider == null) {
			iStateVertexItemProvider = new IStateVertexItemProvider(this);
		}

		return iStateVertexItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStereotype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStereotypeItemProvider iStereotypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStereotype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIStereotypeAdapter() {
		if (iStereotypeItemProvider == null) {
			iStereotypeItemProvider = new IStereotypeItemProvider(this);
		}

		return iStereotypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStructureDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IStructureDiagramItemProvider iStructureDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStructureDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIStructureDiagramAdapter() {
		if (iStructureDiagramItemProvider == null) {
			iStructureDiagramItemProvider = new IStructureDiagramItemProvider(this);
		}

		return iStructureDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISubsystem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISubsystemItemProvider iSubsystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISubsystem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISubsystemAdapter() {
		if (iSubsystemItemProvider == null) {
			iSubsystemItemProvider = new ISubsystemItemProvider(this);
		}

		return iSubsystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISwimlane} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISwimlaneItemProvider iSwimlaneItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISwimlane}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISwimlaneAdapter() {
		if (iSwimlaneItemProvider == null) {
			iSwimlaneItemProvider = new ISwimlaneItemProvider(this);
		}

		return iSwimlaneItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISysMLPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISysMLPortItemProvider iSysMLPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISysMLPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISysMLPortAdapter() {
		if (iSysMLPortItemProvider == null) {
			iSysMLPortItemProvider = new ISysMLPortItemProvider(this);
		}

		return iSysMLPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITableInstanceItemProvider iTableInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITableInstanceAdapter() {
		if (iTableInstanceItemProvider == null) {
			iTableInstanceItemProvider = new ITableInstanceItemProvider(this);
		}

		return iTableInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableLayout} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITableLayoutItemProvider iTableLayoutItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableLayout}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITableLayoutAdapter() {
		if (iTableLayoutItemProvider == null) {
			iTableLayoutItemProvider = new ITableLayoutItemProvider(this);
		}

		return iTableLayoutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITableViewItemProvider iTableViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITableViewAdapter() {
		if (iTableViewItemProvider == null) {
			iTableViewItemProvider = new ITableViewItemProvider(this);
		}

		return iTableViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITag} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITagItemProvider iTagItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITag}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITagAdapter() {
		if (iTagItemProvider == null) {
			iTagItemProvider = new ITagItemProvider(this);
		}

		return iTagItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInst} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITemplateInstItemProvider iTemplateInstItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInst}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITemplateInstAdapter() {
		if (iTemplateInstItemProvider == null) {
			iTemplateInstItemProvider = new ITemplateInstItemProvider(this);
		}

		return iTemplateInstItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstParam} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITemplateInstParamItemProvider iTemplateInstParamItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstParam}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITemplateInstParamAdapter() {
		if (iTemplateInstParamItemProvider == null) {
			iTemplateInstParamItemProvider = new ITemplateInstParamItemProvider(this);
		}

		return iTemplateInstParamItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITemplateInstantiationItemProvider iTemplateInstantiationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITemplateInstantiationAdapter() {
		if (iTemplateInstantiationItemProvider == null) {
			iTemplateInstantiationItemProvider = new ITemplateInstantiationItemProvider(this);
		}

		return iTemplateInstantiationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiationParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITemplateInstantiationParameterItemProvider iTemplateInstantiationParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiationParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITemplateInstantiationParameterAdapter() {
		if (iTemplateInstantiationParameterItemProvider == null) {
			iTemplateInstantiationParameterItemProvider = new ITemplateInstantiationParameterItemProvider(this);
		}

		return iTemplateInstantiationParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITemplateParameterItemProvider iTemplateParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITemplateParameterAdapter() {
		if (iTemplateParameterItemProvider == null) {
			iTemplateParameterItemProvider = new ITemplateParameterItemProvider(this);
		}

		return iTemplateParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITimeEventItemProvider iTimeEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITimeEventAdapter() {
		if (iTimeEventItemProvider == null) {
			iTimeEventItemProvider = new ITimeEventItemProvider(this);
		}

		return iTimeEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeout} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITimeoutItemProvider iTimeoutItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeout}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITimeoutAdapter() {
		if (iTimeoutItemProvider == null) {
			iTimeoutItemProvider = new ITimeoutItemProvider(this);
		}

		return iTimeoutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITransitionItemProvider iTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITransitionAdapter() {
		if (iTransitionItemProvider == null) {
			iTransitionItemProvider = new ITransitionItemProvider(this);
		}

		return iTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITrigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITriggerItemProvider iTriggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITrigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITriggerAdapter() {
		if (iTriggerItemProvider == null) {
			iTriggerItemProvider = new ITriggerItemProvider(this);
		}

		return iTriggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITriggered} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITriggeredItemProvider iTriggeredItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITriggered}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITriggeredAdapter() {
		if (iTriggeredItemProvider == null) {
			iTriggeredItemProvider = new ITriggeredItemProvider(this);
		}

		return iTriggeredItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ITypeItemProvider iTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createITypeAdapter() {
		if (iTypeItemProvider == null) {
			iTypeItemProvider = new ITypeItemProvider(this);
		}

		return iTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUCDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IUCDiagramItemProvider iucDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUCDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIUCDiagramAdapter() {
		if (iucDiagramItemProvider == null) {
			iucDiagramItemProvider = new IUCDiagramItemProvider(this);
		}

		return iucDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IUnitItemProvider iUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIUnitAdapter() {
		if (iUnitItemProvider == null) {
			iUnitItemProvider = new IUnitItemProvider(this);
		}

		return iUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IUseCaseItemProvider iUseCaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIUseCaseAdapter() {
		if (iUseCaseItemProvider == null) {
			iUseCaseItemProvider = new IUseCaseItemProvider(this);
		}

		return iUseCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IUseCaseDiagramItemProvider iUseCaseDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIUseCaseDiagramAdapter() {
		if (iUseCaseDiagramItemProvider == null) {
			iUseCaseDiagramItemProvider = new IUseCaseDiagramItemProvider(this);
		}

		return iUseCaseDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseStereoType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IUseCaseStereoTypeItemProvider iUseCaseStereoTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseStereoType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIUseCaseStereoTypeAdapter() {
		if (iUseCaseStereoTypeItemProvider == null) {
			iUseCaseStereoTypeItemProvider = new IUseCaseStereoTypeItemProvider(this);
		}

		return iUseCaseStereoTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IValueSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IValueSpecificationItemProvider iValueSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IValueSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIValueSpecificationAdapter() {
		if (iValueSpecificationItemProvider == null) {
			iValueSpecificationItemProvider = new IValueSpecificationItemProvider(this);
		}

		return iValueSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IVariable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IVariableItemProvider iVariableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIVariableAdapter() {
		if (iVariableItemProvider == null) {
			iVariableItemProvider = new IVariableItemProvider(this);
		}

		return iVariableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TableDataDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableDataDefinitionItemProvider tableDataDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TableDataDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTableDataDefinitionAdapter() {
		if (tableDataDefinitionItemProvider == null) {
			tableDataDefinitionItemProvider = new TableDataDefinitionItemProvider(this);
		}

		return tableDataDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UnknownType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnknownTypeItemProvider unknownTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UnknownType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnknownTypeAdapter() {
		if (unknownTypeItemProvider == null) {
			unknownTypeItemProvider = new UnknownTypeItemProvider(this);
		}

		return unknownTypeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (cCollaborationChartItemProvider != null) cCollaborationChartItemProvider.dispose();
		if (cgiActionStateItemProvider != null) cgiActionStateItemProvider.dispose();
		if (cgiActiveXItemProvider != null) cgiActiveXItemProvider.dispose();
		if (cgiAnchorItemProvider != null) cgiAnchorItemProvider.dispose();
		if (cgiAnnotationItemProvider != null) cgiAnnotationItemProvider.dispose();
		if (cgiArrowItemProvider != null) cgiArrowItemProvider.dispose();
		if (cgiAssociationEndItemProvider != null) cgiAssociationEndItemProvider.dispose();
		if (cgiAssociationRoleItemProvider != null) cgiAssociationRoleItemProvider.dispose();
		if (cgiBasicClassItemProvider != null) cgiBasicClassItemProvider.dispose();
		if (cgiBlockStateItemProvider != null) cgiBlockStateItemProvider.dispose();
		if (cgiBoxItemProvider != null) cgiBoxItemProvider.dispose();
		if (cgiButtonArrayItemProvider != null) cgiButtonArrayItemProvider.dispose();
		if (cgiClassItemProvider != null) cgiClassItemProvider.dispose();
		if (cgiClassChartItemProvider != null) cgiClassChartItemProvider.dispose();
		if (cgiClassifierRoleItemProvider != null) cgiClassifierRoleItemProvider.dispose();
		if (cgiCompartmentItemProvider != null) cgiCompartmentItemProvider.dispose();
		if (cgiComponentItemProvider != null) cgiComponentItemProvider.dispose();
		if (cgiCompositeClassItemProvider != null) cgiCompositeClassItemProvider.dispose();
		if (cgiConnectorItemProvider != null) cgiConnectorItemProvider.dispose();
		if (cgiContainArrowItemProvider != null) cgiContainArrowItemProvider.dispose();
		if (cgiDiagramFrameItemProvider != null) cgiDiagramFrameItemProvider.dispose();
		if (cgiFreeShapeItemProvider != null) cgiFreeShapeItemProvider.dispose();
		if (cgiFreeTextItemProvider != null) cgiFreeTextItemProvider.dispose();
		if (cgiGenericElementItemProvider != null) cgiGenericElementItemProvider.dispose();
		if (cgiImageItemProvider != null) cgiImageItemProvider.dispose();
		if (cgiImageDataItemProvider != null) cgiImageDataItemProvider.dispose();
		if (cgiInformationFlowItemProvider != null) cgiInformationFlowItemProvider.dispose();
		if (cgiInheritanceItemProvider != null) cgiInheritanceItemProvider.dispose();
		if (cgimfcCtrlItemProvider != null) cgimfcCtrlItemProvider.dispose();
		if (cgiMessageLabelItemProvider != null) cgiMessageLabelItemProvider.dispose();
		if (cgiMscChartItemProvider != null) cgiMscChartItemProvider.dispose();
		if (cgiMscColumnCRItemProvider != null) cgiMscColumnCRItemProvider.dispose();
		if (cgiMscConditionMarkItemProvider != null) cgiMscConditionMarkItemProvider.dispose();
		if (cgiMscExecutionOccurrenceItemProvider != null) cgiMscExecutionOccurrenceItemProvider.dispose();
		if (cgiMscInteractionOccurrenceItemProvider != null) cgiMscInteractionOccurrenceItemProvider.dispose();
		if (cgiMscInteractionOperandItemProvider != null) cgiMscInteractionOperandItemProvider.dispose();
		if (cgiMscInteractionOperatorItemProvider != null) cgiMscInteractionOperatorItemProvider.dispose();
		if (cgiMscMessageItemProvider != null) cgiMscMessageItemProvider.dispose();
		if (cgiObjectInstanceItemProvider != null) cgiObjectInstanceItemProvider.dispose();
		if (cgiObjectLinkItemProvider != null) cgiObjectLinkItemProvider.dispose();
		if (cgiPackageItemProvider != null) cgiPackageItemProvider.dispose();
		if (cgiPartitionItemProvider != null) cgiPartitionItemProvider.dispose();
		if (cgiPortConnectorItemProvider != null) cgiPortConnectorItemProvider.dispose();
		if (cgiStateItemProvider != null) cgiStateItemProvider.dispose();
		if (cgiStateChartItemProvider != null) cgiStateChartItemProvider.dispose();
		if (cgiSwimlaneFrameItemProvider != null) cgiSwimlaneFrameItemProvider.dispose();
		if (cgiTextItemProvider != null) cgiTextItemProvider.dispose();
		if (cgiTextBoxItemProvider != null) cgiTextBoxItemProvider.dispose();
		if (cgiTransItemProvider != null) cgiTransItemProvider.dispose();
		if (collEventItemProvider != null) collEventItemProvider.dispose();
		if (iAcceptEventActionItemProvider != null) iAcceptEventActionItemProvider.dispose();
		if (iAcceptTimeEventItemProvider != null) iAcceptTimeEventItemProvider.dispose();
		if (iActionItemProvider != null) iActionItemProvider.dispose();
		if (iActivityDiagramItemProvider != null) iActivityDiagramItemProvider.dispose();
		if (iActivityGraphItemProvider != null) iActivityGraphItemProvider.dispose();
		if (iActorItemProvider != null) iActorItemProvider.dispose();
		if (iAnchorItemProvider != null) iAnchorItemProvider.dispose();
		if (iAnnotationItemProvider != null) iAnnotationItemProvider.dispose();
		if (iArgumentItemProvider != null) iArgumentItemProvider.dispose();
		if (iAssociationClassItemProvider != null) iAssociationClassItemProvider.dispose();
		if (iAssociationEndItemProvider != null) iAssociationEndItemProvider.dispose();
		if (iAssociationEndHandleItemProvider != null) iAssociationEndHandleItemProvider.dispose();
		if (iAssociationRoleItemProvider != null) iAssociationRoleItemProvider.dispose();
		if (iAttributeItemProvider != null) iAttributeItemProvider.dispose();
		if (iBlockItemProvider != null) iBlockItemProvider.dispose();
		if (iBodyItemProvider != null) iBodyItemProvider.dispose();
		if (iBranchItemProvider != null) iBranchItemProvider.dispose();
		if (iCallActionItemProvider != null) iCallActionItemProvider.dispose();
		if (iCallOperationItemProvider != null) iCallOperationItemProvider.dispose();
		if (iClassItemProvider != null) iClassItemProvider.dispose();
		if (iClassHandleItemProvider != null) iClassHandleItemProvider.dispose();
		if (iClassInstanceItemProvider != null) iClassInstanceItemProvider.dispose();
		if (iClassifierItemProvider != null) iClassifierItemProvider.dispose();
		if (iClassifierRoleItemProvider != null) iClassifierRoleItemProvider.dispose();
		if (iCodeGenConfigInfoItemProvider != null) iCodeGenConfigInfoItemProvider.dispose();
		if (iCodeGenConfigInfoHandleItemProvider != null) iCodeGenConfigInfoHandleItemProvider.dispose();
		if (iCollaborationItemProvider != null) iCollaborationItemProvider.dispose();
		if (iCollaborationDiagramItemProvider != null) iCollaborationDiagramItemProvider.dispose();
		if (iColorItemProvider != null) iColorItemProvider.dispose();
		if (iCombinedFragmentItemProvider != null) iCombinedFragmentItemProvider.dispose();
		if (iCommentItemProvider != null) iCommentItemProvider.dispose();
		if (iComponentItemProvider != null) iComponentItemProvider.dispose();
		if (iComponentDiagramItemProvider != null) iComponentDiagramItemProvider.dispose();
		if (iComponentInstanceItemProvider != null) iComponentInstanceItemProvider.dispose();
		if (iConfigurationItemProvider != null) iConfigurationItemProvider.dispose();
		if (iConnectorItemProvider != null) iConnectorItemProvider.dispose();
		if (iConstraintItemProvider != null) iConstraintItemProvider.dispose();
		if (iConstructorItemProvider != null) iConstructorItemProvider.dispose();
		if (iContextSpecificationItemProvider != null) iContextSpecificationItemProvider.dispose();
		if (iControlledFileItemProvider != null) iControlledFileItemProvider.dispose();
		if (iDefaultDrvdTransItemProvider != null) iDefaultDrvdTransItemProvider.dispose();
		if (iDependencyItemProvider != null) iDependencyItemProvider.dispose();
		if (iDeploymentDiagramItemProvider != null) iDeploymentDiagramItemProvider.dispose();
		if (iDescriptionItemProvider != null) iDescriptionItemProvider.dispose();
		if (iDestructorItemProvider != null) iDestructorItemProvider.dispose();
		if (iDiagramItemProvider != null) iDiagramItemProvider.dispose();
		if (iEmbededFileItemProvider != null) iEmbededFileItemProvider.dispose();
		if (iEnumerationLiteralItemProvider != null) iEnumerationLiteralItemProvider.dispose();
		if (iEventItemProvider != null) iEventItemProvider.dispose();
		if (iEventHandleItemProvider != null) iEventHandleItemProvider.dispose();
		if (iEventReceptionItemProvider != null) iEventReceptionItemProvider.dispose();
		if (iExecutionOccurrenceItemProvider != null) iExecutionOccurrenceItemProvider.dispose();
		if (iExternalHyperlinkItemProvider != null) iExternalHyperlinkItemProvider.dispose();
		if (iFileItemProvider != null) iFileItemProvider.dispose();
		if (iFileFragmentItemProvider != null) iFileFragmentItemProvider.dispose();
		if (iFlowItemProvider != null) iFlowItemProvider.dispose();
		if (iFlowItemItemProvider != null) iFlowItemItemProvider.dispose();
		if (iFlowchartItemProvider != null) iFlowchartItemProvider.dispose();
		if (iFolderItemProvider != null) iFolderItemProvider.dispose();
		if (iForkItemProvider != null) iForkItemProvider.dispose();
		if (iGeneralizationItemProvider != null) iGeneralizationItemProvider.dispose();
		if (iGuardItemProvider != null) iGuardItemProvider.dispose();
		if (iHandleWithDataItemProvider != null) iHandleWithDataItemProvider.dispose();
		if (iHistoryConnectorItemProvider != null) iHistoryConnectorItemProvider.dispose();
		if (iHyperLinkItemProvider != null) iHyperLinkItemProvider.dispose();
		if (iInformationFlowItemProvider != null) iInformationFlowItemProvider.dispose();
		if (iInformationItemItemProvider != null) iInformationItemItemProvider.dispose();
		if (iInstanceItemProvider != null) iInstanceItemProvider.dispose();
		if (iInstanceSlotItemProvider != null) iInstanceSlotItemProvider.dispose();
		if (iInstanceSpecificationItemProvider != null) iInstanceSpecificationItemProvider.dispose();
		if (iInstanceValueItemProvider != null) iInstanceValueItemProvider.dispose();
		if (iInteractionOccurrenceItemProvider != null) iInteractionOccurrenceItemProvider.dispose();
		if (iInteractionOperandItemProvider != null) iInteractionOperandItemProvider.dispose();
		if (iInteractionOperatorItemProvider != null) iInteractionOperatorItemProvider.dispose();
		if (iInterfaceItemItemProvider != null) iInterfaceItemItemProvider.dispose();
		if (iInterfaceItemTriggerItemProvider != null) iInterfaceItemTriggerItemProvider.dispose();
		if (iInternalHyperlinkItemProvider != null) iInternalHyperlinkItemProvider.dispose();
		if (iLabelItemProvider != null) iLabelItemProvider.dispose();
		if (iLinkItemProvider != null) iLinkItemProvider.dispose();
		if (iLinkInstanceItemProvider != null) iLinkInstanceItemProvider.dispose();
		if (iLiteralSpecificationItemProvider != null) iLiteralSpecificationItemProvider.dispose();
		if (imHyperLinkItemProvider != null) imHyperLinkItemProvider.dispose();
		if (imscItemProvider != null) imscItemProvider.dispose();
		if (iMatrixInstanceItemProvider != null) iMatrixInstanceItemProvider.dispose();
		if (iMatrixLayoutItemProvider != null) iMatrixLayoutItemProvider.dispose();
		if (iMatrixViewItemProvider != null) iMatrixViewItemProvider.dispose();
		if (iMessageItemProvider != null) iMessageItemProvider.dispose();
		if (iMessagePointItemProvider != null) iMessagePointItemProvider.dispose();
		if (iMetaLinkHandleItemProvider != null) iMetaLinkHandleItemProvider.dispose();
		if (iModelElementItemProvider != null) iModelElementItemProvider.dispose();
		if (iModuleItemProvider != null) iModuleItemProvider.dispose();
		if (iMultiplicityItemItemProvider != null) iMultiplicityItemItemProvider.dispose();
		if (iNodeItemProvider != null) iNodeItemProvider.dispose();
		if (iObjectLinkItemProvider != null) iObjectLinkItemProvider.dispose();
		if (iObjectLinkHandleItemProvider != null) iObjectLinkHandleItemProvider.dispose();
		if (iObjectModelDiagramItemProvider != null) iObjectModelDiagramItemProvider.dispose();
		if (iObjectNodeItemProvider != null) iObjectNodeItemProvider.dispose();
		if (iOperationItemProvider != null) iOperationItemProvider.dispose();
		if (iPackageItemProvider != null) iPackageItemProvider.dispose();
		if (iPanelDiagramItemProvider != null) iPanelDiagramItemProvider.dispose();
		if (iPartItemProvider != null) iPartItemProvider.dispose();
		if (iPinItemProvider != null) iPinItemProvider.dispose();
		if (iPortItemProvider != null) iPortItemProvider.dispose();
		if (iPrimitiveOperationItemProvider != null) iPrimitiveOperationItemProvider.dispose();
		if (iProfileItemProvider != null) iProfileItemProvider.dispose();
		if (iProjectItemProvider != null) iProjectItemProvider.dispose();
		if (iPropertyItemProvider != null) iPropertyItemProvider.dispose();
		if (iPropertyContainerItemProvider != null) iPropertyContainerItemProvider.dispose();
		if (iPropertyMetaclassItemProvider != null) iPropertyMetaclassItemProvider.dispose();
		if (iPropertySubjectItemProvider != null) iPropertySubjectItemProvider.dispose();
		if (iReceptionItemProvider != null) iReceptionItemProvider.dispose();
		if (iReferenceActivityItemProvider != null) iReferenceActivityItemProvider.dispose();
		if (iRelationItemProvider != null) iRelationItemProvider.dispose();
		if (iRequirementItemProvider != null) iRequirementItemProvider.dispose();
		if (iSendActionItemProvider != null) iSendActionItemProvider.dispose();
		if (iSequenceDiagramItemProvider != null) iSequenceDiagramItemProvider.dispose();
		if (iSlotItemProvider != null) iSlotItemProvider.dispose();
		if (iStateItemProvider != null) iStateItemProvider.dispose();
		if (iStateChartItemProvider != null) iStateChartItemProvider.dispose();
		if (iStateChartDiagramItemProvider != null) iStateChartDiagramItemProvider.dispose();
		if (iStateVertexItemProvider != null) iStateVertexItemProvider.dispose();
		if (iStereotypeItemProvider != null) iStereotypeItemProvider.dispose();
		if (iStructureDiagramItemProvider != null) iStructureDiagramItemProvider.dispose();
		if (iSubsystemItemProvider != null) iSubsystemItemProvider.dispose();
		if (iSwimlaneItemProvider != null) iSwimlaneItemProvider.dispose();
		if (iSysMLPortItemProvider != null) iSysMLPortItemProvider.dispose();
		if (iTableInstanceItemProvider != null) iTableInstanceItemProvider.dispose();
		if (iTableLayoutItemProvider != null) iTableLayoutItemProvider.dispose();
		if (iTableViewItemProvider != null) iTableViewItemProvider.dispose();
		if (iTagItemProvider != null) iTagItemProvider.dispose();
		if (iTemplateInstItemProvider != null) iTemplateInstItemProvider.dispose();
		if (iTemplateInstParamItemProvider != null) iTemplateInstParamItemProvider.dispose();
		if (iTemplateInstantiationItemProvider != null) iTemplateInstantiationItemProvider.dispose();
		if (iTemplateInstantiationParameterItemProvider != null) iTemplateInstantiationParameterItemProvider.dispose();
		if (iTemplateParameterItemProvider != null) iTemplateParameterItemProvider.dispose();
		if (iTimeEventItemProvider != null) iTimeEventItemProvider.dispose();
		if (iTimeoutItemProvider != null) iTimeoutItemProvider.dispose();
		if (iTransitionItemProvider != null) iTransitionItemProvider.dispose();
		if (iTriggerItemProvider != null) iTriggerItemProvider.dispose();
		if (iTriggeredItemProvider != null) iTriggeredItemProvider.dispose();
		if (iTypeItemProvider != null) iTypeItemProvider.dispose();
		if (iucDiagramItemProvider != null) iucDiagramItemProvider.dispose();
		if (iUnitItemProvider != null) iUnitItemProvider.dispose();
		if (iUseCaseItemProvider != null) iUseCaseItemProvider.dispose();
		if (iUseCaseDiagramItemProvider != null) iUseCaseDiagramItemProvider.dispose();
		if (iUseCaseStereoTypeItemProvider != null) iUseCaseStereoTypeItemProvider.dispose();
		if (iValueSpecificationItemProvider != null) iValueSpecificationItemProvider.dispose();
		if (iVariableItemProvider != null) iVariableItemProvider.dispose();
		if (tableDataDefinitionItemProvider != null) tableDataDefinitionItemProvider.dispose();
		if (unknownTypeItemProvider != null) unknownTypeItemProvider.dispose();
	}

}
